/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.server.SimpleServerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUDPServer {
    private static Logger LOG = LoggerFactory.getLogger(SimpleUDPServer.class);
    private static int DEFAULT_TEST_PORT = 8888;
    private Thread m_serverThread = null;
    private int m_timeout;
    private DatagramSocket m_socket;
    private List<Exchange> m_conversation = new ArrayList<Exchange>();
    private int m_port = DEFAULT_TEST_PORT;
    private InetAddress m_testInetAddress;
    private SimpleServerRunnable m_runnable;

    public void onInit() {
    }

    public void startServer() throws IOException {
        this.m_runnable = this.getRunnable();
        this.m_serverThread = new Thread((Runnable)this.m_runnable, this.getClass().getSimpleName());
        this.m_serverThread.start();
        try {
            this.m_runnable.awaitStartup();
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while shutting down.", (Throwable)e);
        }
    }

    public void stopServer() throws IOException {
        IOUtils.closeQuietly((Closeable)this.getServerSocket());
        IOUtils.closeQuietly((Closeable)this.m_socket);
        if (this.m_serverThread != null && this.m_serverThread.isAlive()) {
            this.m_serverThread.interrupt();
        }
        try {
            this.m_runnable.awaitShutdown();
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while shutting down.", (Throwable)e);
        }
    }

    private DatagramSocket getServerSocket() {
        return this.m_socket;
    }

    public SimpleServerRunnable getRunnable() throws IOException {
        return new SimpleServerRunnable(){

            @Override
            public void run() {
                try {
                    SimpleUDPServer.this.m_socket = new DatagramSocket(SimpleUDPServer.this.getPort(), SimpleUDPServer.this.getInetAddress());
                    SimpleUDPServer.this.m_socket.setSoTimeout(SimpleUDPServer.this.getTimeout());
                    this.ready();
                    SimpleUDPServer.this.attemptConversation(SimpleUDPServer.this.m_socket);
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)SimpleUDPServer.this.m_socket);
                    this.finished();
                    try {
                        SimpleUDPServer.this.stopServer();
                    }
                    catch (Exception e) {
                        LOG.info("error while stopping server", (Throwable)e);
                    }
                }
            }
        };
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    protected boolean attemptConversation(DatagramSocket socket) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.processRequest(socket)) {
                return false;
            }
            if (ex.sendReply(socket)) continue;
            return false;
        }
        return true;
    }

    protected void addRequestResponse(DatagramPacket request, byte[] response) {
        this.m_conversation.add(new SimpleServerExchange(this.recievedPacket(request), Arrays.copyOf(response, response.length)));
    }

    protected RequestMatcher recievedPacket(DatagramPacket request) {
        return new RequestMatcher(){

            @Override
            public boolean matches(DatagramPacket packet) {
                return packet != null;
            }
        };
    }

    public void setInetAddress(InetAddress testInetAddress) {
        this.m_testInetAddress = testInetAddress;
    }

    public InetAddress getInetAddress() {
        if (this.m_testInetAddress == null) {
            return InetAddressUtils.getLocalHostAddress();
        }
        return this.m_testInetAddress;
    }

    public static class SimpleServerExchange
    implements Exchange {
        private byte[] m_response;
        private RequestMatcher m_requestMatcher;
        private int m_responsePort;
        private InetAddress m_responseAddress;

        public SimpleServerExchange(RequestMatcher requestMatcher, byte[] response) {
            this.m_response = response;
            this.m_requestMatcher = requestMatcher;
        }

        @Override
        public boolean processRequest(DatagramSocket socket) throws IOException {
            byte[] data = new byte[512];
            DatagramPacket packet = new DatagramPacket(data, data.length, socket.getLocalAddress(), socket.getLocalPort());
            socket.receive(packet);
            this.setResponsePort(packet.getPort());
            this.setResponseAddress(packet.getAddress());
            return this.m_requestMatcher.matches(packet);
        }

        @Override
        public boolean sendReply(DatagramSocket socket) throws IOException {
            DatagramPacket packet = new DatagramPacket(this.m_response, this.m_response.length, this.getResponseAddress(), this.getResponsePort());
            socket.send(packet);
            return true;
        }

        public void setResponsePort(int responsePort) {
            this.m_responsePort = responsePort;
        }

        public int getResponsePort() {
            return this.m_responsePort;
        }

        public void setResponseAddress(InetAddress responseAddress) {
            this.m_responseAddress = responseAddress;
        }

        public InetAddress getResponseAddress() {
            return this.m_responseAddress;
        }
    }

    public static interface Exchange {
        public boolean sendReply(DatagramSocket var1) throws IOException;

        public boolean processRequest(DatagramSocket var1) throws IOException;
    }

    public static interface RequestMatcher {
        public boolean matches(DatagramPacket var1);
    }
}

