/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server.exchange;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.server.exchange.Conversation;
import org.opennms.netmgt.provision.server.exchange.Exchange;
import org.opennms.netmgt.provision.server.exchange.RequestHandler;
import org.opennms.netmgt.provision.server.exchange.ResponseHandler;

public class SimpleConversationEndPoint {
    protected Conversation m_conversation;
    private int m_timeout;

    public void init() throws Exception {
        this.m_conversation = new Conversation();
    }

    public void onInit() {
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    protected ResponseHandler startsWith(final String prefix) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.startsWith(prefix);
            }
        };
    }

    protected ResponseHandler contains(final String phrase) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.contains(phrase);
            }
        };
    }

    protected ResponseHandler matches(final String regex) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.matches(regex);
            }
        };
    }

    protected void addResponseHandler(ResponseHandler responseHandler, RequestHandler requestHandler) {
        this.m_conversation.addExchange(new SimpleExchange(responseHandler, requestHandler));
    }

    protected RequestHandler singleLineRequest(final String request) {
        return new RequestHandler(){

            public void doRequest(OutputStream out) throws IOException {
                out.write(String.format("%s\r\n", request).getBytes());
            }
        };
    }

    protected RequestHandler multilineLineRequest(final String[] request) {
        return new RequestHandler(){

            public void doRequest(OutputStream out) throws IOException {
                for (int i = 0; i < request.length; ++i) {
                    out.write(String.format("%s\r\n", request[i]).getBytes());
                }
            }
        };
    }

    public static class SimpleExchange
    implements Exchange {
        private ResponseHandler m_responseHandler;
        private RequestHandler m_requestHandler;

        public SimpleExchange(ResponseHandler responseHandler, RequestHandler requestHandler) {
            this.setResponseHandler(responseHandler);
            this.setRequestHandler(requestHandler);
        }

        public boolean matchResponseByString(String response) {
            return this.getResponseHandler().matches(response);
        }

        public boolean processResponse(BufferedReader in) throws IOException {
            String input = in.readLine();
            LogUtils.infof((Object)this, (String)("SimpleExchange response: " + input), (Object[])new Object[0]);
            if (input == null) {
                return false;
            }
            return this.matchResponseByString(input);
        }

        public boolean sendRequest(OutputStream out) throws IOException {
            if (this.getRequestHandler() != null) {
                this.getRequestHandler().doRequest(out);
            }
            return true;
        }

        public void setResponseHandler(ResponseHandler responseHandler) {
            this.m_responseHandler = responseHandler;
        }

        public ResponseHandler getResponseHandler() {
            return this.m_responseHandler;
        }

        public void setRequestHandler(RequestHandler requestHandler) {
            this.m_requestHandler = requestHandler;
        }

        public RequestHandler getRequestHandler() {
            return this.m_requestHandler;
        }
    }
}

