/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server.exchange;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.server.exchange.Exchange;
import org.opennms.netmgt.provision.server.exchange.ResponseHandler;

public class Conversation {
    private List<Exchange> m_conversation = new ArrayList<Exchange>();
    private Exchange m_errorExchange = new ErrorExchange();

    public void addExchange(Exchange exchange) {
        this.m_conversation.add(exchange);
    }

    public void addErrorExchange(Exchange ex) {
        this.m_errorExchange = ex;
    }

    public void attemptServerConversation(BufferedReader in, OutputStream out) throws Exception {
        boolean isFinished = false;
        while (!isFinished) {
            try {
                if (this.m_conversation.size() == 0) {
                    return;
                }
                String line = in.readLine();
                LogUtils.infof((Object)this, (String)("Server line read: " + line), (Object[])new Object[0]);
                if (line == null) {
                    return;
                }
                Exchange ex = this.findMatchingExchange(line);
                if (ex == null) {
                    this.m_errorExchange.sendRequest(out);
                    continue;
                }
                if (ex.sendRequest(out)) continue;
                this.m_errorExchange.sendRequest(out);
            }
            catch (Exception e) {
                isFinished = true;
                this.info(e, "SimpleServer conversation attempt failed", new Object[0]);
            }
        }
    }

    public boolean attemptClientConversation(BufferedReader in, OutputStream out) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.processResponse(in)) {
                return false;
            }
            LogUtils.infof((Object)this, (String)"processed response successfully", (Object[])new Object[0]);
            if (!ex.sendRequest(out)) {
                return false;
            }
            LogUtils.infof((Object)this, (String)"send request if there was a request", (Object[])new Object[0]);
        }
        return true;
    }

    private Exchange findMatchingExchange(String input) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.matchResponseByString(input)) continue;
            return ex;
        }
        return null;
    }

    public ResponseHandler startsWith(final String response) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.startsWith(response);
            }
        };
    }

    public ResponseHandler contains(final String response) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.contains(response);
            }
        };
    }

    public ResponseHandler regexpMatches(final String response) {
        return new ResponseHandler(){

            public boolean matches(String input) {
                return input.matches(response);
            }
        };
    }

    private void info(Throwable t, String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info(String.format(format, args), t);
        }
    }

    public static class ErrorExchange
    implements Exchange {
        private String m_errorString = "DEFAULT ERROR STRING: YOU HAVE NOT IMPLEMENTED AN ERROR EXCHANGE";

        public boolean matchResponseByString(String response) {
            return false;
        }

        public boolean processResponse(BufferedReader in) throws IOException {
            return true;
        }

        public boolean sendRequest(OutputStream out) throws IOException {
            out.write(String.format("%s\r\n", this.m_errorString).getBytes());
            return true;
        }
    }
}

