/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.server.exchange.Exchange;
import org.opennms.netmgt.provision.server.exchange.RequestHandler;
import org.opennms.netmgt.provision.server.exchange.SimpleConversationEndPoint;

public class SimpleServer
extends SimpleConversationEndPoint {
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private int m_threadSleepLength = 0;
    private Socket m_socket;
    private String m_banner;
    protected volatile boolean m_stopped;

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }

    public InetAddress getInetAddress() {
        return this.getServerSocket().getInetAddress();
    }

    public int getLocalPort() {
        return this.getServerSocket().getLocalPort();
    }

    public void setThreadSleepLength(int timeout) {
        this.m_threadSleepLength = timeout;
    }

    public int getThreadSleepLength() {
        return this.m_threadSleepLength;
    }

    public void init() throws Exception {
        super.init();
        this.setServerSocket(new ServerSocket());
        this.getServerSocket().bind(null);
        this.onInit();
    }

    public void onInit() {
    }

    public void startServer() throws Exception {
        this.setServerThread(new Thread(this.getRunnable(), this.getClass().getSimpleName()));
        this.getServerThread().start();
    }

    public void stopServer() throws IOException {
        this.m_stopped = true;
        this.getServerSocket().close();
        if (this.getServerThread() != null && this.getServerThread().isAlive() && this.getSocket() != null && !this.getSocket().isClosed()) {
            this.getSocket().close();
        }
    }

    public void dispose() {
    }

    protected Runnable getRunnable() throws Exception {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (SimpleServer.this.getTimeout() > 0) {
                        SimpleServer.this.getServerSocket().setSoTimeout(SimpleServer.this.getTimeout());
                    }
                    while (!SimpleServer.this.m_stopped) {
                        SimpleServer.this.setSocket(SimpleServer.this.getServerSocket().accept());
                        if (SimpleServer.this.m_threadSleepLength > 0) {
                            Thread.sleep(SimpleServer.this.m_threadSleepLength);
                        }
                        if (SimpleServer.this.getTimeout() > 0) {
                            SimpleServer.this.getSocket().setSoTimeout(SimpleServer.this.getTimeout());
                        }
                        OutputStream out = SimpleServer.this.getSocket().getOutputStream();
                        if (SimpleServer.this.getBanner() != null) {
                            SimpleServer.this.sendBanner(out);
                        }
                        BufferedReader in = new BufferedReader(new InputStreamReader(SimpleServer.this.getSocket().getInputStream()));
                        SimpleServer.this.attemptConversation(in, out);
                    }
                }
                catch (Exception e) {
                    SimpleServer.this.info(e, "SimpleServer Exception on conversation", new Object[0]);
                }
                finally {
                    try {
                        SimpleServer.this.stopServer();
                    }
                    catch (IOException e) {
                        SimpleServer.this.info(e, "SimpleServer Exception on stopping server", new Object[0]);
                    }
                }
            }
        };
    }

    protected void sendBanner(OutputStream out) throws IOException {
        out.write(String.format("%s\r\n", this.getBanner()).getBytes());
    }

    protected boolean attemptConversation(BufferedReader in, OutputStream out) throws Exception {
        this.m_conversation.attemptServerConversation(in, out);
        return true;
    }

    protected void addErrorHandler(RequestHandler requestHandler) {
        this.m_conversation.addErrorExchange(new ServerErrorExchange(requestHandler));
    }

    protected RequestHandler errorString(final String error) {
        return new RequestHandler(){

            public void doRequest(OutputStream out) throws IOException {
                out.write(String.format("%s\r\n", error).getBytes());
            }
        };
    }

    protected RequestHandler shutdownServer(final String response) {
        return new RequestHandler(){

            public void doRequest(OutputStream out) throws IOException {
                out.write(String.format("%s\r\n", response).getBytes());
                SimpleServer.this.stopServer();
            }
        };
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.m_serverSocket = serverSocket;
    }

    public ServerSocket getServerSocket() {
        return this.m_serverSocket;
    }

    public void setSocket(Socket socket) {
        this.m_socket = socket;
    }

    public Socket getSocket() {
        return this.m_socket;
    }

    protected void setServerThread(Thread serverThread) {
        this.m_serverThread = serverThread;
    }

    protected Thread getServerThread() {
        return this.m_serverThread;
    }

    private void info(Throwable t, String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isInfoEnabled()) {
            log.info(String.format(format, args), t);
        }
    }

    public static class ServerErrorExchange
    implements Exchange {
        protected RequestHandler m_errorRequest;

        public ServerErrorExchange(RequestHandler requestHandler) {
            this.m_errorRequest = requestHandler;
        }

        public boolean matchResponseByString(String response) {
            return false;
        }

        public boolean processResponse(BufferedReader in) throws IOException {
            return false;
        }

        public boolean sendRequest(OutputStream out) throws IOException {
            this.m_errorRequest.doRequest(out);
            return false;
        }
    }
}

