/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.server.exchange.LineConversation;

public class SimpleServerHandler
extends IoHandlerAdapter {
    private LineConversation m_conversation;

    public SimpleServerHandler(LineConversation conversation) {
        this.m_conversation = conversation;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LogUtils.warnf((Object)((Object)this), (Throwable)cause, (String)"An error was caught in session %s", (Object[])new Object[]{session});
    }

    public void sessionOpened(IoSession session) throws Exception {
        LogUtils.infof((Object)((Object)this), (String)"Session opened", (Object[])new Object[0]);
        if (this.m_conversation != null && this.m_conversation.hasBanner()) {
            LogUtils.infof((Object)((Object)this), (String)"Sending Banner: %s \n", (Object[])new Object[]{this.m_conversation.getBanner()});
            session.write((Object)this.m_conversation.getBanner());
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        LogUtils.infof((Object)((Object)this), (String)"Server received: %s\n", (Object[])new Object[]{message.toString().trim()});
        String str = message.toString();
        if (str.trim().equalsIgnoreCase(this.m_conversation.getExpectedClose())) {
            if (this.m_conversation.getExpectedCloseResponse() != null) {
                session.write((Object)this.m_conversation.getExpectedCloseResponse());
            }
            if (!session.close(false).await(500L)) {
                LogUtils.warnf((Object)((Object)this), (String)"Conversation did not complete promptly in 500ms", (Object[])new Object[0]);
            }
            return;
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        LogUtils.infof((Object)((Object)this), (String)("IDLE " + session.getIdleCount(status)), (Object[])new Object[0]);
    }
}

