/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.LogUtils;

public abstract class AbstractSimpleServer {
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private Socket m_socket;
    private int m_timeout;
    private List<Exchange> m_conversation = new ArrayList<Exchange>();

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public InetAddress getInetAddress() {
        return this.m_serverSocket.getInetAddress();
    }

    public int getLocalPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public final void init() throws Exception {
        this.m_serverSocket = new ServerSocket();
        this.m_serverSocket.bind(null);
        this.onInit();
        this.startServer();
    }

    protected void onInit() {
    }

    public void startServer() throws Exception {
        this.m_serverThread = new Thread(this.getRunnable(), this.getClass().getSimpleName());
        this.m_serverThread.start();
    }

    public Runnable getRunnable() throws Exception {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractSimpleServer.this.m_serverSocket.setSoTimeout(AbstractSimpleServer.this.getTimeout());
                    AbstractSimpleServer.this.m_socket = AbstractSimpleServer.this.m_serverSocket.accept();
                    OutputStream out = AbstractSimpleServer.this.m_socket.getOutputStream();
                    BufferedReader in = new BufferedReader(new InputStreamReader(AbstractSimpleServer.this.m_socket.getInputStream()));
                    AbstractSimpleServer.this.attemptConversation(in, out);
                    AbstractSimpleServer.this.m_socket.close();
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        };
    }

    protected boolean attemptConversation(BufferedReader in, OutputStream out) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.processRequest(in)) {
                return false;
            }
            if (ex.sendReply(out)) continue;
            return false;
        }
        return true;
    }

    protected void setExpectedBanner(String banner) {
        this.m_conversation.add(new BannerExchange(banner));
    }

    protected void addRequestResponse(String request, String response) {
        this.m_conversation.add(new SimpleServerExchange(this.regexpMatches(request), response));
    }

    protected RequestMatcher regexpMatches(final String regex) {
        return new RequestMatcher(){

            @Override
            public boolean matches(String input) {
                return input.matches(regex);
            }
        };
    }

    public static class SimpleServerExchange
    implements Exchange {
        private String m_response;
        private RequestMatcher m_requestMatcher;

        public SimpleServerExchange(RequestMatcher requestMatcher, String response) {
            this.m_response = response;
            this.m_requestMatcher = requestMatcher;
        }

        @Override
        public boolean processRequest(BufferedReader in) throws IOException {
            String line = in.readLine();
            LogUtils.infof((Object)this, (String)("processing request: " + line), (Object[])new Object[0]);
            if (line == null) {
                return false;
            }
            return this.m_requestMatcher.matches(line);
        }

        @Override
        public boolean sendReply(OutputStream out) throws IOException {
            LogUtils.infof((Object)this, (String)("writing output: " + this.m_response), (Object[])new Object[0]);
            out.write(String.format("%s\r\n", this.m_response).getBytes());
            return false;
        }
    }

    public static class BannerExchange
    implements Exchange {
        private String m_banner;

        public BannerExchange(String banner) {
            this.m_banner = banner;
        }

        @Override
        public boolean processRequest(BufferedReader in) throws IOException {
            return true;
        }

        @Override
        public boolean sendReply(OutputStream out) throws IOException {
            out.write(String.format("%s\r\n", this.m_banner).getBytes());
            return true;
        }
    }

    public static interface Exchange {
        public boolean sendReply(OutputStream var1) throws IOException;

        public boolean processRequest(BufferedReader var1) throws IOException;
    }

    public static interface RequestMatcher {
        public boolean matches(String var1);
    }
}

