/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.MapsAdapterConfig;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Cmap;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.opennms.netmgt.config.map.adapter.ExcludeRange;
import org.opennms.netmgt.config.map.adapter.IncludeRange;
import org.opennms.netmgt.config.map.adapter.MapsAdapterConfiguration;
import org.opennms.netmgt.config.map.adapter.Package;
import org.opennms.netmgt.filter.FilterDaoFactory;

public abstract class MapsAdapterConfigManager
implements MapsAdapterConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private MapsAdapterConfiguration m_config;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<InetAddress>> m_pkgIpMap;
    private Map<String, List<String>> m_submapNameMapNameMap;
    private Map<String, Cmap> m_mapNameCmapMap;

    public MapsAdapterConfigManager(InputStream reader, String serverName, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = serverName;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    public MapsAdapterConfigManager() {
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadXML(InputStream reader) throws MarshalException, ValidationException, IOException {
        this.getWriteLock().lock();
        try {
            this.m_config = (MapsAdapterConfiguration)CastorUtils.unmarshal(MapsAdapterConfiguration.class, (InputStream)reader);
            this.createUrlIpMap();
            this.createPackageIpListMap();
            this.createSubMapMapMap();
            this.createmapNameCmapMap();
            this.verifyMapConsistency();
            this.verifyMapHasLoop();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private boolean hasCmaps() {
        return this.m_config.getCmaps() != null;
    }

    private void createmapNameCmapMap() {
        this.m_mapNameCmapMap = new HashMap<String, Cmap>();
        if (this.hasCmaps()) {
            for (Cmap cmap : this.m_config.getCmaps().getCmapCollection()) {
                this.m_mapNameCmapMap.put(cmap.getMapName(), cmap);
                LogUtils.debugf((Object)this, (String)"createmapNameCmapMap: Added map: %s", (Object[])new Object[]{cmap.getMapName()});
            }
        }
    }

    private void createSubMapMapMap() {
        this.m_submapNameMapNameMap = new HashMap<String, List<String>>();
        if (this.hasCmaps()) {
            for (Cmap cmap : this.m_config.getCmaps().getCmapCollection()) {
                for (Csubmap csubmap : cmap.getCsubmapCollection()) {
                    String subMapName = csubmap.getName();
                    List<String> containermaps = new ArrayList<String>();
                    if (this.m_submapNameMapNameMap.containsKey(subMapName)) {
                        containermaps = this.m_submapNameMapNameMap.get(subMapName);
                    }
                    containermaps.add(cmap.getMapName());
                    this.m_submapNameMapNameMap.put(subMapName, containermaps);
                    LogUtils.debugf((Object)this, (String)"createSubMapMapMap: added container map: %s to submap: %s", (Object[])new Object[]{cmap.getMapName(), subMapName});
                }
            }
        }
    }

    private void verifyMapConsistency() throws ValidationException {
        for (String mapName : this.m_submapNameMapNameMap.keySet()) {
            if (this.cmapExist(mapName)) continue;
            throw new ValidationException("Defined a submap without defining the map: mapName " + mapName);
        }
    }

    private void verifyMapHasLoop() throws ValidationException {
    }

    private boolean cmapExist(String mapName) {
        if (this.hasCmaps()) {
            for (Cmap cmap : this.m_config.getCmaps().getCmapCollection()) {
                if (!cmap.getMapName().equals(mapName)) continue;
                return true;
            }
        }
        return false;
    }

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.parse((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        this.getWriteLock().lock();
        try {
            this.m_pkgIpMap = new HashMap<Package, List<InetAddress>>();
            for (Package pkg : this.packages()) {
                try {
                    List<InetAddress> ipList = this.getIpList(pkg);
                    LogUtils.debugf((Object)this, (String)"createPackageIpMap: package %s: ipList size = %d", (Object[])new Object[]{pkg.getName(), ipList.size()});
                    if (ipList.size() <= 0) continue;
                    this.m_pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP List with filter \"%s\"", (Object[])new Object[]{pkg.getName(), pkg.getFilter().getContent()});
                }
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private List<InetAddress> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        String rules = filterRules.toString();
        LogUtils.debugf((Object)this, (String)"createPackageIpMap: package is %s. filter rules are %s", (Object[])new Object[]{pkg.getName(), rules});
        return FilterDaoFactory.getInstance().getActiveIPAddressList(rules);
    }

    private boolean interfaceInPackage(String iface, Package pkg) {
        boolean filterPassed = false;
        List<InetAddress> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(InetAddressUtils.addr((String)iface));
        }
        LogUtils.debugf((Object)this, (String)"interfaceInPackage: Interface %s passed filter for package %s?: %s", (Object[])new Object[]{iface, pkg.getName(), String.valueOf(filterPassed)});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecificCollection()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllPackageMatches(String ipaddr) {
        this.getReadLock().lock();
        try {
            ArrayList<String> matchingPkgs = new ArrayList<String>();
            for (Package pkg : this.packages()) {
                boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
                if (!inPkg) continue;
                matchingPkgs.add(pkg.getName());
            }
            ArrayList<String> arrayList = matchingPkgs;
            return arrayList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Package> packages() {
        this.getReadLock().lock();
        try {
            List list = this.getConfiguration().getPackageCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> includeURLs(Package pkg) {
        this.getReadLock().lock();
        try {
            List list = pkg.getIncludeUrlCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapsAdapterConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            MapsAdapterConfiguration mapsAdapterConfiguration = this.m_config;
            return mapsAdapterConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Cmap> getAllMaps() {
        this.getReadLock().lock();
        try {
            if (this.hasCmaps()) {
                List list = this.getConfiguration().getCmaps().getCmapCollection();
                return list;
            }
            List<Cmap> list = Collections.emptyList();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Celement> getElementByAddress(String ipaddr) {
        this.getReadLock().lock();
        try {
            HashMap<String, Celement> mapAndElements = new HashMap<String, Celement>();
            if (this.hasCmaps()) {
                List<String> pkgs = this.getAllPackageMatches(ipaddr);
                block3: for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                    Iterator cels = cmap.getCelementCollection().iterator();
                    boolean found = false;
                    while (cels.hasNext()) {
                        Celement celement = (Celement)cels.next();
                        Iterator<String> pkgname = pkgs.iterator();
                        while (pkgname.hasNext()) {
                            if (!pkgname.next().equals(celement.getPackage())) continue;
                            mapAndElements.put(cmap.getMapName(), celement);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        continue block3;
                    }
                }
            }
            HashMap<String, Celement> hashMap = mapAndElements;
            return hashMap;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Csubmap> getSubMaps(String mapName) {
        this.getReadLock().lock();
        try {
            if (this.hasCmaps()) {
                for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                    if (!cmap.getMapName().equals(mapName)) continue;
                    List list = cmap.getCsubmapCollection();
                    return list;
                }
            }
            List<Csubmap> list = Collections.emptyList();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMapElementDimension() {
        this.getReadLock().lock();
        try {
            int n = this.getConfiguration().getElementDimension();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Csubmap> getContainerMaps(String submapName) {
        this.getReadLock().lock();
        try {
            HashMap<String, Csubmap> cmaps = new HashMap<String, Csubmap>();
            if (this.m_submapNameMapNameMap.containsKey(submapName)) {
                block3: for (String mapName : this.m_submapNameMapNameMap.get(submapName)) {
                    Cmap cmap = this.m_mapNameCmapMap.get(mapName);
                    for (Csubmap csubmap : cmap.getCsubmapCollection()) {
                        if (!csubmap.getName().equals(submapName)) continue;
                        cmaps.put(mapName, csubmap);
                        continue block3;
                    }
                }
            }
            HashMap<String, Csubmap> hashMap = cmaps;
            return hashMap;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Csubmap>> getsubMaps() {
        this.getReadLock().lock();
        try {
            HashMap<String, List<Csubmap>> csubmaps = new HashMap<String, List<Csubmap>>();
            if (this.hasCmaps()) {
                for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                    if (cmap.getCsubmapCount() <= 0) continue;
                    csubmaps.put(cmap.getMapName(), cmap.getCsubmapCollection());
                }
            }
            HashMap<String, List<Csubmap>> hashMap = csubmaps;
            return hashMap;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Celement>> getCelements() {
        this.getReadLock().lock();
        try {
            HashMap<String, List<Celement>> celements = new HashMap<String, List<Celement>>();
            if (this.hasCmaps()) {
                for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                    if (cmap.getCelementCount() <= 0) continue;
                    celements.put(cmap.getMapName(), cmap.getCelementCollection());
                }
            }
            HashMap<String, List<Celement>> hashMap = celements;
            return hashMap;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }
}

