/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.MapsAdapterConfigManager;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;

public class MapsAdapterConfigFactory
extends MapsAdapterConfigManager {
    private static MapsAdapterConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public MapsAdapterConfigFactory(long currentVersion, InputStream reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
        LogUtils.debugf(MapsAdapterConfigFactory.class, (String)"init: config file path: %s", (Object[])new Object[]{cfgFile.getPath()});
        FileInputStream reader = new FileInputStream(cfgFile);
        MapsAdapterConfigFactory config = new MapsAdapterConfigFactory(cfgFile.lastModified(), reader, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
        ((InputStream)reader).close();
        MapsAdapterConfigFactory.setInstance(config);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        MapsAdapterConfigFactory.init();
        MapsAdapterConfigFactory.getInstance().update();
    }

    public static synchronized MapsAdapterConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    private static void setInstance(MapsAdapterConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            this.getWriteLock().lock();
            try {
                long timestamp = System.currentTimeMillis();
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
                LogUtils.debugf((Object)this, (String)"saveXml: saving config file at %d: %s", (Object[])new Object[]{timestamp, cfgFile.getPath()});
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
                fileWriter.write(xml);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
                LogUtils.debugf((Object)this, (String)"saveXml: finished saving config file: %s", (Object[])new Object[]{cfgFile.getPath()});
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException, MarshalException, ValidationException {
        this.getWriteLock().lock();
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
            if (cfgFile.lastModified() > this.m_currentVersion) {
                this.m_currentVersion = cfgFile.lastModified();
                LogUtils.debugf((Object)this, (String)"init: config file path: %s", (Object[])new Object[]{cfgFile.getPath()});
                this.reloadXML(new FileInputStream(cfgFile));
                LogUtils.debugf((Object)this, (String)"init: finished loading config file: %s", (Object[])new Object[]{cfgFile.getPath()});
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }
}

