/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.MapsAdapterConfig;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Cmap;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.opennms.netmgt.config.map.adapter.ExcludeRange;
import org.opennms.netmgt.config.map.adapter.IncludeRange;
import org.opennms.netmgt.config.map.adapter.MapsAdapterConfiguration;
import org.opennms.netmgt.config.map.adapter.Package;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapsAdapterConfigManager
implements MapsAdapterConfig {
    private MapsAdapterConfiguration m_config;
    private static boolean m_verifyServer;
    private static String m_localServer;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<String>> m_pkgIpMap;
    private Map<String, List<String>> m_submapNameMapNameMap;
    private Map<String, Cmap> m_mapNameCmapMap;

    public MapsAdapterConfigManager(InputStream reader, String serverName, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = serverName;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    public MapsAdapterConfigManager() {
    }

    protected synchronized void reloadXML(InputStream reader) throws MarshalException, ValidationException, IOException {
        this.m_config = (MapsAdapterConfiguration)CastorUtils.unmarshal(MapsAdapterConfiguration.class, (InputStream)reader);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.createSubMapMapMap();
        this.createmapNameCmapMap();
        this.verifyMapConsistency();
        this.verifyMapHasLoop();
    }

    private boolean hasCmaps() {
        return this.m_config.getCmaps() != null;
    }

    private void createmapNameCmapMap() {
        this.m_mapNameCmapMap = new HashMap<String, Cmap>();
        if (this.hasCmaps()) {
            Iterator ite = this.m_config.getCmaps().iterateCmap();
            while (ite.hasNext()) {
                Cmap cmap = (Cmap)ite.next();
                this.m_mapNameCmapMap.put(cmap.getMapName(), cmap);
                this.log().debug("createmapNameCmapMap: Added map: " + cmap.getMapName());
            }
        }
    }

    private void createSubMapMapMap() {
        this.m_submapNameMapNameMap = new HashMap<String, List<String>>();
        if (this.hasCmaps()) {
            Iterator ite = this.m_config.getCmaps().iterateCmap();
            while (ite.hasNext()) {
                Cmap cmap = (Cmap)ite.next();
                Iterator sub_ite = cmap.iterateCsubmap();
                while (sub_ite.hasNext()) {
                    Csubmap csubmap = (Csubmap)sub_ite.next();
                    String subMapName = csubmap.getName();
                    List<String> containermaps = new ArrayList<String>();
                    if (this.m_submapNameMapNameMap.containsKey(subMapName)) {
                        containermaps = this.m_submapNameMapNameMap.get(subMapName);
                    }
                    containermaps.add(cmap.getMapName());
                    this.m_submapNameMapNameMap.put(subMapName, containermaps);
                    this.log().debug("createSubMapMapMap: added container map: " + cmap.getMapName() + " to submap: " + subMapName);
                }
            }
        }
    }

    private void verifyMapConsistency() throws ValidationException {
        for (String mapName : this.m_submapNameMapNameMap.keySet()) {
            if (this.cmapExist(mapName)) continue;
            throw new ValidationException("Defined a submap without defining the map: mapName " + mapName);
        }
    }

    private void verifyMapHasLoop() throws ValidationException {
    }

    private boolean cmapExist(String mapName) {
        if (this.hasCmaps()) {
            Iterator ite = this.m_config.getCmaps().iterateCmap();
            while (ite.hasNext()) {
                if (!((Cmap)ite.next()).getMapName().equals(mapName)) continue;
                return true;
            }
        }
        return false;
    }

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.parse((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    private synchronized void createPackageIpListMap() {
        this.m_pkgIpMap = new HashMap<Package, List<String>>();
        for (Package pkg : this.packages()) {
            try {
                List<String> ipList = this.getIpList(pkg);
                this.log().debug("createPackageIpMap: package " + pkg.getName() + ": ipList size =  " + ipList.size());
                if (ipList.size() <= 0) continue;
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                this.log().error("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List: " + t, t);
            }
        }
    }

    private List<String> getIpList(Package pkg) {
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        this.log().debug("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString());
        List ipList = FilterDaoFactory.getInstance().getIPList(filterRules.toString());
        return ipList;
    }

    private synchronized boolean interfaceInPackage(String iface, Package pkg) {
        ThreadCategory log = this.log();
        boolean filterPassed = false;
        List<String> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed);
        }
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_include = true;
            break;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (String spec : pkg.getSpecificCollection()) {
            byte[] speca = InetAddressUtils.toIpAddrBytes((String)spec);
            if (new ByteArrayComparator().compare(speca, addr) != 0) continue;
            has_specific = true;
            break;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        for (ExcludeRange rng : pkg.getExcludeRangeCollection()) {
            if (!InetAddressUtils.isInetAddressInRange((String)iface, (String)rng.getBegin(), (String)rng.getEnd())) continue;
            has_range_exclude = true;
            break;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    public synchronized List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        for (Package pkg : this.packages()) {
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            matchingPkgs.add(pkg.getName());
        }
        return matchingPkgs;
    }

    public Iterable<Package> packages() {
        return this.getConfiguration().getPackageCollection();
    }

    public Iterable<String> includeURLs(Package pkg) {
        return pkg.getIncludeUrlCollection();
    }

    public synchronized MapsAdapterConfiguration getConfiguration() {
        return this.m_config;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public List<Cmap> getAllMaps() {
        if (this.hasCmaps()) {
            return this.getConfiguration().getCmaps().getCmapCollection();
        }
        return new ArrayList<Cmap>();
    }

    @Override
    public Map<String, Celement> getElementByAddress(String ipaddr) {
        HashMap<String, Celement> mapAndElements = new HashMap<String, Celement>();
        if (this.hasCmaps()) {
            List<String> pkgs = this.getAllPackageMatches(ipaddr);
            block0: for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                Iterator cels = cmap.getCelementCollection().iterator();
                boolean found = false;
                while (cels.hasNext()) {
                    Celement celement = (Celement)cels.next();
                    Iterator<String> pkgname = pkgs.iterator();
                    while (pkgname.hasNext()) {
                        if (!pkgname.next().equals(celement.getPackage())) continue;
                        mapAndElements.put(cmap.getMapName(), celement);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block0;
                }
            }
        }
        return mapAndElements;
    }

    @Override
    public List<Csubmap> getSubMaps(String mapName) {
        if (this.hasCmaps()) {
            for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                if (!cmap.getMapName().equals(mapName)) continue;
                return cmap.getCsubmapCollection();
            }
        }
        return new ArrayList<Csubmap>();
    }

    @Override
    public int getMapElementDimension() {
        return this.getConfiguration().getElementDimension();
    }

    @Override
    public Map<String, Csubmap> getContainerMaps(String submapName) {
        HashMap<String, Csubmap> cmaps = new HashMap<String, Csubmap>();
        if (this.m_submapNameMapNameMap.containsKey(submapName)) {
            block0: for (String mapName : this.m_submapNameMapNameMap.get(submapName)) {
                Cmap cmap = this.m_mapNameCmapMap.get(mapName);
                Iterator sub_ite = cmap.iterateCsubmap();
                while (sub_ite.hasNext()) {
                    Csubmap csubmap = (Csubmap)sub_ite.next();
                    if (!csubmap.getName().equals(submapName)) continue;
                    cmaps.put(mapName, csubmap);
                    continue block0;
                }
            }
        }
        return cmaps;
    }

    @Override
    public Map<String, List<Csubmap>> getsubMaps() {
        HashMap<String, List<Csubmap>> csubmaps = new HashMap<String, List<Csubmap>>();
        if (this.hasCmaps()) {
            for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                if (cmap.getCsubmapCount() <= 0) continue;
                csubmaps.put(cmap.getMapName(), cmap.getCsubmapCollection());
            }
        }
        return csubmaps;
    }

    @Override
    public Map<String, List<Celement>> getCelements() {
        HashMap<String, List<Celement>> celements = new HashMap<String, List<Celement>>();
        if (this.hasCmaps()) {
            for (Cmap cmap : this.getConfiguration().getCmaps().getCmapCollection()) {
                if (cmap.getCelementCount() <= 0) continue;
                celements.put(cmap.getMapName(), cmap.getCelementCollection());
            }
        }
        return celements;
    }

    @Override
    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }
}

