/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.MapsAdapterConfigManager;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;

public class MapsAdapterConfigFactory
extends MapsAdapterConfigManager {
    private static MapsAdapterConfigFactory m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    public MapsAdapterConfigFactory(long currentVersion, InputStream reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
        MapsAdapterConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
        FileInputStream reader = new FileInputStream(cfgFile);
        MapsAdapterConfigFactory config = new MapsAdapterConfigFactory(cfgFile.lastModified(), reader, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
        ((InputStream)reader).close();
        MapsAdapterConfigFactory.setInstance(config);
    }

    private static ThreadCategory logStatic() {
        return ThreadCategory.getInstance(MapsAdapterConfigFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        MapsAdapterConfigFactory.init();
        MapsAdapterConfigFactory.getInstance().update();
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
            MapsAdapterConfigFactory.logStatic().debug("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            MapsAdapterConfigFactory.logStatic().debug("saveXml: finished saving config file: " + cfgFile.getPath());
        }
    }

    public static synchronized MapsAdapterConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    private static void setInstance(MapsAdapterConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAPS_ADAPTER_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            MapsAdapterConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
            this.reloadXML(new FileInputStream(cfgFile));
            MapsAdapterConfigFactory.logStatic().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }
}

