/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.MapsAdapterConfig;
import org.opennms.netmgt.config.map.adapter.Celement;
import org.opennms.netmgt.config.map.adapter.Cmap;
import org.opennms.netmgt.config.map.adapter.Csubmap;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class MapProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private Object m_lock = new Object();
    private NodeDao m_onmsNodeDao;
    private OnmsMapDao m_onmsMapDao;
    private OnmsMapElementDao m_onmsMapElementDao;
    private EventForwarder m_eventForwarder;
    private MapsAdapterConfig m_mapsAdapterConfig;
    private TransactionTemplate m_template;
    private int m_nodeId;
    private static final String MESSAGE_PREFIX = "Dynamic Map provisioning failed: ";
    private static final String ADAPTER_NAME = "MAP Provisioning Adapter";
    private static volatile ConcurrentMap<Integer, List<OnmsMapElement>> m_onmsNodeMapElementListMap;
    private static volatile ConcurrentMap<String, Integer> m_mapNameMapSizeListMap;
    private List<OnmsMapElement> m_onmsNodeMapElementToDelete;

    public OnmsMapDao getOnmsMapDao() {
        return this.m_onmsMapDao;
    }

    public void setOnmsMapDao(OnmsMapDao onmsMapDao) {
        this.m_onmsMapDao = onmsMapDao;
    }

    public OnmsMapElementDao getOnmsMapElementDao() {
        return this.m_onmsMapElementDao;
    }

    public void setOnmsMapElementDao(OnmsMapElementDao onmsMapElementDao) {
        this.m_onmsMapElementDao = onmsMapElementDao;
    }

    public MapsAdapterConfig getMapsAdapterConfig() {
        return this.m_mapsAdapterConfig;
    }

    public void setMapsAdapterConfig(MapsAdapterConfig mapsAdapterConfig) {
        this.m_mapsAdapterConfig = mapsAdapterConfig;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public NodeDao getOnmsNodeDao() {
        return this.m_onmsNodeDao;
    }

    public void setOnmsNodeDao(NodeDao onmsNodeDao) {
        this.m_onmsNodeDao = onmsNodeDao;
    }

    public TransactionTemplate getTemplate() {
        return this.m_template;
    }

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    private static Category log() {
        return ThreadCategory.getInstance(MapProvisioningAdapter.class);
    }

    public String getName() {
        return ADAPTER_NAME;
    }

    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingOperationForNode(SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        MapProvisioningAdapter.log().info((Object)"processPendingOperationsForNode: acquiring lock...");
        Object object = this.m_lock;
        synchronized (object) {
            MapProvisioningAdapter.log().debug((Object)("processPendingOperationForNode: processing operation: " + op.getType().name() + " for node with Id: #" + op.getNodeId()));
            this.m_mapsAdapterConfig.rebuildPackageIpListMap();
            if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD) {
                m_onmsNodeMapElementListMap.put(op.getNodeId(), new ArrayList());
                this.doAddOrUpdate(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
                this.doAddOrUpdate(op.getNodeId());
            } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE) {
                this.doDelete(op.getNodeId());
            }
        }
        MapProvisioningAdapter.log().info((Object)"processPendingOperationsForNode: lock released.");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_onmsNodeDao, (String)"Map Provisioning Adapter requires nodeDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapDao, (String)"Map Provisioning Adapter requires OnmsMapDao property to be set.");
        Assert.notNull((Object)this.m_onmsMapElementDao, (String)"Map Provisioning Adapter requires OnmsMapElementDao property to be set.");
        Assert.notNull((Object)this.m_mapsAdapterConfig, (String)"Map Provisioning Adapter requires MapasAdapterConfig property to be set.");
        Assert.notNull((Object)this.m_eventForwarder, (String)"Map Provisioning Adapter requires EventForwarder property to be set.");
    }

    public void init() throws ProvisioningAdapterException {
        MapSyncExecutor e = new MapSyncExecutor();
        new Thread(e).start();
    }

    private void syncMaps() throws ProvisioningAdapterException {
        try {
            this.m_template.execute(new TransactionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus arg0) {
                    MapProvisioningAdapter.log().info((Object)"syncMaps: acquiring lock...");
                    Object object = MapProvisioningAdapter.this.m_lock;
                    synchronized (object) {
                        MapProvisioningAdapter.log().debug((Object)"syncMaps: lock aqcuired.  syncing maps...");
                        List<Cmap> cmaps = MapProvisioningAdapter.this.m_mapsAdapterConfig.getAllMaps();
                        m_mapNameMapSizeListMap = new ConcurrentHashMap(cmaps.size());
                        List nodes = MapProvisioningAdapter.this.m_onmsNodeDao.findAllProvisionedNodes();
                        m_onmsNodeMapElementListMap = new ConcurrentHashMap(nodes.size());
                        Date now = new Date();
                        MapProvisioningAdapter.log().debug((Object)"syncMaps: sync automated maps in database with configuration");
                        for (OnmsMap onmsMap : MapProvisioningAdapter.this.m_onmsMapDao.findAutoMaps()) {
                            MapProvisioningAdapter.log().debug((Object)("syncMaps: deleting old automated map: " + onmsMap.getName()));
                            MapProvisioningAdapter.this.m_onmsMapDao.delete((Object)onmsMap);
                            MapProvisioningAdapter.this.m_onmsMapDao.flush();
                        }
                        for (Cmap cmap : cmaps) {
                            OnmsMap onmsMap = MapProvisioningAdapter.this.getSuitableMap(cmap.getMapName());
                            MapProvisioningAdapter.log().debug((Object)("syncMaps: adding new automated map: " + onmsMap.getName()));
                            onmsMap.setOwner(cmap.getMapOwner());
                            onmsMap.setUserLastModifies(cmap.getMapOwner());
                            onmsMap.setMapGroup(cmap.getMapGroup());
                            onmsMap.setAccessMode(cmap.getMapAccess());
                            onmsMap.setBackground(cmap.getMapBG());
                            onmsMap.setHeight(cmap.getMapHeight());
                            onmsMap.setWidth(cmap.getMapWidth());
                            onmsMap.setLastModifiedTime(now);
                            MapProvisioningAdapter.this.m_onmsMapDao.saveOrUpdate((Object)onmsMap);
                            m_mapNameMapSizeListMap.put(cmap.getMapName(), 0);
                        }
                        MapProvisioningAdapter.this.m_onmsMapDao.flush();
                        MapProvisioningAdapter.this.m_onmsMapDao.clear();
                        for (OnmsNode node : nodes) {
                            MapProvisioningAdapter.log().debug((Object)("syncMaps: try to add to automated maps node element: '" + node.getLabel() + "'"));
                            m_onmsNodeMapElementListMap.put(node.getId(), new ArrayList());
                            MapProvisioningAdapter.this.doAddOrUpdate(node.getId());
                        }
                        Map<String, List<Csubmap>> mapnameSubmapMap = MapProvisioningAdapter.this.m_mapsAdapterConfig.getsubMaps();
                        for (String mapName : mapnameSubmapMap.keySet()) {
                            MapProvisioningAdapter.log().debug((Object)("syncMaps: adding automated submap: " + mapName));
                            OnmsMap onmsMap = MapProvisioningAdapter.this.getSuitableMap(mapName);
                            for (Csubmap csubmap : mapnameSubmapMap.get(mapName)) {
                                OnmsMap onmsSubMap = MapProvisioningAdapter.this.getSuitableMap(csubmap.getName());
                                if (onmsSubMap.isNew()) {
                                    MapProvisioningAdapter.log().error((Object)("syncMap: add SubMaps: the submap does not exist: " + csubmap.getName()));
                                    continue;
                                }
                                if (onmsSubMap.getMapElements().size() <= 0 && !csubmap.getAddwithoutelements()) continue;
                                MapProvisioningAdapter.this.addSubMap(onmsMap, csubmap, onmsSubMap);
                                onmsMap.setLastModifiedTime(new Date());
                                MapProvisioningAdapter.this.m_onmsMapDao.update((Object)onmsMap);
                                MapProvisioningAdapter.this.m_onmsMapDao.flush();
                            }
                            MapProvisioningAdapter.this.m_onmsMapDao.clear();
                        }
                        MapProvisioningAdapter.log().debug((Object)"syncMaps: maps synchronized.  releasing lock...");
                    }
                    MapProvisioningAdapter.log().info((Object)"syncMaps: lock released.");
                    return null;
                }
            });
        }
        catch (Exception e) {
            MapProvisioningAdapter.log().error((Object)("syncMaps: Caught exception synchronizing maps: " + e), (Throwable)e);
            throw new ProvisioningAdapterException("syncMaps exception", (Throwable)e);
        }
    }

    private void addSubMap(OnmsMap onmsMap, Csubmap csubmap, OnmsMap onmsSubMap) {
        MapProvisioningAdapter.log().debug((Object)("addSubMap: adding automated submap: " + onmsSubMap.getName() + " to map: " + onmsMap.getName()));
        OnmsMapElement mapElement = null;
        if (!onmsMap.getMapElements().isEmpty()) {
            MapProvisioningAdapter.log().debug((Object)("addSubMap: looping on elements of not empty map: " + onmsMap.getName()));
            for (OnmsMapElement elem : onmsMap.getMapElements()) {
                MapProvisioningAdapter.log().debug((Object)("addSubMap: checking element with id: " + elem.getElementId() + " and type" + elem.getType()));
                if (!elem.getType().equals("M") || elem.getElementId() != onmsSubMap.getId()) continue;
                MapProvisioningAdapter.log().debug((Object)"addSubMap: still exists in map updating");
                mapElement = elem;
                mapElement.setLabel(csubmap.getLabel());
                mapElement.setIconName(csubmap.getIcon());
                mapElement.setX(csubmap.getX());
                mapElement.setY(csubmap.getY());
                break;
            }
        }
        if (mapElement == null) {
            mapElement = new OnmsMapElement(onmsMap, onmsSubMap.getId(), "M", csubmap.getLabel(), csubmap.getIcon(), csubmap.getX(), csubmap.getY());
            this.m_onmsMapElementDao.saveOrUpdate((Object)mapElement);
        } else {
            this.m_onmsMapElementDao.update(mapElement);
        }
        MapProvisioningAdapter.log().debug((Object)("added map element with id: " + mapElement.getId()));
        MapProvisioningAdapter.log().debug((Object)("               with label: " + mapElement.getLabel()));
        MapProvisioningAdapter.log().debug((Object)("                with icon: " + mapElement.getIconName()));
        MapProvisioningAdapter.log().debug((Object)("                   with X: " + mapElement.getX()));
        MapProvisioningAdapter.log().debug((Object)("                   with Y: " + mapElement.getY()));
        this.m_onmsMapElementDao.flush();
        this.m_onmsMapElementDao.clear();
    }

    private void doDelete(Integer nodeid) {
        this.m_nodeId = nodeid;
        MapProvisioningAdapter.log().debug((Object)("doDelete: deleting mapElements from the automated maps for the node with nodeid:" + this.m_nodeId));
        try {
            this.m_template.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus arg0) {
                    try {
                        for (OnmsMapElement elem : (List)m_onmsNodeMapElementListMap.remove(MapProvisioningAdapter.this.m_nodeId)) {
                            MapProvisioningAdapter.log().debug((Object)("doDelete: deleting element with label: '" + elem.getLabel() + "' from automated map: '" + elem.getMap().getName() + "'"));
                            Integer mapId = elem.getMap().getId();
                            MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)elem);
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            OnmsMap onmsMap = MapProvisioningAdapter.this.m_onmsMapDao.findMapById(mapId.intValue());
                            onmsMap.setLastModifiedTime(new Date());
                            MapProvisioningAdapter.this.m_onmsMapDao.update((Object)onmsMap);
                            MapProvisioningAdapter.this.m_onmsMapDao.flush();
                            if (onmsMap.getMapElements().size() != 0) continue;
                            MapProvisioningAdapter.this.removeEmptySubmap(onmsMap);
                        }
                        MapProvisioningAdapter.this.m_onmsMapDao.clear();
                        MapProvisioningAdapter.this.m_onmsMapElementDao.clear();
                    }
                    catch (Exception e) {
                        MapProvisioningAdapter.log().error((Object)e.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.sendAndThrow(this.m_nodeId, e);
        }
    }

    protected void removeEmptySubmap(OnmsMap submap) {
        MapProvisioningAdapter.log().debug((Object)("removeEmptySubmap: verify delete map element which correspond to empty submap: " + submap.getName()));
        Map<String, List<Csubmap>> submaps = this.m_mapsAdapterConfig.getsubMaps();
        for (String mapName : submaps.keySet()) {
            for (Csubmap csubmap : submaps.get(mapName)) {
                if (!csubmap.getName().equals(submap.getName()) || csubmap.getAddwithoutelements()) continue;
                MapProvisioningAdapter.log().debug((Object)("removeEmptySubmap: delete from container map: '" + mapName + "' empty submap '" + submap.getName()));
                OnmsMap onmsMap = this.getSuitableMap(mapName);
                Integer mapid = onmsMap.getId();
                OnmsMapElement mapElement = this.m_onmsMapElementDao.findMapElement(submap.getId(), "M", onmsMap);
                if (mapElement == null) continue;
                this.m_onmsMapElementDao.delete((Object)mapElement);
                this.m_onmsMapElementDao.flush();
                onmsMap = this.m_onmsMapDao.findMapById(mapid.intValue());
                onmsMap.setLastModifiedTime(new Date());
                this.m_onmsMapDao.update((Object)onmsMap);
                this.m_onmsMapDao.flush();
            }
        }
    }

    private void doAddOrUpdate(Integer nodeid) throws ProvisioningAdapterException {
        this.m_nodeId = nodeid;
        try {
            this.m_template.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus arg0) {
                    try {
                        MapProvisioningAdapter.this.addOrUpdate();
                    }
                    catch (Exception e) {
                        MapProvisioningAdapter.log().error((Object)e.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.sendAndThrow(this.m_nodeId, e);
        }
    }

    private void addOrUpdate() throws Exception {
        MapProvisioningAdapter.log().debug((Object)("addOrUpdate: adding or updating the automated maps for the node with nodeid:" + this.m_nodeId));
        OnmsNode node = (OnmsNode)this.m_onmsNodeDao.get((Serializable)Integer.valueOf(this.m_nodeId));
        if (node == null) {
            throw new Exception("Error Adding element. Node does not exist: nodeid: " + this.m_nodeId);
        }
        this.m_onmsNodeMapElementToDelete = (List)m_onmsNodeMapElementListMap.get(this.m_nodeId);
        MapProvisioningAdapter.log().debug((Object)("addOrUpdate: found #" + this.m_onmsNodeMapElementToDelete.size() + " mapElements in automated maps for the nodeid: " + this.m_nodeId));
        ArrayList<OnmsMapElement> elems = new ArrayList<OnmsMapElement>();
        m_onmsNodeMapElementListMap.replace(this.m_nodeId, elems);
        Map<String, Celement> celements = this.m_mapsAdapterConfig.getElementByAddress(this.getSuitableIp(node));
        if (celements.isEmpty()) {
            MapProvisioningAdapter.log().info((Object)("addOrUpdate: Element is not managed in the adapter configuration file: no package match nodeid: " + this.m_nodeId));
        } else {
            MapProvisioningAdapter.log().debug((Object)("addOrUpdate: found #" + celements.size() + " container automated maps for the nodeid: " + this.m_nodeId));
            for (String mapName : celements.keySet()) {
                OnmsMapElement mapElement;
                MapProvisioningAdapter.log().debug((Object)("addOrUpdate: found mapName: " + mapName + " container automated map for the nodeid: " + this.m_nodeId));
                Celement celement = celements.get(mapName);
                OnmsMap onmsMap = this.getSuitableMap(mapName);
                if (onmsMap.isNew()) {
                    throw new Exception("Error adding element. Automated map does not exist in database: " + mapName);
                }
                MapProvisioningAdapter.log().debug((Object)("addOrUpdate: container automated map: " + mapName + " has mapId: " + onmsMap.getId()));
                if (onmsMap.getMapElements().size() == 0) {
                    MapProvisioningAdapter.log().debug((Object)("addOrUpdate: automated map: " + mapName + " has no elements"));
                    this.addAsSubMap(mapName);
                }
                if ((mapElement = this.m_onmsMapElementDao.findMapElement(this.m_nodeId, "N", onmsMap)) == null) {
                    int elementsize = (Integer)m_mapNameMapSizeListMap.get(mapName);
                    MapProvisioningAdapter.log().debug((Object)("addOrUpdate: mapElement is new: found last mapElement at position #" + elementsize + " on map: " + mapName));
                    XY xy = this.getXY(onmsMap, elementsize);
                    mapElement = new OnmsMapElement(onmsMap, this.m_nodeId, "N", node.getLabel(), celement.getIcon(), xy.getX(), xy.getY());
                    m_mapNameMapSizeListMap.replace(mapName, ++elementsize);
                    MapProvisioningAdapter.log().debug((Object)("doAddOrUpdate: adding node: " + node.getLabel() + " to map: " + mapName));
                } else {
                    mapElement.setIconName(celement.getIcon());
                    mapElement.setLabel(node.getLabel());
                    MapProvisioningAdapter.log().debug((Object)("doAddOrUpdate: updating node: " + node.getLabel() + " to map: " + mapName));
                    ArrayList<OnmsMapElement> tempElems = new ArrayList<OnmsMapElement>();
                    for (OnmsMapElement oldElem : this.m_onmsNodeMapElementToDelete) {
                        MapProvisioningAdapter.log().debug((Object)("doAddOrUpdate: removing the old mapElement from the deleting list parsing element with mapId: " + oldElem.getMap().getId()));
                        if (oldElem.getMap().getId() == onmsMap.getId()) continue;
                        tempElems.add(oldElem);
                        MapProvisioningAdapter.log().debug((Object)"doAddOrUpdate: leaving the old mapElement in deleting list: ");
                    }
                    this.m_onmsNodeMapElementToDelete = tempElems;
                }
                this.m_onmsMapElementDao.saveOrUpdate((Object)mapElement);
                this.m_onmsMapElementDao.flush();
                onmsMap.setLastModifiedTime(new Date());
                this.m_onmsMapDao.update((Object)onmsMap);
                this.m_onmsMapDao.flush();
                elems.add(mapElement);
            }
            this.m_onmsMapElementDao.clear();
            this.m_onmsMapDao.clear();
            m_onmsNodeMapElementListMap.replace(this.m_nodeId, elems);
        }
        MapProvisioningAdapter.log().debug((Object)("doAddOrUpdate: deleting moved element from automated maps: size #" + this.m_onmsNodeMapElementToDelete.size()));
        try {
            this.m_template.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus arg0) {
                    try {
                        for (OnmsMapElement elem : MapProvisioningAdapter.this.m_onmsNodeMapElementToDelete) {
                            MapProvisioningAdapter.log().debug((Object)("doAddOrUpdate: deleting element with label: '" + elem.getLabel() + "' from automated map: '" + elem.getMap().getName() + "'"));
                            Integer mapId = elem.getMap().getId();
                            MapProvisioningAdapter.this.m_onmsMapElementDao.delete((Object)elem);
                            MapProvisioningAdapter.this.m_onmsMapElementDao.flush();
                            OnmsMap onmsMap = MapProvisioningAdapter.this.m_onmsMapDao.findMapById(mapId.intValue());
                            onmsMap.setLastModifiedTime(new Date());
                            MapProvisioningAdapter.this.m_onmsMapDao.update((Object)onmsMap);
                            MapProvisioningAdapter.this.m_onmsMapDao.flush();
                            if (onmsMap.getMapElements().size() != 0) continue;
                            MapProvisioningAdapter.this.removeEmptySubmap(onmsMap);
                        }
                        MapProvisioningAdapter.this.m_onmsMapElementDao.clear();
                        MapProvisioningAdapter.this.m_onmsMapDao.clear();
                    }
                    catch (Exception e) {
                        MapProvisioningAdapter.log().error((Object)e.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.sendAndThrow(this.m_nodeId, e);
        }
        this.m_onmsNodeMapElementToDelete = null;
    }

    private void addAsSubMap(String submapName) {
        Map<String, Csubmap> csubmaps = this.m_mapsAdapterConfig.getContainerMaps(submapName);
        for (String mapName : csubmaps.keySet()) {
            OnmsMap onmsMap = this.getSuitableMap(mapName);
            Csubmap csubmap = csubmaps.get(mapName);
            OnmsMap onmsSubMap = this.getSuitableMap(csubmap.getName());
            if (onmsSubMap.isNew()) {
                MapProvisioningAdapter.log().error((Object)("add SubMaps: the submap doen not exists: " + csubmap.getName()));
                continue;
            }
            if (csubmap.getAddwithoutelements()) continue;
            this.addSubMap(onmsMap, csubmap, onmsSubMap);
            onmsMap.setLastModifiedTime(new Date());
            this.m_onmsMapDao.update((Object)onmsMap);
            this.m_onmsMapDao.flush();
        }
        this.m_onmsMapDao.clear();
    }

    private void sendAndThrow(int nodeId, Exception e) {
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed", nodeId).addParam("reason", MESSAGE_PREFIX + e.getLocalizedMessage()).getEvent();
        this.m_eventForwarder.sendNow(event);
        MapProvisioningAdapter.log().error((Object)e);
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, (Throwable)e);
    }

    private EventBuilder buildEvent(String uei, int nodeId) {
        EventBuilder builder = new EventBuilder(uei, "Provisioner", new Date());
        builder.setNodeid(nodeId);
        return builder;
    }

    private String getSuitableIp(OnmsNode node) {
        Set ipInterfaces;
        Iterator i$;
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null && (i$ = (ipInterfaces = node.getIpInterfaces()).iterator()).hasNext()) {
            OnmsIpInterface onmsIpInterface = (OnmsIpInterface)i$.next();
            return onmsIpInterface.getIpAddress();
        }
        return primaryInterface.getIpAddress();
    }

    private OnmsMap getSuitableMap(String mapName) {
        OnmsMap onmsMap = null;
        Collection maps = this.m_onmsMapDao.findMapsByNameAndType(mapName, "A");
        if (maps.size() > 0) {
            onmsMap = (OnmsMap)maps.iterator().next();
            onmsMap.setNew(false);
            MapProvisioningAdapter.log().debug((Object)("getSuitableMap: found map with mapid #" + onmsMap.getMapId() + " for map name:" + mapName));
        } else {
            MapProvisioningAdapter.log().debug((Object)("getSuitableMap: no map found for name:" + mapName + ". Creating a new map."));
            onmsMap = new OnmsMap();
            onmsMap.setName(mapName);
            onmsMap.setType("A");
        }
        return onmsMap;
    }

    private XY getXY(OnmsMap map, int mapElementSize) {
        int deltaX = this.m_mapsAdapterConfig.getMapElementDimension();
        int deltaY = deltaX / 2;
        int maxNumberofelementsonX = map.getWidth() / (2 * deltaX);
        MapProvisioningAdapter.log().debug((Object)("getXY: max number of elements on a row: " + maxNumberofelementsonX));
        int numberofexistingelement = mapElementSize;
        MapProvisioningAdapter.log().debug((Object)("getXY: number of existing elements on map: " + mapElementSize));
        int positiononX = 1;
        int positiononY = 1;
        boolean addoffset = true;
        while (maxNumberofelementsonX <= numberofexistingelement) {
            MapProvisioningAdapter.log().debug((Object)("getXY: entering the loop: element found on the row: " + (numberofexistingelement -= maxNumberofelementsonX)));
            ++positiononY;
            maxNumberofelementsonX = addoffset ? --maxNumberofelementsonX : ++maxNumberofelementsonX;
            addoffset = !addoffset;
        }
        positiononX += numberofexistingelement;
        XY xy = new XY();
        if (addoffset) {
            xy.setX(2 * deltaX * positiononX - deltaX);
        } else {
            xy.setX(2 * deltaX * positiononX);
        }
        xy.setY(deltaY * positiononY);
        return xy;
    }

    class MapSyncExecutor
    implements Runnable {
        MapSyncExecutor() {
        }

        public void run() {
            MapProvisioningAdapter.this.syncMaps();
        }
    }

    private class XY {
        int x;
        int y;

        protected XY() {
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

