/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class SimplerProvisioningAdapterTest
implements InitializingBean {
    public static String NAME = "MyProvisioningAdapter";
    CountDownLatch addLatch = new CountDownLatch(1);
    CountDownLatch deleteLatch = new CountDownLatch(1);
    CountDownLatch updateLatch = new CountDownLatch(1);
    CountDownLatch configChangeLatch = new CountDownLatch(1);
    @Autowired
    private TransactionTemplate m_txTemplate;
    private MyProvisioningAdapter m_adapter;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_adapter = new MyProvisioningAdapter();
        this.m_adapter.init();
    }

    @Test
    public void dwoGetName() {
        Assert.assertEquals((Object)NAME, (Object)this.m_adapter.getName());
    }

    @Test
    public void dwoAddNodeCallsDoAddNode() throws InterruptedException {
        this.m_adapter.addNode(1);
        Assert.assertTrue((boolean)this.addLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void dwoDeleteNodeCallsDoDeleteNode() throws InterruptedException {
        this.m_adapter.deleteNode(1);
        Assert.assertTrue((boolean)this.deleteLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void dwoUpdateNodeCallsDoUpdateNode() throws InterruptedException {
        this.m_adapter.updateNode(1);
        Assert.assertTrue((boolean)this.updateLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void dwoNotifyConfigChangeCallsDoNotifyConfigChange() throws InterruptedException {
        this.m_adapter.nodeConfigChanged(1);
        Assert.assertTrue((boolean)this.configChangeLatch.await(2L, TimeUnit.SECONDS));
    }

    class MyProvisioningAdapter
    extends SimplerQueuedProvisioningAdapter {
        public MyProvisioningAdapter() {
            super(NAME);
            this.setTemplate(SimplerProvisioningAdapterTest.this.m_txTemplate);
        }

        public void doAddNode(int nodeid) {
            SimplerProvisioningAdapterTest.this.addLatch.countDown();
        }

        public void doDeleteNode(int nodeid) {
            SimplerProvisioningAdapterTest.this.deleteLatch.countDown();
        }

        public void doNotifyConfigChange(int nodeid) {
            SimplerProvisioningAdapterTest.this.configChangeLatch.countDown();
        }

        public void doUpdateNode(int nodeid) {
            SimplerProvisioningAdapterTest.this.updateLatch.countDown();
        }
    }
}

