/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.provision.adapters.link.EndPointImpl;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.DefaultEndPointConfigurationDao;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/snmpConfigFactoryContext.xml"})
public class LinkMonitoringSnmpTest {
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private static final String AIR_PAIR_R3_SYS_OID = ".1.3.6.1.4.1.7262.1";
    private static final String AIR_PAIR_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    private static final String AIR_PAIR_R3_DUPLEX_MISMATCH = ".1.3.6.1.4.1.7262.1.19.2.3.0";
    private static final String AIR_PAIR_R4_SYS_OID = ".1.3.6.1.4.1.7262.1";
    private static final String AIR_PAIR_R4_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    private static final String HORIZON_COMPACT_SYS_OID = ".1.3.6.1.4.1.7262.2.2";
    private static final String HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.2.8.4.4.1.0";
    private static final String HORIZON_COMPACT_ETHERNET_LINK_DOWN = ".1.3.6.1.4.1.7262.2.2.8.3.1.9.0";
    private static final String HORIZON_DUO_SYS_OID = ".1.3.6.1.4.1.7262.2.3";
    private static final String HORIZON_DUO_SYSTEM_CAPACITY = ".1.3.6.1.4.1.7262.2.3.1.1.5.0";
    private static final String HORIZON_DUO_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.3.7.4.1.1.1.2.1";
    private DefaultEndPointConfigurationDao m_configDao;

    private EndPointImpl getEndPoint(String sysOid, String address) throws UnknownHostException {
        EndPointImpl endPoint = new EndPointImpl(InetAddressUtils.getLocalHostAddress(), this.getAgentConfig(address));
        endPoint.setSysOid(sysOid);
        return endPoint;
    }

    private SnmpAgentConfig getAgentConfig(String address) {
        return this.m_snmpPeerFactory.getAgentConfig(InetAddressUtils.addr((String)address));
    }

    @Before
    public void setUp() throws InterruptedException, UnknownHostException {
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
        DefaultEndPointConfigurationDao dao = new DefaultEndPointConfigurationDao();
        dao.setConfigResource((Resource)new ClassPathResource("/testDWO-configuration.xml"));
        dao.afterPropertiesSet();
        this.m_configDao = dao;
    }

    @Test
    @JUnitSnmpAgent(host="192.168.255.10", resource="classpath:/airPairR3_walk.properties")
    public void dwoTestEndPointImplGetOid() throws UnknownHostException {
        EndPointImpl endPoint = this.getEndPoint(null, "192.168.255.10");
        SnmpValue snmpVal = endPoint.get(".1.3.6.1.4.1.7262.1.19.3.1.0");
        Assert.assertNotNull((Object)snmpVal);
        Assert.assertEquals((Object)"1", (Object)snmpVal.toString());
    }

    @Test
    @JUnitSnmpAgent(host="192.168.255.10", resource="classpath:/airPairR3_walk.properties")
    public void dwoTestLinkMonitorAirPairR3() throws UnknownHostException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.10"), (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.4.1.7262.1.19.3.1.0"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.10"), (SnmpObjId)SnmpObjId.get((String)AIR_PAIR_R3_DUPLEX_MISMATCH), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1", "192.168.255.10");
        EndPointTypeValidator validator = this.m_configDao.getValidator();
        try {
            validator.validate((EndPoint)endPoint);
        }
        catch (EndPointStatusException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.255.10", resource="classpath:/airPairR3_walk.properties")
    public void dwoTestLinkMonitorAirPair3DownLossOfSignal() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.10"), (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.4.1.7262.1.19.3.1.0"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.10"), (SnmpObjId)SnmpObjId.get((String)AIR_PAIR_R3_DUPLEX_MISMATCH), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1", "192.168.255.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    @Ignore
    @JUnitSnmpAgent(host="192.168.255.20", resource="/airPairR4_walk.properties")
    public void dwoTestLinkMonitorAirPairR4() throws UnknownHostException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.20"), (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.4.1.7262.1.19.3.1.0"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.20"), (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.4.1.7262.1.19.3.1.0"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1", "192.168.255.20");
        try {
            this.m_configDao.getValidator().validate((EndPoint)endPoint);
        }
        catch (EndPointStatusException e) {
            Assert.assertTrue((String)"An EndPointStatusException was caught resulting in a failed test", (boolean)false);
        }
    }

    @Test
    @JUnitSnmpAgent(host="192.168.255.31", resource="/horizon_compact_walk.properties")
    public void dwoTestLinkMonitorHorizonCompact() throws UnknownHostException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_ETHERNET_LINK_DOWN), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID, "192.168.255.31");
        try {
            this.m_configDao.getValidator().validate((EndPoint)endPoint);
        }
        catch (Throwable e) {
            Assert.assertTrue((String)"An EndPointStatusException was thrown which shouldn't have and thats why the test failed", (boolean)false);
        }
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.255.31", resource="/horizon_compact_walk.properties")
    public void dwoTestLinkMonitorHorizonCompactDownLossOfSignal() throws EndPointStatusException, UnknownHostException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_ETHERNET_LINK_DOWN), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID, "192.168.255.31");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.255.31", resource="/horizon_compact_walk.properties")
    public void dwoTestLinkMonitorHorizonCompactDownEthernetLinkDown() throws EndPointStatusException, UnknownHostException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.255.31"), (SnmpObjId)SnmpObjId.get((String)HORIZON_COMPACT_ETHERNET_LINK_DOWN), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID, "192.168.255.31");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity1() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity1DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity2() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity2DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity3() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(3L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    @JUnitSnmpAgent(host="192.168.254.10", resource="/horizon_duo_walk.properties")
    public void dwoTestLinkMonitorHorizonDuoCapacity3DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_MODEM_LOSS_OF_SIGNAL), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(2L));
        SnmpUtils.set((SnmpAgentConfig)this.getAgentConfig("192.168.254.10"), (SnmpObjId)SnmpObjId.get((String)HORIZON_DUO_SYSTEM_CAPACITY), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(3L));
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID, "192.168.254.10");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }
}

