/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.config.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.opennms.netmgt.dao.JAXBDataAccessFailureException;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.opennms.netmgt.provision.adapters.link.config.DefaultNamespacePrefixMapper;
import org.opennms.netmgt.provision.adapters.link.config.dao.LinkAdapterConfigurationDao;
import org.opennms.netmgt.provision.adapters.link.config.linkadapter.LinkAdapterConfiguration;
import org.opennms.netmgt.provision.adapters.link.config.linkadapter.LinkPattern;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLinkAdapterConfigurationDao
extends AbstractCastorConfigDao<LinkAdapterConfiguration, LinkAdapterConfiguration>
implements LinkAdapterConfigurationDao {
    private JAXBContext m_context;
    private Marshaller m_marshaller;
    private Unmarshaller m_unmarshaller;

    public DefaultLinkAdapterConfigurationDao() {
        super(LinkAdapterConfiguration.class, "Map Link Adapter Configuration");
    }

    public DefaultLinkAdapterConfigurationDao(Class<LinkAdapterConfiguration> entityClass, String description) {
        super(entityClass, description);
    }

    public LinkAdapterConfiguration translateConfig(LinkAdapterConfiguration config) {
        return config;
    }

    @Override
    public Set<LinkPattern> getPatterns() {
        Assert.notNull((Object)this.getContainer(), (String)"LinkAdapterConfigDao has no container!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"LinkAdapterConfigDao has no configuration loaded!");
        return ((LinkAdapterConfiguration)this.getContainer().getObject()).getPatterns();
    }

    @Override
    public void setPatterns(Set<LinkPattern> patterns) {
        Assert.notNull((Object)this.getContainer(), (String)"LinkAdapterConfigDao has no container!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"LinkAdapterConfigDao has no configuration loaded!");
        ((LinkAdapterConfiguration)this.getContainer().getObject()).setPatterns(patterns);
    }

    @Override
    public synchronized void saveCurrent() {
        File file;
        try {
            file = this.getConfigResource().getFile();
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource() + ": " + e, (Throwable)e);
        }
        if (file == null) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource());
        }
        try {
            this.m_marshaller.marshal(this.getContainer().getObject(), file);
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Could not marshal configuration file for " + this.getConfigResource() + ": " + e, (Throwable)e);
        }
    }

    protected LinkAdapterConfiguration loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Loading " + this.getDescription() + " configuration from " + resource);
        }
        try {
            InputStream is = resource.getInputStream();
            LinkAdapterConfiguration config = (LinkAdapterConfiguration)this.m_unmarshaller.unmarshal(is);
            is.close();
            long endTime = System.currentTimeMillis();
            this.log().info(this.createLoadedLogMessage(config, endTime - startTime));
            return config;
        }
        catch (Exception e) {
            throw new JAXBDataAccessFailureException("Unable to unmarshal the link adapter configuration.", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        try {
            this.m_context = JAXBContext.newInstance((Class[])new Class[]{LinkAdapterConfiguration.class, LinkPattern.class});
            this.m_marshaller = this.m_context.createMarshaller();
            this.m_marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.m_marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new DefaultNamespacePrefixMapper("http://xmlns.opennms.org/xsd/config/map-link-adapter"));
            this.m_unmarshaller = this.m_context.createUnmarshaller();
            this.m_unmarshaller.setSchema(null);
            DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
            this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create JAXB context.", e);
        }
        super.afterPropertiesSet();
    }
}

