/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.endpoint.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.JAXBDataAccessFailureException;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.opennms.netmgt.provision.adapters.link.config.DefaultNamespacePrefixMapper;
import org.opennms.netmgt.provision.adapters.link.endpoint.AndEndPointValidationExpression;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointType;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.MatchingSnmpEndPointValidationExpression;
import org.opennms.netmgt.provision.adapters.link.endpoint.OrEndPointValidationExpression;
import org.opennms.netmgt.provision.adapters.link.endpoint.PingEndPointValidationExpression;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndPointConfigurationDao
extends AbstractCastorConfigDao<EndPointTypeValidator, EndPointTypeValidator>
implements EndPointConfigurationDao {
    private JAXBContext m_context;
    private Marshaller m_marshaller;
    private Unmarshaller m_unmarshaller;

    public DefaultEndPointConfigurationDao() {
        super(EndPointTypeValidator.class, "End Point Type Configuration");
    }

    public DefaultEndPointConfigurationDao(Class<EndPointTypeValidator> entityClass, String description) {
        super(entityClass, description);
    }

    public EndPointTypeValidator translateConfig(EndPointTypeValidator config) {
        return config;
    }

    @Override
    public String getXsd() {
        StringResolver resolver = new StringResolver();
        try {
            this.m_context.generateSchema((SchemaOutputResolver)resolver);
        }
        catch (IOException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to generate schema", (Object[])new Object[0]);
            return null;
        }
        return resolver.getXml();
    }

    @Override
    public EndPointTypeValidator getValidator() {
        Assert.notNull((Object)this.getContainer(), (String)"no container found!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"no configuration loaded!");
        return (EndPointTypeValidator)this.getContainer().getObject();
    }

    @Override
    public synchronized void save(EndPointTypeValidator validator) {
        File file;
        Assert.notNull((Object)this.getContainer(), (String)"no container found!");
        Assert.notNull((Object)this.getContainer().getObject(), (String)"no configuration loaded!");
        try {
            file = this.getConfigResource().getFile();
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource() + ": " + e, (Throwable)e);
        }
        if (file == null) {
            throw new DataAccessResourceFailureException("Unable to determine file for " + this.getConfigResource());
        }
        try {
            this.m_marshaller.marshal(this.getContainer().getObject(), file);
        }
        catch (Exception e) {
            throw new DataAccessResourceFailureException("Could not marshal configuration file for " + this.getConfigResource() + ": " + e, (Throwable)e);
        }
    }

    protected EndPointTypeValidator loadConfig(Resource resource) {
        long startTime = System.currentTimeMillis();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Loading " + this.getDescription() + " configuration from " + resource);
        }
        try {
            InputStream is = resource.getInputStream();
            EndPointTypeValidator config = (EndPointTypeValidator)this.m_unmarshaller.unmarshal(is);
            is.close();
            long endTime = System.currentTimeMillis();
            this.log().info(this.createLoadedLogMessage(config, endTime - startTime));
            return config;
        }
        catch (Exception e) {
            throw new JAXBDataAccessFailureException("Unable to unmarshal the endpoint configuration.", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        try {
            this.m_context = JAXBContext.newInstance((Class[])new Class[]{EndPointTypeValidator.class, EndPointType.class, AndEndPointValidationExpression.class, OrEndPointValidationExpression.class, MatchingSnmpEndPointValidationExpression.class, PingEndPointValidationExpression.class});
            this.m_marshaller = this.m_context.createMarshaller();
            this.m_marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.m_marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new DefaultNamespacePrefixMapper("http://xmlns.opennms.org/xsd/config/endpoint-types"));
            this.m_unmarshaller = this.m_context.createUnmarshaller();
            this.m_unmarshaller.setSchema(null);
            DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
            this.m_unmarshaller.setEventHandler((ValidationEventHandler)handler);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create JAXB context.", e);
        }
        super.afterPropertiesSet();
    }

    private static final class StringResolver
    extends SchemaOutputResolver {
        private StringWriter m_writer = new StringWriter();

        private StringResolver() {
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            StreamResult sr = new StreamResult(this.m_writer);
            sr.setSystemId("unused-but-requred");
            return sr;
        }

        public String getXml() {
            return this.m_writer.toString();
        }
    }
}

