/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.config.linkadapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="link-pattern")
public class LinkPattern {
    private Pattern m_compiledPattern;
    private String m_pattern;
    private String m_template;

    public LinkPattern() {
    }

    public LinkPattern(String pattern, String template) {
        this.setPattern(pattern);
        this.setTemplate(template);
    }

    @XmlAttribute(name="match", required=true)
    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern) {
        this.m_compiledPattern = Pattern.compile(pattern, 160);
        this.m_pattern = pattern;
    }

    @XmlElement(name="link", required=true, nillable=false)
    public String getTemplate() {
        return this.m_template;
    }

    public void setTemplate(String template) {
        this.m_template = template;
    }

    public String resolveTemplate(String endPoint) {
        Matcher m = this.m_compiledPattern.matcher(endPoint);
        if (m.matches()) {
            return m.replaceAll(this.m_template);
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("pattern", (Object)this.m_pattern).append("template", (Object)this.m_template).toString();
    }
}

