/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.adapters.link.LinkMatchResolver;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@EventListener(name="LinkProvisioningAdapter")
public class LinkProvisioningAdapter
extends SimplerQueuedProvisioningAdapter {
    private static final String ADAPTER_NAME = "LinkAdapter";
    @Autowired
    private LinkMatchResolver m_linkMatchResolver;
    @Autowired
    private NodeLinkService m_nodeLinkService;

    public LinkProvisioningAdapter() {
        super(ADAPTER_NAME);
    }

    public void init() {
        super.init();
        Assert.notNull((Object)this.m_nodeLinkService, (String)"nodeLinkService must not be null");
        Assert.notNull((Object)this.m_linkMatchResolver, (String)"linkMatchResolver must not be null");
    }

    public void doAddNode(int endPointId) {
        String endPoint1 = this.m_nodeLinkService.getNodeLabel(endPointId);
        String endPoint2 = this.m_linkMatchResolver.getAssociatedEndPoint(endPoint1);
        String nodeLabel = LinkProvisioningAdapter.max(endPoint1, endPoint2);
        String parentNodeLabel = LinkProvisioningAdapter.min(endPoint1, endPoint2);
        Integer nodeId = this.m_nodeLinkService.getNodeId(nodeLabel);
        Integer parentNodeId = this.m_nodeLinkService.getNodeId(parentNodeLabel);
        LinkProvisioningAdapter.log().info(String.format("running doAddNode on node %s nodeId: %d", nodeLabel, nodeId));
        if (nodeId != null && parentNodeId != null) {
            LinkProvisioningAdapter.log().info(String.format("Found link between parentNode %s and node %s", parentNodeLabel, nodeLabel));
            this.m_nodeLinkService.createLink(parentNodeId, nodeId);
        }
    }

    public void doUpdateNode(int nodeid) {
        this.createLinkForNodeIfNecessary(nodeid);
    }

    private void createLinkForNodeIfNecessary(int nodeid) {
        this.doAddNode(nodeid);
    }

    public void doDeleteNode(int nodeid) {
    }

    public void doNotifyConfigChange(int nodeid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/linkd/dataLinkFailed")
    public void dataLinkFailed(Event event) {
        try {
            this.updateLinkStatus("dataLinkFailed", event, "B");
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)((Object)this), (Throwable)t, (String)"Caught an exception in dataLinkFailed", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)((Object)this), (String)"Bailing out of dataLinkFailed handler", (Object[])new Object[0]);
        }
    }

    private void updateLinkStatus(String method, Event event, String newStatus) {
        LogUtils.infof((Object)((Object)this), (String)"%s: received event %s", (Object[])new Object[]{method, event.getUei()});
        String endPoint1 = EventUtils.getParm((Event)event, (String)"endPoint1");
        String endPoint2 = EventUtils.getParm((Event)event, (String)"endPoint2");
        Assert.notNull((Object)endPoint1, (String)"Param endPoint1 cannot be null");
        Assert.notNull((Object)endPoint2, (String)"Param endPoint2 cannot be null");
        String nodeLabel = LinkProvisioningAdapter.max(endPoint1, endPoint2);
        String parentNodeLabel = LinkProvisioningAdapter.min(endPoint1, endPoint2);
        Integer nodeId = this.m_nodeLinkService.getNodeId(nodeLabel);
        Integer parentNodeId = this.m_nodeLinkService.getNodeId(parentNodeLabel);
        if (nodeId != null && parentNodeId != null) {
            LogUtils.infof((Object)((Object)this), (String)"%s: updated link nodeLabel: %s, nodeId: %d, parentLabel: %s, parentId: %d ", (Object[])new Object[]{method, nodeLabel, nodeId, parentNodeLabel, parentNodeId});
            this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, newStatus);
        } else {
            LogUtils.infof((Object)((Object)this), (String)"%s: found no link with parent: %s and node %s", (Object[])new Object[]{method, parentNodeLabel, nodeLabel});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/linkd/dataLinkRestored")
    public void dataLinkRestored(Event event) {
        try {
            this.updateLinkStatus("dataLinkRestored", event, "G");
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)((Object)this), (Throwable)t, (String)"Caught a throwable in dataLinkRestored", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)((Object)this), (String)"Bailing out of dataLinkRestored handler", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(uei="uei.opennms.org/internal/linkd/dataLinkUnmanaged")
    public void dataLinkUnmanaged(Event e) {
        try {
            this.updateLinkStatus("dataLinkUnmanaged", e, "U");
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)((Object)this), (Throwable)t, (String)"Caught a throwable in dataLinkUnmanaged", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)((Object)this), (String)"Bailing out of dataLinkUnmanaged handler", (Object[])new Object[0]);
        }
    }

    public static String max(String string1, String string2) {
        if (string1.compareTo(string2) < 0) {
            return string2;
        }
        return string1;
    }

    public static String min(String string1, String string2) {
        if (string1.compareTo(string2) < 0) {
            return string1;
        }
        return string2;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(LinkProvisioningAdapter.class);
    }

    public void setLinkMatchResolver(LinkMatchResolver linkMatchResolver) {
        this.m_linkMatchResolver = linkMatchResolver;
    }

    public LinkMatchResolver getLinkMatchResolver() {
        return this.m_linkMatchResolver;
    }

    public void setNodeLinkService(NodeLinkService nodeLinkService) {
        this.m_nodeLinkService = nodeLinkService;
    }
}

