/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.LinkStateDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.adapters.link.LinkEventSendingStateTransition;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class DefaultNodeLinkService
implements NodeLinkService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private EndPointConfigurationDao m_endPointConfigDao;
    @Autowired
    private LinkStateDao m_linkStateDao;
    @Autowired
    @Qualifier(value="transactionAware")
    private EventForwarder m_eventForwarder;

    @Override
    @Transactional
    public void saveLinkState(OnmsLinkState state) {
        LogUtils.debugf((Object)this, (String)"saving LinkState %s", (Object[])new Object[]{state.getLinkState()});
        this.m_linkStateDao.saveOrUpdate((Object)state);
        this.m_linkStateDao.flush();
    }

    @Override
    @Transactional
    public void createLink(int nodeParentId, int nodeId) {
        LogUtils.infof((Object)this, (String)"adding link between node: %d and node: %d", (Object[])new Object[]{nodeParentId, nodeId});
        OnmsNode parentNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeParentId));
        Assert.notNull((Object)parentNode, (String)("node with id: " + nodeParentId + " does not exist"));
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        Assert.notNull((Object)node, (String)("node with id: " + nodeId + " does not exist"));
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeParentId));
        List dataLinkInterface = this.m_dataLinkDao.findMatching(criteria);
        DataLinkInterface dli = null;
        if (dataLinkInterface.size() > 1) {
            LogUtils.warnf((Object)this, (String)"more than one data link interface exists for nodes %d and %d", (Object[])new Object[]{nodeParentId, nodeId});
            return;
        }
        if (dataLinkInterface.size() > 0) {
            dli = (DataLinkInterface)dataLinkInterface.iterator().next();
            LogUtils.infof((Object)this, (String)"link between nodes %d and %d already exists", (Object[])new Object[]{nodeParentId, nodeId});
        } else {
            dli = new DataLinkInterface();
            dli.setNodeId(nodeId);
            dli.setNodeParentId(nodeParentId);
            dli.setIfIndex(this.getPrimaryIfIndexForNode(node));
            dli.setParentIfIndex(this.getPrimaryIfIndexForNode(parentNode));
            LogUtils.infof((Object)this, (String)"creating new link between nodes %d and %d", (Object[])new Object[]{nodeParentId, nodeId});
        }
        OnmsLinkState onmsLinkState = null;
        if (dli.getId() != null) {
            onmsLinkState = this.m_linkStateDao.findByDataLinkInterfaceId(dli.getId());
        }
        if (onmsLinkState == null) {
            onmsLinkState = new OnmsLinkState();
        }
        onmsLinkState.setDataLinkInterface(dli);
        Boolean nodeParentEndPoint = this.getEndPointStatus(nodeParentId);
        Boolean nodeEndPoint = this.getEndPointStatus(nodeId);
        OnmsLinkState.LinkState state = OnmsLinkState.LinkState.LINK_UP;
        LinkEventSendingStateTransition transition = new LinkEventSendingStateTransition(dli, this.m_eventForwarder, this);
        if (nodeParentEndPoint == null) {
            state = state.parentNodeEndPointDeleted((OnmsLinkState.LinkStateTransition)transition);
        } else if (!nodeParentEndPoint.booleanValue()) {
            state = state.parentNodeDown((OnmsLinkState.LinkStateTransition)transition);
        }
        if (nodeEndPoint == null) {
            state = state.nodeEndPointDeleted((OnmsLinkState.LinkStateTransition)transition);
        } else if (!nodeEndPoint.booleanValue()) {
            state = state.nodeDown(null);
        }
        dli.setStatus(state.getDataLinkInterfaceStateType());
        onmsLinkState.setLinkState(state);
        dli.setLastPollTime(new Date());
        dli.setLinkTypeId(Integer.valueOf(777));
        this.m_dataLinkDao.save((Object)dli);
        this.m_linkStateDao.save((Object)onmsLinkState);
    }

    private int getPrimaryIfIndexForNode(OnmsNode node) {
        if (node.getPrimaryInterface() != null && node.getPrimaryInterface().getIfIndex() != null) {
            return node.getPrimaryInterface().getIfIndex();
        }
        return -1;
    }

    @Override
    @Transactional(readOnly=true)
    public Integer getNodeId(String endPoint) {
        Collection nodes = this.m_nodeDao.findByLabel(endPoint);
        if (nodes.size() > 0) {
            return ((OnmsNode)nodes.iterator().next()).getId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public String getNodeLabel(int nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node != null) {
            return node.getLabel();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<DataLinkInterface> getLinkContainingNodeId(int nodeId) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"nodeId", (Object)nodeId), (Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeId)));
        return this.m_dataLinkDao.findMatching(criteria);
    }

    @Override
    @Transactional(readOnly=true)
    public OnmsLinkState getLinkStateForInterface(DataLinkInterface dataLinkInterface) {
        return this.m_linkStateDao.findByDataLinkInterfaceId(dataLinkInterface.getId());
    }

    @Override
    @Transactional
    public void updateLinkStatus(int nodeParentId, int nodeId, String status) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"nodeId", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeParentId));
        List dataLinkInterface = this.m_dataLinkDao.findMatching(criteria);
        if (dataLinkInterface.size() > 0) {
            DataLinkInterface dataLink = (DataLinkInterface)dataLinkInterface.iterator().next();
            dataLink.setStatus(status);
            this.m_dataLinkDao.update((Object)dataLink);
            this.m_dataLinkDao.flush();
        }
    }

    @Override
    @Transactional(readOnly=true)
    public String getPrimaryAddress(int nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (node != null && primaryInterface != null) {
            return primaryInterface.getIpAddress();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean nodeHasEndPointService(int nodeId) {
        OnmsMonitoredService endPointService = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(nodeId), this.m_endPointConfigDao.getValidator().getServiceName());
        return endPointService != null;
    }

    @Override
    @Transactional(readOnly=true)
    public Boolean getEndPointStatus(int nodeId) {
        OnmsMonitoredService endPointService = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(nodeId), this.m_endPointConfigDao.getValidator().getServiceName());
        if (endPointService == null) {
            return null;
        }
        return !endPointService.isDown();
    }
}

