/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.provision.adapters.link.LinkEventSendingStateTransition;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.annotation.Transactional;

@EventListener(name="LinkEventCorrelator")
public class LinkEventCorrelator {
    private EventForwarder m_forwarder;
    private NodeLinkService m_nodeLinkService;
    private EndPointConfigurationDao m_endPointConfigDao;

    public boolean isLinkUp(Event e) {
        return false;
    }

    public void logEvent(Event e) {
        LogUtils.debugf((Object)this, (String)"Correlating Event %s/%d/%s/%s", (Object[])new Object[]{e.getUei(), e.getNodeid(), e.getInterface(), e.getService()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/nodeDown")
    public void handleNodeDown(Event e) {
        try {
            this.logEvent(e);
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.nodeHasEndPointService(nodeId)) {
                this.linkDown(nodeId);
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable handleNodeDown", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleNodeDown", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/nodeUp")
    public void handleNodeUp(Event e) {
        try {
            this.logEvent(e);
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.nodeHasEndPointService(nodeId)) {
                this.linkUp(nodeId);
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleNodeUp", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleNodeUp", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/interfaceDown")
    public void handleInterfaceDown(Event e) {
        try {
            this.logEvent(e);
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.nodeHasEndPointService(nodeId)) {
                this.linkDown(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleInterfaceDown", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleInterfaceDown", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/interfaceUp")
    public void handleInterfaceUp(Event e) {
        try {
            this.logEvent(e);
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.nodeHasEndPointService(nodeId)) {
                this.linkUp(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is not the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleInterfaceUp", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleInterfaceUp", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/serviceUnresponsive")
    public void handleServiceUnresponsive(Event e) {
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.linkDown(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable handleServiceUnresponsive", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleServiceUnresponsive", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/serviceResponsive")
    public void handleServiceResponsive(Event e) {
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.linkUp(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleServiceResponsive", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleServiceResponsive", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void handleNodeGainedService(Event e) {
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.endPointFound(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleNodeGained", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleNodeGainedService", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void handleNodeLostService(Event e) {
        LogUtils.debugf((Object)this, (String)"A special log msg for %s", (Object[])new Object[]{e.getUei()});
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.linkDown(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleNodeLostService!", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleNodeLostService", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void handleNodeRegainedService(Event e) {
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.linkUp(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is node the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleNodeRegainedService!", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleNodeRegainedService", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/serviceUnmanaged")
    public void handleServiceUnmanaged(Event e) {
        try {
            this.logEvent(e);
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.linkUp(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is not the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleServiceUnmanaged!", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleServiceUnmanaged", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    @EventHandler(uei="uei.opennms.org/nodes/serviceDeleted")
    public void handleServiceDeleted(Event e) {
        try {
            if (e.getService() != null && !e.getService().equals(this.getEndPointTypeValidator().getServiceName())) {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since service %s does not match EndPoint service %s", (Object[])new Object[]{e.getUei(), e.getService(), this.getEndPointTypeValidator().getServiceName()});
                return;
            }
            int nodeId = Long.valueOf(e.getNodeid()).intValue();
            if (this.isSnmpPrimary(nodeId, e.getInterface())) {
                this.endPointDeleted(nodeId);
            } else {
                LogUtils.debugf((Object)this, (String)"Discarding Event %s since ip %s is not the primary interface of node %d", (Object[])new Object[]{e.getUei(), e.getInterface(), e.getNodeid()});
            }
        }
        catch (Throwable t) {
            LogUtils.debugf((Object)this, (Throwable)t, (String)"Caught a throwable in handleServiceDeleted", (Object[])new Object[0]);
        }
        finally {
            LogUtils.debugf((Object)this, (String)"Bailing out of handleServiceDeleted", (Object[])new Object[0]);
        }
    }

    private void linkDown(int nodeId) {
        LogUtils.debugf((Object)this, (String)"Processing a down for links with endpoint on node %d", (Object[])new Object[]{nodeId});
        for (DataLinkInterface dli : this.m_nodeLinkService.getLinkContainingNodeId(nodeId)) {
            boolean isParent = false;
            LinkEventSendingStateTransition transition = new LinkEventSendingStateTransition(dli, this.m_forwarder, this.m_nodeLinkService);
            OnmsLinkState linkStateObj = this.m_nodeLinkService.getLinkStateForInterface(dli);
            if (linkStateObj == null) {
                linkStateObj = new OnmsLinkState();
                linkStateObj.setDataLinkInterface(dli);
                linkStateObj.setLinkState(OnmsLinkState.LinkState.LINK_UP);
            }
            OnmsLinkState.LinkState linkState = linkStateObj.getLinkState();
            isParent = dli.getNodeId() != nodeId;
            linkState = linkState.down(isParent, (OnmsLinkState.LinkStateTransition)transition);
            linkStateObj.setLinkState(linkState);
            this.m_nodeLinkService.saveLinkState(linkStateObj);
        }
    }

    private void endPointDeleted(int nodeId) {
        for (DataLinkInterface dli : this.m_nodeLinkService.getLinkContainingNodeId(nodeId)) {
            LinkEventSendingStateTransition transition = new LinkEventSendingStateTransition(dli, this.m_forwarder, this.m_nodeLinkService);
            OnmsLinkState linkStateObj = this.m_nodeLinkService.getLinkStateForInterface(dli);
            if (linkStateObj == null) {
                linkStateObj = new OnmsLinkState();
                linkStateObj.setDataLinkInterface(dli);
                linkStateObj.setLinkState(OnmsLinkState.LinkState.LINK_UP);
            }
            OnmsLinkState.LinkState linkState = linkStateObj.getLinkState();
            linkState = dli.getNodeId() == nodeId ? linkState.nodeEndPointDeleted((OnmsLinkState.LinkStateTransition)transition) : linkState.parentNodeEndPointDeleted((OnmsLinkState.LinkStateTransition)transition);
            linkStateObj.setLinkState(linkState);
            this.m_nodeLinkService.saveLinkState(linkStateObj);
        }
    }

    private void linkUp(int nodeId) {
        for (DataLinkInterface dli : this.m_nodeLinkService.getLinkContainingNodeId(nodeId)) {
            boolean isParent = false;
            LinkEventSendingStateTransition transition = new LinkEventSendingStateTransition(dli, this.m_forwarder, this.m_nodeLinkService);
            OnmsLinkState linkStateObj = this.m_nodeLinkService.getLinkStateForInterface(dli);
            if (linkStateObj == null) {
                linkStateObj = new OnmsLinkState();
                linkStateObj.setDataLinkInterface(dli);
                linkStateObj.setLinkState(OnmsLinkState.LinkState.LINK_UP);
            }
            OnmsLinkState.LinkState linkState = linkStateObj.getLinkState();
            isParent = dli.getNodeId() != nodeId;
            linkState = linkState.up(isParent, (OnmsLinkState.LinkStateTransition)transition);
            linkStateObj.setLinkState(linkState);
            this.m_nodeLinkService.saveLinkState(linkStateObj);
        }
    }

    private void endPointFound(int nodeId) {
        for (DataLinkInterface dli : this.m_nodeLinkService.getLinkContainingNodeId(nodeId)) {
            LinkEventSendingStateTransition transition = new LinkEventSendingStateTransition(dli, this.m_forwarder, this.m_nodeLinkService);
            OnmsLinkState linkStateObj = this.m_nodeLinkService.getLinkStateForInterface(dli);
            if (linkStateObj == null) {
                linkStateObj = new OnmsLinkState();
                linkStateObj.setDataLinkInterface(dli);
                linkStateObj.setLinkState(OnmsLinkState.LinkState.LINK_BOTH_UNMANAGED);
            }
            OnmsLinkState.LinkState linkState = linkStateObj.getLinkState();
            linkState = dli.getNodeId() == nodeId ? linkState.nodeEndPointFound((OnmsLinkState.LinkStateTransition)transition) : linkState.parentNodeEndPointFound((OnmsLinkState.LinkStateTransition)transition);
            linkStateObj.setLinkState(linkState);
            this.m_nodeLinkService.saveLinkState(linkStateObj);
        }
    }

    public boolean isSnmpPrimary(int nodeId, String ipAddr) {
        String primaryAddress = this.m_nodeLinkService.getPrimaryAddress(nodeId);
        if (primaryAddress != null) {
            return primaryAddress.equals(ipAddr);
        }
        return false;
    }

    public boolean nodeHasEndPointService(int nodeId) {
        return this.m_nodeLinkService.nodeHasEndPointService(nodeId);
    }

    public void updateLinkStatus(Event e) {
        throw new UnsupportedOperationException("boo!");
    }

    public void setEventForwarder(EventForwarder forwarder) {
        this.m_forwarder = forwarder;
    }

    public void setNodeLinkService(NodeLinkService nodeLinkService) {
        this.m_nodeLinkService = nodeLinkService;
    }

    public void setEndPointConfigDao(EndPointConfigurationDao endPointConfigDao) {
        this.m_endPointConfigDao = endPointConfigDao;
    }

    private EndPointTypeValidator getEndPointTypeValidator() {
        return this.m_endPointConfigDao.getValidator();
    }
}

