/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.endpoint;

import java.util.Properties;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.DefaultEndPointConfigurationDao;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class EndPointConfigurationTest {
    private EndPointConfigurationDao m_endPointDao;

    @Before
    public void setUp() throws Exception {
        DefaultEndPointConfigurationDao dao = new DefaultEndPointConfigurationDao();
        dao.setConfigResource((Resource)new ClassPathResource("/test-endpoint-configuration.xml"));
        dao.afterPropertiesSet();
        this.m_endPointDao = dao;
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.springframework", "WARN");
        props.setProperty("log4j.logger.org.hibernate", "WARN");
        props.setProperty("log4j.logger.org.opennms", "DEBUG");
        props.setProperty("log4j.logger.org.opennms.netmgt.dao.castor", "WARN");
        MockLogAppender.setupLogging((Properties)props);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    @Test
    public void testGetFromDao() throws Exception {
        EndPointTypeValidator validator = this.m_endPointDao.getValidator();
        Assert.assertEquals((String)"test config has 2 entries", (long)2L, (long)validator.getConfigs().size());
    }

    @Test
    public void testGetXsd() throws Exception {
        String xsd = this.m_endPointDao.getXsd();
        System.err.println(xsd);
        Assert.assertTrue((boolean)xsd.contains("endpoint-type"));
    }
}

