/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.mock.snmp.JUnitSnmpAgent;
import org.opennms.mock.snmp.JUnitSnmpAgentExecutionListener;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.mock.snmp.MockSnmpAgentAware;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.provision.adapters.link.EndPointImpl;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.DefaultEndPointConfigurationDao;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/snmpConfigFactoryContext.xml"})
@JUnitSnmpAgent(resource="classpath:/airPairR3_walk.properties")
@TestExecutionListeners(value={JUnitSnmpAgentExecutionListener.class})
public class LinkMonitoringSnmpTest
implements MockSnmpAgentAware {
    private static final String AIR_PAIR_R3_SYS_OID = ".1.3.6.1.4.1.7262.1";
    private static final String AIR_PAIR_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    private static final String AIR_PAIR_R3_DUPLEX_MISMATCH = ".1.3.6.1.4.1.7262.1.19.2.3.0";
    private static final String AIR_PAIR_R4_SYS_OID = ".1.3.6.1.4.1.7262.1";
    private static final String AIR_PAIR_R4_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    private static final String HORIZON_COMPACT_SYS_OID = ".1.3.6.1.4.1.7262.2.2";
    private static final String HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.2.8.4.4.1.0";
    private static final String HORIZON_COMPACT_ETHERNET_LINK_DOWN = ".1.3.6.1.4.1.7262.2.2.8.3.1.9.0";
    private static final String HORIZON_DUO_SYS_OID = ".1.3.6.1.4.1.7262.2.3";
    private static final String HORIZON_DUO_SYSTEM_CAPACITY = ".1.3.6.1.4.1.7262.2.3.1.1.5.0";
    private static final String HORIZON_DUO_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.3.7.4.1.1.1.2.1";
    private MockSnmpAgent m_snmpAgent;
    private SnmpAgentConfig m_agentConfig;
    private DefaultEndPointConfigurationDao m_configDao;

    @Before
    public void setup() throws InterruptedException, UnknownHostException {
        if (this.m_agentConfig == null) {
            this.m_agentConfig = new SnmpAgentConfig();
            this.m_agentConfig.setAddress(InetAddress.getLocalHost());
            this.m_agentConfig.setPort(9161);
            this.m_agentConfig.setReadCommunity("public");
        }
        DefaultEndPointConfigurationDao dao = new DefaultEndPointConfigurationDao();
        dao.setConfigResource((Resource)new ClassPathResource("/testDWO-configuration.xml"));
        dao.afterPropertiesSet();
        this.m_configDao = dao;
    }

    @After
    public void tearDown() throws InterruptedException {
    }

    @Test
    public void dwoTestEndPointImplGetOid() throws UnknownHostException {
        EndPointImpl endPoint = this.getEndPoint(null);
        SnmpValue snmpVal = endPoint.get(".1.3.6.1.4.1.7262.1.19.3.1.0");
        Assert.assertNotNull((Object)snmpVal);
        Assert.assertEquals((Object)"1", (Object)snmpVal.toString());
    }

    private EndPointImpl getEndPoint(String sysOid) throws UnknownHostException {
        EndPointImpl endPoint = new EndPointImpl(InetAddress.getLocalHost(), this.m_agentConfig);
        endPoint.setSysOid(sysOid);
        return endPoint;
    }

    @Test
    public void dwoTestLinkMonitorAirPairR3() throws UnknownHostException {
        Assert.assertNotNull((Object)this.m_snmpAgent);
        this.m_snmpAgent.updateCounter32Value(".1.3.6.1.4.1.7262.1.19.3.1.0", 1);
        this.m_snmpAgent.updateCounter32Value(AIR_PAIR_R3_DUPLEX_MISMATCH, 1);
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1");
        EndPointTypeValidator validator = this.m_configDao.getValidator();
        try {
            validator.validate((EndPoint)endPoint);
        }
        catch (EndPointStatusException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorAirPair3DownLossOfSignal() throws UnknownHostException, EndPointStatusException {
        this.m_snmpAgent.updateCounter32Value(".1.3.6.1.4.1.7262.1.19.3.1.0", 2);
        this.m_snmpAgent.updateCounter32Value(AIR_PAIR_R3_DUPLEX_MISMATCH, 1);
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1");
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    @Ignore
    public void dwoTestLinkMonitorAirPairR4() throws UnknownHostException {
        ClassPathResource resource = new ClassPathResource("/airPairR4_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(".1.3.6.1.4.1.7262.1.19.3.1.0", 1);
        this.m_snmpAgent.updateCounter32Value(".1.3.6.1.4.1.7262.1.19.3.1.0", 1);
        EndPointImpl endPoint = this.getEndPoint(".1.3.6.1.4.1.7262.1");
        try {
            this.m_configDao.getValidator().validate((EndPoint)endPoint);
        }
        catch (EndPointStatusException e) {
            Assert.assertTrue((String)"An EndPointStatusException was caught resulting in a failed test", (boolean)false);
        }
    }

    @Test
    public void dwoTestLinkMonitorHorizonCompact() throws UnknownHostException {
        ClassPathResource resource = new ClassPathResource("/horizon_compact_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL, 1);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_ETHERNET_LINK_DOWN, 1);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID);
        try {
            this.m_configDao.getValidator().validate((EndPoint)endPoint);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"An EndPointStatusException was thrown which shouldn't have and thats why the test failed", (boolean)false);
        }
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorHorizonCompactDownLossOfSignal() throws EndPointStatusException, UnknownHostException {
        ClassPathResource resource = new ClassPathResource("/horizon_compact_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL, 2);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_ETHERNET_LINK_DOWN, 1);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorHorizonCompactDownEthernetLinkDown() throws EndPointStatusException, UnknownHostException {
        ClassPathResource resource = new ClassPathResource("/horizon_compact_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL, 1);
        this.m_snmpAgent.updateCounter32Value(HORIZON_COMPACT_ETHERNET_LINK_DOWN, 2);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_COMPACT_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    public void dwoTestLinkMonitorHorizonDuoCapacity1() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 1);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 1);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorHorizonDuoCapacity1DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 2);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 1);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    public void dwoTestLinkMonitorHorizonDuoCapacity2() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 1);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 2);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorHorizonDuoCapacity2DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 2);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 2);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test
    public void dwoTestLinkMonitorHorizonDuoCapacity3() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 1);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 3);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    @Test(expected=EndPointStatusException.class)
    public void dwoTestLinkMonitorHorizonDuoCapacity3DownModemLossSignal() throws UnknownHostException, EndPointStatusException {
        ClassPathResource resource = new ClassPathResource("/horizon_duo_walk.properties");
        this.m_snmpAgent.updateValuesFromResource((Resource)resource);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_MODEM_LOSS_OF_SIGNAL, 2);
        this.m_snmpAgent.updateCounter32Value(HORIZON_DUO_SYSTEM_CAPACITY, 3);
        EndPointImpl endPoint = this.getEndPoint(HORIZON_DUO_SYS_OID);
        this.m_configDao.getValidator().validate((EndPoint)endPoint);
    }

    public void setMockSnmpAgent(MockSnmpAgent agent) {
        this.m_snmpAgent = agent;
    }
}

