/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.DefaultEndPointConfigurationDao;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.netmgt.snmp.mock.TestSnmpValue;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkMonitorValidatorTest {
    public static final String AIR_PAIR_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    public static final String AIR_PAIR_R3_DUPLEX_MISMATCH = ".1.3.6.1.4.1.7262.1.19.2.3.0";
    public static final String AIR_PAIR_R4_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.1.19.3.1.0";
    public static final String HORIZON_COMPACT_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.2.8.4.4.1.0";
    public static final String HORIZON_COMPACT_ETHERNET_LINK_DOWN = ".1.3.6.1.4.1.7262.2.2.8.3.1.9.0";
    public static final String HORIZON_DUO_SYSTEM_CAPACITY = ".1.3.6.1.4.1.7262.2.3.1.1.5.0";
    public static final String HORIZON_DUO_MODEM_LOSS_OF_SIGNAL = ".1.3.6.1.4.1.7262.2.3.7.4.1.1.1.2";
    EasyMockUtils m_easyMock = new EasyMockUtils();
    static EndPoint m_mockEndPoint;
    EndPointConfigurationDao m_configDao;

    @Before
    public void setup() {
        DefaultEndPointConfigurationDao dao = new DefaultEndPointConfigurationDao();
        dao.setConfigResource((Resource)new ClassPathResource("/test-endpoint-configuration.xml"));
        dao.afterPropertiesSet();
        this.m_configDao = dao;
        m_mockEndPoint = this.createMock(EndPoint.class);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void dwoTestAirPair3Validator() throws Exception {
        EasyMock.expect((Object)m_mockEndPoint.get(".1.3.6.1.4.1.7262.1.19.3.1.0")).andStubReturn((Object)TestSnmpValue.parseMibValue((String)"STRING: 1"));
        EasyMock.expect((Object)m_mockEndPoint.get(AIR_PAIR_R3_DUPLEX_MISMATCH)).andStubReturn((Object)TestSnmpValue.parseMibValue((String)"STRING: 1"));
        EasyMock.expect((Object)m_mockEndPoint.getSysOid()).andStubReturn((Object)".1.3.6.1.4.1.7262.1");
        this.replay();
        this.m_configDao.getValidator().validate(m_mockEndPoint);
        this.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EndPointStatusException.class)
    public void dwoTestAirPair3FailingValidator() throws Exception {
        EasyMock.expect((Object)m_mockEndPoint.get(".1.3.6.1.4.1.7262.1.19.3.1.0")).andStubReturn((Object)TestSnmpValue.parseMibValue((String)"STRING: 2"));
        EasyMock.expect((Object)m_mockEndPoint.get(AIR_PAIR_R3_DUPLEX_MISMATCH)).andStubReturn((Object)TestSnmpValue.parseMibValue((String)"STRING: 1"));
        EasyMock.expect((Object)m_mockEndPoint.getSysOid()).andStubReturn((Object)".1.3.6.1.4.1.7262.1");
        this.replay();
        try {
            this.m_configDao.getValidator().validate(m_mockEndPoint);
        }
        finally {
            this.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EndPointStatusException.class)
    public void dwoTestPingEndPointFailed() throws Exception {
        EasyMock.expect((Object)m_mockEndPoint.getSysOid()).andStubReturn((Object)".1.2.3.4");
        EasyMock.expect((Object)m_mockEndPoint.ping()).andReturn((Object)false);
        this.replay();
        try {
            this.m_configDao.getValidator().validate(m_mockEndPoint);
        }
        finally {
            this.verify();
        }
    }

    @Test
    public void dwoTestPingEndPointSuccess() throws Exception {
        EasyMock.expect((Object)m_mockEndPoint.getSysOid()).andStubReturn((Object)".1.2.3.4");
        EasyMock.expect((Object)m_mockEndPoint.ping()).andReturn((Object)true);
        this.replay();
        this.m_configDao.getValidator().validate(m_mockEndPoint);
        this.verify();
    }

    public <T> T createMock(Class<T> clazz) {
        return (T)this.m_easyMock.createMock(clazz);
    }

    public void verify() {
        this.m_easyMock.verifyAll();
    }

    public void replay() {
        this.m_easyMock.replayAll();
    }

    public static class EndPointFactory {
        public static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";

        public EndPoint createEndPoint(MonitoredService svc) {
            return m_mockEndPoint;
        }
    }
}

