/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.io.Serializable;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.LinkStateDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLinkState;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.provision.adapters.link.NodeLinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/provisiond-extensions.xml", "classpath:/testConfigContext.xml"})
@JUnitTemporaryDatabase
public class DefaultNodeLinkServiceTest {
    private static final int END_POINT1_ID = 1;
    private static final int END_POINT2_ID = 2;
    private static final int END_POINT3_ID = 3;
    private static final String END_POINT1_LABEL = "node1";
    public static final String NO_SUCH_NODE_LABEL = "noSuchNode";
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    LinkStateDao m_linkStateDao;
    @Autowired
    DataLinkInterfaceDao m_dataLinkDao;
    @Autowired
    MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    NodeLinkService m_nodeLinkService;
    @Autowired
    ServiceTypeDao m_serviceTypeDao;
    @Autowired
    TransactionTemplate m_transactionTemplate;

    @Before
    public void setup() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    public void dwoNotNull() {
        Assert.assertNotNull((Object)this.m_dbPopulator);
        Assert.assertNotNull((Object)this.m_nodeDao);
        Assert.assertNotNull((Object)this.m_jdbcTemplate);
        Assert.assertNotNull((Object)this.m_monitoredServiceDao);
    }

    @Test
    public void dwoTestGetNodeLabel() {
        String nodeLabel = this.m_nodeLinkService.getNodeLabel(1);
        Assert.assertNotNull((Object)nodeLabel);
        Assert.assertEquals((Object)END_POINT1_LABEL, (Object)nodeLabel);
    }

    @Test
    public void dwoTestNodeNotThere() {
        String nodeLabel = this.m_nodeLinkService.getNodeLabel(200);
        Assert.assertNull((Object)nodeLabel);
    }

    @Test
    public void dwoTestGetNodeId() {
        Integer nodeId = this.m_nodeLinkService.getNodeId(END_POINT1_LABEL);
        Assert.assertNotNull((Object)nodeId);
        Assert.assertEquals((Object)1, (Object)nodeId);
    }

    @Test
    public void dwoTestGetNodeIdNull() {
        Integer nodeId = this.m_nodeLinkService.getNodeId(NO_SUCH_NODE_LABEL);
        Assert.assertNull((Object)nodeId);
    }

    @Test
    public void dwoTestCreateLink() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(3));
        Assert.assertEquals((long)0L, (long)dataLinks.size());
        this.m_nodeLinkService.createLink(1, 3);
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(3));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
    }

    @Test
    public void dwoTestLinkAlreadyExists() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(2));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
        this.m_nodeLinkService.createLink(1, 2);
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(2));
        Assert.assertEquals((long)1L, (long)dataLinks.size());
    }

    @Test
    public void dwoTestUpdateLinkStatus() {
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(2));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        int parentNodeId = 1;
        int nodeId = 2;
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "G");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(2));
        Assert.assertEquals((Object)"G", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    public void dwoTestUpdateLinkFailedStatus() {
        int parentNodeId = 1;
        int nodeId = 2;
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "B");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"B", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    public void dwoTestUpdateLinkGoodThenFailedStatus() {
        int parentNodeId = 1;
        int nodeId = 2;
        Collection dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"A", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "G");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"G", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
        this.m_nodeLinkService.updateLinkStatus(parentNodeId, nodeId, "B");
        dataLinks = this.m_dataLinkDao.findByNodeId(Integer.valueOf(nodeId));
        Assert.assertEquals((Object)"B", (Object)((DataLinkInterface)dataLinks.iterator().next()).getStatus());
    }

    @Test
    public void dwoTestGetLinkContainingNodeId() {
        int parentNodeId = 1;
        Collection datalinks = this.m_nodeLinkService.getLinkContainingNodeId(parentNodeId);
        Assert.assertEquals((long)3L, (long)datalinks.size());
    }

    @Test
    public void dwoTestGetLinkStateForInterface() {
        int nodeId = 2;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        Assert.assertNotNull((Object)dli);
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState);
        this.m_linkStateDao.flush();
        linkState = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertNotNull((String)"linkState was null", (Object)linkState);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState.getLinkState());
    }

    @Test
    public void dwoTestSaveLinkState() {
        int nodeId = 2;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        this.m_linkStateDao.save((Object)linkState);
        this.m_linkStateDao.flush();
        OnmsLinkState linkState2 = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertNotNull((String)"linkState was null", (Object)linkState2);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_UP, (Object)linkState2.getLinkState());
        linkState2.setLinkState(OnmsLinkState.LinkState.LINK_NODE_DOWN);
        this.m_nodeLinkService.saveLinkState(linkState2);
        OnmsLinkState linkState3 = this.m_nodeLinkService.getLinkStateForInterface(dli);
        Assert.assertEquals((Object)OnmsLinkState.LinkState.LINK_NODE_DOWN, (Object)linkState3.getLinkState());
    }

    @Test
    public void dwoTestSaveAllEnumStates() {
        int nodeId = 2;
        Collection dlis = this.m_nodeLinkService.getLinkContainingNodeId(nodeId);
        DataLinkInterface dli = (DataLinkInterface)dlis.iterator().next();
        OnmsLinkState linkState = new OnmsLinkState();
        linkState.setDataLinkInterface(dli);
        for (OnmsLinkState.LinkState ls : OnmsLinkState.LinkState.values()) {
            linkState.setLinkState(ls);
            this.saveLinkState(linkState);
        }
    }

    @Test
    public void dwoTestAddPrimaryServiceToNode() {
        String END_POINT_SERVICE_NAME = "EndPoint";
        this.addPrimaryServiceToNode(1, "EndPoint");
        OnmsMonitoredService service = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(1), "ICMP");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"ICMP", (Object)service.getServiceName());
        service = this.m_monitoredServiceDao.getPrimaryService(Integer.valueOf(1), "EndPoint");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"EndPoint", (Object)service.getServiceName());
    }

    @Test
    public void dwoTestNodeHasEndPointService() {
        Assert.assertFalse((boolean)this.m_nodeLinkService.nodeHasEndPointService(1));
        String END_POINT_SERVICE_NAME = "EndPoint";
        this.addPrimaryServiceToNode(1, "EndPoint");
        Assert.assertTrue((boolean)this.m_nodeLinkService.nodeHasEndPointService(1));
    }

    public void addPrimaryServiceToNode(final int nodeId, final String serviceName) {
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                OnmsServiceType svcType = DefaultNodeLinkServiceTest.this.m_serviceTypeDao.findByName(serviceName);
                if (svcType == null) {
                    svcType = new OnmsServiceType(serviceName);
                    DefaultNodeLinkServiceTest.this.m_serviceTypeDao.save((Object)svcType);
                    DefaultNodeLinkServiceTest.this.m_serviceTypeDao.flush();
                }
                OnmsNode node = (OnmsNode)DefaultNodeLinkServiceTest.this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
                OnmsIpInterface ipInterface = node.getPrimaryInterface();
                OnmsMonitoredService svc = new OnmsMonitoredService();
                svc.setIpInterface(ipInterface);
                svc.setServiceType(svcType);
                DefaultNodeLinkServiceTest.this.m_monitoredServiceDao.save((Object)svc);
                DefaultNodeLinkServiceTest.this.m_monitoredServiceDao.flush();
                return null;
            }
        });
    }

    public void saveLinkState(final OnmsLinkState linkState) {
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                DefaultNodeLinkServiceTest.this.m_linkStateDao.saveOrUpdate((Object)linkState);
                DefaultNodeLinkServiceTest.this.m_linkStateDao.flush();
                return null;
            }
        });
    }
}

