/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointType;

@XmlRootElement(name="endpoint-types")
public class EndPointTypeValidator {
    @XmlAttribute(name="endpoint-service-name")
    String m_endPointServiceName = "EndPoint";
    @XmlElement(name="endpoint-type")
    List<EndPointType> m_endPointConfigs = Collections.synchronizedList(new ArrayList());

    public String getServiceName() {
        return this.m_endPointServiceName;
    }

    public void setServiceName(String serviceName) {
        this.m_endPointServiceName = serviceName;
    }

    public List<EndPointType> getConfigs() {
        return this.m_endPointConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigs(List<EndPointType> configs) {
        List<EndPointType> list = this.m_endPointConfigs;
        synchronized (list) {
            this.m_endPointConfigs.clear();
            this.m_endPointConfigs.addAll(configs);
        }
    }

    public boolean hasMatch(EndPoint ep) {
        for (EndPointType config : this.m_endPointConfigs) {
            if (!config.matches(ep)) continue;
            return true;
        }
        return false;
    }

    public void validate(EndPoint ep) throws EndPointStatusException {
        for (EndPointType config : this.m_endPointConfigs) {
            if (!config.matches(ep)) continue;
            config.validate(ep);
            return;
        }
        throw new EndPointStatusException(String.format("unable to find matching endpoint type config for endpoint %s", ep));
    }
}

