/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.io.Serializable;
import java.util.Map;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.provision.adapters.link.EndPointImpl;
import org.opennms.netmgt.provision.adapters.link.EndPointStatusException;
import org.opennms.netmgt.provision.adapters.link.endpoint.EndPointTypeValidator;
import org.opennms.netmgt.provision.adapters.link.endpoint.dao.EndPointConfigurationDao;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EndPointMonitor
extends AbstractServiceMonitor {
    public static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private EndPointConfigurationDao m_configDao;
    private NodeDao m_nodeDao;
    private SnmpAgentConfigFactory m_agentConfigFactory;

    public void initialize(Map<String, Object> parameters) {
        ClassPathXmlApplicationContext appContext = (ClassPathXmlApplicationContext)BeanUtils.getFactory((String)"linkAdapterPollerContext", ClassPathXmlApplicationContext.class);
        this.m_configDao = (EndPointConfigurationDao)appContext.getBean("endPointConfigDao");
        this.m_nodeDao = (NodeDao)appContext.getBean("nodeDao");
        this.m_agentConfigFactory = (SnmpAgentConfigFactory)appContext.getBean("snmpPeerFactory", SnmpAgentConfigFactory.class);
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        SnmpAgentConfig agentConfig = this.m_agentConfigFactory.getAgentConfig(svc.getAddress());
        EndPointTypeValidator validator = this.m_configDao.getValidator();
        EndPointImpl ep = new EndPointImpl(svc.getAddress(), agentConfig);
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(svc.getNodeId()));
        ep.setSysOid(node.getSysObjectId());
        try {
            validator.validate(ep);
            return PollStatus.available();
        }
        catch (EndPointStatusException e) {
            return PollStatus.unavailable((String)e.getMessage());
        }
    }
}

