/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.adapters.link;

import java.net.InetAddress;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.provision.adapters.link.EndPoint;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public class EndPointImpl
implements EndPoint {
    private SnmpAgentConfig m_agentConfig;
    private InetAddress m_address;
    private String m_sysOid;

    public EndPointImpl() {
    }

    public EndPointImpl(InetAddress address, SnmpAgentConfig agentConfig) {
        this.m_address = address;
        this.m_agentConfig = agentConfig;
    }

    @Override
    public SnmpValue get(String oid) {
        SnmpObjId objId = SnmpObjId.get((String)oid);
        return SnmpUtils.get((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)objId);
    }

    @Override
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    @Override
    public String getSysOid() {
        return this.m_sysOid;
    }

    public void setSysOid(String sysOid) {
        this.m_sysOid = sysOid;
    }

    @Override
    public boolean ping() {
        try {
            Number result = PingerFactory.getInstance().ping(this.getAddress());
            if (result != null) {
                return true;
            }
        }
        catch (Throwable e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Ping failed for address %s", (Object[])new Object[]{this.getAddress()});
        }
        return false;
    }
}

