/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpObjectId
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 2633631219460364065L;
    private int[] m_data;
    public static final byte ASNTYPE = 6;

    private static int[] convert(String idstr) {
        int numIds = 0;
        char[] idArray = idstr.toCharArray();
        if (idArray.length == 0) {
            int[] tmp = new int[2];
            tmp[1] = 0;
            tmp[0] = 0;
            return tmp;
        }
        if (idArray[0] != '.') {
            ++numIds;
        }
        int x = 0;
        while (x < idArray.length) {
            if (idArray[x++] != '.') continue;
            ++numIds;
        }
        if (numIds == 0) {
            int[] tmp = new int[2];
            tmp[1] = 0;
            tmp[0] = 0;
            return tmp;
        }
        int[] objects = new int[numIds];
        int objectsNdx = 0;
        int idArrayNdx = 0;
        if (idArray[0] == '.') {
            ++idArrayNdx;
        }
        int oid = 0;
        while (idArrayNdx < idArray.length) {
            if (idArray[idArrayNdx] == '.') {
                objects[objectsNdx++] = oid;
                oid = 0;
            } else {
                oid *= 10;
                switch (idArray[idArrayNdx]) {
                    case '1': {
                        ++oid;
                        break;
                    }
                    case '2': {
                        oid += 2;
                        break;
                    }
                    case '3': {
                        oid += 3;
                        break;
                    }
                    case '4': {
                        oid += 4;
                        break;
                    }
                    case '5': {
                        oid += 5;
                        break;
                    }
                    case '6': {
                        oid += 6;
                        break;
                    }
                    case '7': {
                        oid += 7;
                        break;
                    }
                    case '8': {
                        oid += 8;
                        break;
                    }
                    case '9': {
                        oid += 9;
                    }
                }
            }
            ++idArrayNdx;
        }
        objects[objectsNdx++] = oid;
        return objects;
    }

    public SnmpObjectId() {
        this.m_data = new int[2];
        this.m_data[1] = 0;
        this.m_data[0] = 0;
    }

    public SnmpObjectId(int[] data) {
        this();
        if (data != null) {
            this.m_data = new int[data.length];
            System.arraycopy(data, 0, this.m_data, 0, data.length);
        }
    }

    public SnmpObjectId(SnmpObjectId second) {
        this(second.m_data);
    }

    public SnmpObjectId(String strOid) {
        this.m_data = SnmpObjectId.convert(strOid);
        if (this.m_data == null) {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public int getLength() {
        return this.m_data.length;
    }

    public int getLastIdentifier() {
        return this.m_data[this.m_data.length - 1];
    }

    public int[] getIdentifiers() {
        return this.m_data;
    }

    public void setIdentifiers(int[] data) {
        if (data != null) {
            this.m_data = new int[data.length];
            System.arraycopy(data, 0, this.m_data, 0, data.length);
        } else {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public void setIdentifiers(String strOid) {
        this.m_data = null;
        if (strOid != null) {
            this.m_data = SnmpObjectId.convert(strOid);
        }
        if (this.m_data == null) {
            this.m_data = new int[2];
            this.m_data[1] = 0;
            this.m_data[0] = 0;
        }
    }

    public void append(int[] ids) {
        if (ids != null && ids.length != 0) {
            int[] tmp = new int[this.m_data.length + ids.length];
            System.arraycopy(this.m_data, 0, tmp, 0, this.m_data.length);
            System.arraycopy(ids, 0, tmp, this.m_data.length, ids.length);
            this.m_data = tmp;
        }
    }

    public void append(String strOids) {
        int[] tmp = SnmpObjectId.convert(strOids);
        this.append(tmp);
    }

    public void append(SnmpObjectId second) {
        this.append(second.m_data);
    }

    public void prepend(int[] ids) {
        if (ids != null && ids.length != 0) {
            int[] tmp = new int[this.m_data.length + ids.length];
            System.arraycopy(ids, 0, tmp, 0, ids.length);
            System.arraycopy(this.m_data, 0, tmp, ids.length, this.m_data.length);
            this.m_data = tmp;
        }
    }

    public void prepend(String strOids) {
        int[] tmp = SnmpObjectId.convert(strOids);
        this.prepend(tmp);
    }

    public void prepend(SnmpObjectId second) {
        this.prepend(second.m_data);
    }

    public int compare(int[] ids) {
        int aNdx = 0;
        int bNdx = 0;
        int rc = 0;
        while (aNdx < this.m_data.length || bNdx < ids.length) {
            int a = 0;
            if (aNdx < this.m_data.length) {
                a = this.m_data[aNdx++] + 1;
            }
            int b = 0;
            if (bNdx < ids.length) {
                b = ids[bNdx++] + 1;
            }
            if ((rc = a - b) == 0) continue;
            break;
        }
        return rc;
    }

    public int compare(int[] ids, int dist) {
        int aNdx = 0;
        int bNdx = 0;
        int rc = 0;
        while ((aNdx < this.m_data.length || bNdx < ids.length) && --dist >= 0) {
            int a = 0;
            if (aNdx < this.m_data.length) {
                a = this.m_data[aNdx++] + 1;
            }
            int b = 0;
            if (bNdx < ids.length) {
                b = ids[bNdx++] + 1;
            }
            if ((rc = a - b) == 0) continue;
            break;
        }
        return rc;
    }

    public int compare(SnmpObjectId cmp) {
        return this.compare(cmp.m_data);
    }

    public boolean isRootOf(SnmpObjectId leaf) {
        return this.compare(leaf.m_data, this.m_data.length) == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof SnmpObjectId) {
            return this.compare(((SnmpObjectId)o).m_data) == 0;
        }
        if (o instanceof String) {
            return this.compare(SnmpObjectId.convert((String)o)) == 0;
        }
        if (o instanceof int[]) {
            return this.compare((int[])o) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.ensureCapacity(this.m_data.length * 3);
        for (int x = 0; x < this.m_data.length; ++x) {
            buf.append('.');
            if (this.m_data[x] >= 0) {
                buf.append(this.m_data[x]);
                continue;
            }
            long oid = (long)this.m_data[x] & 0xFFFFFFFFL;
            buf.append(oid);
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            hash = hash * 31 + this.m_data[i];
        }
        return hash;
    }

    public byte typeId() {
        return 6;
    }

    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        return encoder.buildObjectId(buf, offset, this.typeId(), this.m_data);
    }

    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseObjectId(buf, offset);
        if (((Byte)rVals[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_data = (int[])rVals[2];
        return (Integer)rVals[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpObjectId(this);
    }

    public Object clone() {
        return new SnmpObjectId(this);
    }
}

