/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.io.InputStream;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);
    private static final String LOG4J_CATEGORY = "jetty-server";
    int m_port = 8080;
    private Server m_server;

    protected JettyServer() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        File jettyXml = new File(System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "jetty.xml");
        InputStream jettyXmlStream = null;
        try {
            this.m_server = new Server();
            jettyXmlStream = jettyXml.exists() ? jettyXml.toURI().toURL().openStream() : ((Object)((Object)this)).getClass().getResourceAsStream("jetty.xml");
            if (jettyXmlStream == null) {
                throw new RuntimeException("Unable to locate jetty.xml in the classpath!");
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(jettyXmlStream);
            xmlConfiguration.configure((Object)this.m_server);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        this.m_server.setStopAtShutdown(true);
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting Jetty Server", t);
        }
    }

    protected void onStop() {
        try {
            this.m_server.stop();
        }
        catch (Throwable t) {
            LOG.error("Error stopping Jetty Server", t);
        }
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public long getHttpsConnectionsTotal() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnections();
        }
        return retval;
    }

    public long getHttpsConnectionsOpen() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnectionsOpen();
        }
        return retval;
    }

    public long getHttpsConnectionsOpenMax() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SslSocketConnector)) continue;
            retval += (long)conn.getConnectionsOpenMax();
        }
        return retval;
    }

    public long getHttpConnectionsTotal() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnections();
        }
        return retval;
    }

    public long getHttpConnectionsOpen() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnectionsOpen();
        }
        return retval;
    }

    public long getHttpConnectionsOpenMax() {
        long retval = 0L;
        for (Connector conn : this.m_server.getConnectors()) {
            if (!(conn instanceof SelectChannelConnector)) continue;
            retval += (long)conn.getConnectionsOpenMax();
        }
        return retval;
    }
}

