/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.ajp.Ajp13SocketConnector;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.serviceregistration.ServiceRegistrationFactory;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

public class JettyServer
extends AbstractServiceDaemon
implements SpringServiceDaemon {
    int m_port = 8080;
    private Server m_server;
    private Hashtable<String, ServiceRegistrationStrategy> services = new Hashtable();

    protected JettyServer() {
        super("OpenNMS.JettyServer");
    }

    protected void onInit() {
        Integer https_port;
        Properties p = System.getProperties();
        File homeDir = new File(p.getProperty("opennms.home"));
        File webappsDir = new File(homeDir, "jetty-webapps");
        this.m_server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        Integer port = Integer.getInteger("org.opennms.netmgt.jetty.port", this.m_port);
        connector.setPort(port.intValue());
        String host = System.getProperty("org.opennms.netmgt.jetty.host");
        if (host != null) {
            connector.setHost(host);
        }
        this.m_server.addConnector((Connector)connector);
        Integer ajp_port = Integer.getInteger("org.opennms.netmgt.jetty.ajp-port");
        if (ajp_port != null) {
            connector = new Ajp13SocketConnector();
            connector.setPort(ajp_port.intValue());
            connector.setHeaderBufferSize(8096);
            this.m_server.addConnector((Connector)connector);
        }
        if ((https_port = Integer.getInteger("org.opennms.netmgt.jetty.https-port")) != null) {
            SslSocketConnector sslConnector = new SslSocketConnector();
            sslConnector.setPort(https_port.intValue());
            this.excludeCipherSuites(sslConnector);
            sslConnector.setKeystore(System.getProperty("org.opennms.netmgt.jetty.https-keystore", homeDir + File.separator + "etc" + File.separator + "examples" + File.separator + "jetty.keystore"));
            sslConnector.setPassword(System.getProperty("org.opennms.netmgt.jetty.https-keystorepassword", "changeit"));
            sslConnector.setKeyPassword(System.getProperty("org.opennms.netmgt.jetty.https-keypassword", "changeit"));
            String httpsHost = System.getProperty("org.opennms.netmgt.jetty.https-host");
            if (httpsHost != null) {
                sslConnector.setHost(httpsHost);
            }
            this.m_server.addConnector((Connector)sslConnector);
        }
        HandlerCollection handlers = new HandlerCollection();
        if (webappsDir.exists()) {
            File rootDir = null;
            for (File file : webappsDir.listFiles()) {
                if (!file.isDirectory()) continue;
                if ("ROOT".equals(file.getName())) {
                    rootDir = file;
                    continue;
                }
                String contextPath = "/" + file.getName();
                this.addContext(handlers, file, contextPath);
                this.registerService(port, contextPath);
            }
            if (rootDir != null) {
                this.addContext(handlers, rootDir, "/");
                this.registerService(port, "/");
            }
        }
        this.m_server.setHandler((Handler)handlers);
        this.m_server.setStopAtShutdown(true);
    }

    protected void addContext(HandlerCollection handlers, File name, String contextPath) {
        this.log().warn("adding context: " + contextPath + " -> " + name.getAbsolutePath());
        WebAppContext wac = new WebAppContext();
        wac.setWar(name.getAbsolutePath());
        wac.setContextPath(contextPath);
        handlers.addHandler((Handler)wac);
    }

    protected void registerService(Integer port, String contextPath) {
        String contextName = contextPath.replace("/", "");
        try {
            ServiceRegistrationStrategy srs = ServiceRegistrationFactory.getStrategy();
            String host = InetAddress.getLocalHost().getHostName().replace(".local", "").replace(".", "-");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("path", contextPath);
            srs.initialize("HTTP", contextName + "-" + host, port.intValue(), properties);
            this.services.put(contextName, srs);
        }
        catch (Throwable e) {
            this.log().warn("unable to get a DNS-SD object for context '" + contextPath + "'", e);
        }
    }

    protected void excludeCipherSuites(SslSocketConnector sslConnector) {
        String[] exclSuites;
        String[] defaultExclSuites = new String[]{"SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA"};
        String exclSuitesString = System.getProperty("org.opennms.netmgt.jetty.https-exclude-cipher-suites");
        if (exclSuitesString == null) {
            this.log().warn("No excluded SSL/TLS cipher suites specified, using hard-coded defaults");
            exclSuites = defaultExclSuites;
        } else {
            exclSuites = exclSuitesString.split("\\s*:\\s*");
            this.log().warn("Excluding " + exclSuites.length + " user-specified SSL/TLS cipher suites");
        }
        sslConnector.setExcludeCipherSuites(exclSuites);
        for (String suite : exclSuites) {
            this.log().info("Excluded SSL/TLS cipher suite " + suite + " for connector on port " + sslConnector.getPort());
        }
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Throwable e) {
            this.log().error("Error starting Jetty Server", e);
        }
        for (String key : this.services.keySet()) {
            ServiceRegistrationStrategy srs = this.services.get(key);
            if (srs == null) continue;
            try {
                srs.register();
            }
            catch (Throwable e) {
                this.log().warn("unable to register a DNS-SD object for context '" + key + "'", e);
            }
        }
    }

    protected void onStop() {
        for (String key : this.services.keySet()) {
            ServiceRegistrationStrategy srs = this.services.get(key);
            if (srs == null) continue;
            try {
                srs.unregister();
            }
            catch (Throwable e) {
                this.log().warn("unable to unregister a DNS-SD object for context '" + key + "'", e);
            }
        }
        try {
            this.m_server.stop();
        }
        catch (Throwable e) {
            this.log().error("Error stopping Jetty Server", e);
        }
    }
}

