/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.start.Monitor;

public class JettyLauncher {
    private static final int STOP_PORT = 8981;
    private static final String STOP_KEY = "b7f3609ab1dd8c7e5bac070bca9ba0d5";

    public static void usage() {
        System.out.println("To launch a WAR file on port 8980:");
        System.out.println("  org.opennms.netmgt.jetty.JettyLauncher <war_file_path>");
        System.out.println("To check the status of the Jetty process:");
        System.out.println("  org.opennms.netmgt.jetty.JettyLauncher STATUS");
        System.out.println("To stop the Jetty process:");
        System.out.println("  org.opennms.netmgt.jetty.JettyLauncher STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("ERROR: Incorrect number of arguments.");
            JettyLauncher.usage();
            System.exit(1);
        }
        if ("STOP".equals(args[0])) {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), 8981);
            OutputStream out = s.getOutputStream();
            out.write("b7f3609ab1dd8c7e5bac070bca9ba0d5\r\n".getBytes("ASCII"));
            out.write("stop\r\n".getBytes("ASCII"));
            out.flush();
            s.close();
        } else if ("STATUS".equals(args[0])) {
            Socket s = null;
            Object statusResponse = null;
            try {
                s = new Socket(InetAddress.getByName("127.0.0.1"), 8981);
                OutputStream out = s.getOutputStream();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(s.getInputStream(), "ASCII"));
                out.write("b7f3609ab1dd8c7e5bac070bca9ba0d5\r\n".getBytes("ASCII"));
                out.write("status\r\n".getBytes("ASCII"));
                out.flush();
                if ("OK".equals(reader.readLine())) {
                    System.exit(0);
                }
                System.exit(1);
            }
            catch (Throwable e) {
                System.exit(1);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        } else {
            Server server = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(8980);
            server.addConnector((Connector)connector);
            WebAppContext handler = new WebAppContext(args[0], "/");
            server.addHandler((Handler)handler);
            server.start();
            System.setProperty("STOP.PORT", String.valueOf(8981));
            System.setProperty("STOP.KEY", STOP_KEY);
            Monitor.monitor();
        }
    }
}

