/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.util.Properties;
import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;

public class JettyServer
extends AbstractServiceDaemon {
    int m_port = 8080;
    private Server m_server;

    protected JettyServer() {
        super("OpenNMS.JettyServer");
    }

    protected void onInit() {
        Integer https_port;
        Integer requestHeaderSize;
        Properties p = System.getProperties();
        File homeDir = new File(p.getProperty("opennms.home"));
        File webappsDir = new File(homeDir, "jetty-webapps");
        this.m_server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        Integer port = Integer.getInteger("org.opennms.netmgt.jetty.port", this.m_port);
        connector.setPort(port.intValue());
        String host = System.getProperty("org.opennms.netmgt.jetty.host");
        if (host != null) {
            connector.setHost(host);
        }
        if ((requestHeaderSize = Integer.getInteger("org.opennms.netmgt.jetty.requestHeaderSize")) != null) {
            connector.setRequestHeaderSize(requestHeaderSize.intValue());
        }
        this.m_server.addConnector((Connector)connector);
        Integer ajp_port = Integer.getInteger("org.opennms.netmgt.jetty.ajp-port");
        if (ajp_port != null) {
            Ajp13SocketConnector ajpConnector = new Ajp13SocketConnector();
            ajpConnector.setPort(ajp_port.intValue());
            ajpConnector.setRequestHeaderSize(8096);
            this.m_server.addConnector((Connector)ajpConnector);
        }
        if ((https_port = Integer.getInteger("org.opennms.netmgt.jetty.https-port")) != null) {
            String keyStorePath = System.getProperty("org.opennms.netmgt.jetty.https-keystore", homeDir + File.separator + "etc" + File.separator + "examples" + File.separator + "jetty.keystore");
            String keyStorePassword = System.getProperty("org.opennms.netmgt.jetty.https-keystorepassword", "changeit");
            String keyManagerPassword = System.getProperty("org.opennms.netmgt.jetty.https-keypassword", "changeit");
            String certificateAlias = System.getProperty("org.opennms.netmgt.jetty.https-cert-alias", null);
            SslContextFactory contextFactory = new SslContextFactory(keyStorePath);
            contextFactory.setKeyStorePassword(keyStorePassword);
            contextFactory.setKeyManagerPassword(keyManagerPassword);
            if (certificateAlias != null && !"".equals(certificateAlias.trim())) {
                contextFactory.setCertAlias(certificateAlias);
            }
            this.excludeCipherSuites(contextFactory, https_port);
            SslSocketConnector sslConnector = new SslSocketConnector(contextFactory);
            sslConnector.setPort(https_port.intValue());
            String httpsHost = System.getProperty("org.opennms.netmgt.jetty.https-host");
            if (httpsHost != null) {
                sslConnector.setHost(httpsHost);
            }
            this.m_server.addConnector((Connector)sslConnector);
        }
        HandlerCollection handlers = new HandlerCollection();
        if (webappsDir.exists()) {
            File rootDir = null;
            for (File file : webappsDir.listFiles()) {
                if (!file.isDirectory()) continue;
                if ("ROOT".equals(file.getName())) {
                    rootDir = file;
                    continue;
                }
                String contextPath = "/" + file.getName();
                this.addContext(handlers, file, contextPath);
            }
            if (rootDir != null) {
                this.addContext(handlers, rootDir, "/");
            }
        }
        this.m_server.setHandler((Handler)handlers);
        this.m_server.setStopAtShutdown(true);
    }

    protected void addContext(HandlerCollection handlers, File name, String contextPath) {
        this.log().warn("adding context: " + contextPath + " -> " + name.getAbsolutePath());
        WebAppContext wac = new WebAppContext();
        wac.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*\\.jar$");
        wac.setWar(name.getAbsolutePath());
        wac.setContextPath(contextPath);
        handlers.addHandler((Handler)wac);
    }

    protected void excludeCipherSuites(SslContextFactory contextFactory, Integer port) {
        String[] exclSuites;
        String[] defaultExclSuites = new String[]{"SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA"};
        String exclSuitesString = System.getProperty("org.opennms.netmgt.jetty.https-exclude-cipher-suites");
        if (exclSuitesString == null) {
            this.log().warn("No excluded SSL/TLS cipher suites specified, using hard-coded defaults");
            exclSuites = defaultExclSuites;
        } else {
            exclSuites = exclSuitesString.split("\\s*:\\s*");
            this.log().warn("Excluding " + exclSuites.length + " user-specified SSL/TLS cipher suites");
        }
        contextFactory.setExcludeCipherSuites(exclSuites);
        for (String suite : exclSuites) {
            this.log().info("Excluded SSL/TLS cipher suite " + suite + " for connector on port " + port);
        }
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Throwable e) {
            this.log().error("Error starting Jetty Server", e);
        }
    }

    protected void onStop() {
        try {
            this.m_server.stop();
        }
        catch (Throwable e) {
            this.log().error("Error stopping Jetty Server", e);
        }
    }
}

