/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;
import org.opennms.javamail.JavaMailer2;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.common.JavamailProperty;
import org.opennms.netmgt.config.common.ReadmailConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReadMailer
extends JavaMailer2 {
    private List<Message> m_messages;
    private final ReadmailConfig m_config;
    private Session m_session;
    private Boolean m_deleteOnClose = false;

    protected void finalize() throws Throwable {
        if (this.m_messages != null && !this.m_messages.isEmpty() && this.m_messages.get(0).getFolder() != null && this.m_messages.get(0).getFolder().isOpen()) {
            this.m_messages.get(0).getFolder().close(this.m_deleteOnClose.booleanValue());
        }
        super.finalize();
    }

    public JavaReadMailer(ReadmailConfig config, Boolean closeOnDelete) throws JavaMailerException {
        if (closeOnDelete != null) {
            this.m_deleteOnClose = closeOnDelete;
        }
        this.m_config = config;
        this.m_session = Session.getInstance((Properties)this.configureProperties(), (Authenticator)this.createAuthenticator(config.getUserAuth().getUserName(), config.getUserAuth().getPassword()));
    }

    public List<Message> retrieveMessages() throws JavaMailerException {
        Message[] msgs;
        Folder mailFolder = null;
        try {
            Store store = this.m_session.getStore(this.m_config.getReadmailHost().getReadmailProtocol().getTransport());
            store.connect(this.m_config.getReadmailHost().getHost(), (int)this.m_config.getReadmailHost().getPort(), this.m_config.getUserAuth().getUserName(), this.m_config.getUserAuth().getPassword());
            mailFolder = store.getFolder(this.m_config.getMailFolder());
            mailFolder.open(2);
            msgs = mailFolder.getMessages();
        }
        catch (NoSuchProviderException e) {
            throw new JavaMailerException("No provider matching:" + this.m_config.getReadmailHost().getReadmailProtocol().getTransport() + " from config:" + this.m_config.getName(), e);
        }
        catch (MessagingException e) {
            throw new JavaMailerException("Problem reading messages from configured mail store", e);
        }
        return new ArrayList<Message>(Arrays.asList(msgs));
    }

    public List<Message> retrieveMessages(SearchTerm term) throws JavaMailerException {
        Message[] msgs;
        Folder mailFolder = null;
        try {
            Store store = this.m_session.getStore(this.m_config.getReadmailHost().getReadmailProtocol().getTransport());
            store.connect(this.m_config.getReadmailHost().getHost(), (int)this.m_config.getReadmailHost().getPort(), this.m_config.getUserAuth().getUserName(), this.m_config.getUserAuth().getPassword());
            mailFolder = store.getFolder(this.m_config.getMailFolder());
            mailFolder.open(2);
            msgs = mailFolder.search(term);
        }
        catch (NoSuchProviderException e) {
            throw new JavaMailerException("No provider matching:" + this.m_config.getReadmailHost().getReadmailProtocol().getTransport() + " from config:" + this.m_config.getName(), e);
        }
        catch (MessagingException e) {
            throw new JavaMailerException("Problem reading messages from configured mail store", e);
        }
        List<Message> msgList = Arrays.asList(msgs);
        return msgList;
    }

    private Properties configureProperties() {
        Properties props = new Properties();
        props.setProperty("mail.debug", String.valueOf(this.m_config.isDebug()));
        List jmps = this.m_config.getJavamailPropertyCollection();
        for (JavamailProperty jmp : jmps) {
            props.setProperty(jmp.getName(), jmp.getValue());
        }
        String protocol = this.m_config.getReadmailHost().getReadmailProtocol().getTransport();
        props.put("mail." + protocol + ".host", this.m_config.getReadmailHost().getHost());
        props.put("mail." + protocol + ".user", this.m_config.getUserAuth().getUserName());
        props.put("mail." + protocol + ".port", (Object)this.m_config.getReadmailHost().getPort());
        props.put("mail." + protocol + ".starttls.enable", (Object)this.m_config.getReadmailHost().getReadmailProtocol().isStartTls());
        props.put("mail.smtp.auth", "true");
        if (this.m_config.getReadmailHost().getReadmailProtocol().isSslEnable()) {
            props.put("mail." + protocol + ".socketFactory.port", (Object)this.m_config.getReadmailHost().getPort());
            props.put("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail." + protocol + ".socketFactory.fallback", "false");
        }
        props.put("mail." + protocol + ".connectiontimeout", (Object)3000);
        props.put("mail." + protocol + ".timeout", (Object)3000);
        props.put("mail.store.protocol", protocol);
        return props;
    }

    public List<Message> getMessages() {
        return this.m_messages;
    }

    public static List<String> getText(Message msg) throws MessagingException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String content = null;
        if (msg.isMimeType("text/*")) {
            block4: {
                try {
                    content = (String)msg.getContent();
                }
                catch (ClassCastException cce) {
                    Object c = msg.getContent();
                    if (!(c instanceof MimeMultipart)) break block4;
                    for (int cnt = 0; cnt < ((MimeMultipart)c).getCount(); ++cnt) {
                        BodyPart bp = ((MimeMultipart)c).getBodyPart(cnt);
                        if (!bp.isMimeType("text/*")) continue;
                        content = (String)bp.getContent();
                        break;
                    }
                }
            }
            return JavaReadMailer.string2Lines(content);
        }
        return lines;
    }

    public Boolean isDeleteOnClose() {
        return this.m_deleteOnClose;
    }

    public void setDeleteOnClose(Boolean deleteOnClose) {
        this.m_deleteOnClose = deleteOnClose;
    }

    public static List<String> string2Lines(String text) {
        if (text == null) {
            return null;
        }
        String[] linea = StringUtils.split((String)text, (String)"\n");
        for (int i = 0; i < linea.length; ++i) {
            linea[i] = StringUtils.chomp((String)linea[i]);
        }
        return Arrays.asList(linea);
    }
}

