/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.opennms.core.xml.EmptyNamespacePrefixMapper;
import org.opennms.core.xml.MarshallingExceptionTranslator;
import org.opennms.core.xml.SimpleNamespaceFilter;
import org.opennms.core.xml.ValidateUsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class JaxbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbUtils.class);
    private static final Class<?>[] EMPTY_CLASS_LIST = new Class[0];
    private static final Source[] EMPTY_SOURCE_LIST = new Source[0];
    private static final MarshallingExceptionTranslator EXCEPTION_TRANSLATOR = new MarshallingExceptionTranslator();
    private static ThreadLocal<Map<Class<?>, Marshaller>> m_marshallers = new ThreadLocal();
    private static ThreadLocal<Map<Class<?>, Unmarshaller>> m_unMarshallers = new ThreadLocal();
    private static final Map<Class<?>, JAXBContext> m_contexts = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Schema> m_schemas = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<String, Class<?>> m_elementClasses = Collections.synchronizedMap(new WeakHashMap());
    private static final boolean VALIDATE_IF_POSSIBLE = true;

    private JaxbUtils() {
    }

    public static String marshal(Object obj) {
        StringWriter jaxbWriter = new StringWriter();
        JaxbUtils.marshal(obj, jaxbWriter);
        return jaxbWriter.toString();
    }

    public static void marshal(Object obj, File file) throws IOException {
        String xmlString = JaxbUtils.marshal(obj);
        if (xmlString != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            fileWriter.write(xmlString);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    public static Class<?> getClassForElement(String elementName) {
        if (elementName == null) {
            return null;
        }
        Class<?> existing = m_elementClasses.get(elementName);
        if (existing != null) {
            return existing;
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter(new AnnotationTypeFilter(XmlRootElement.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("org.opennms")) {
            String className = bd.getBeanClassName();
            try {
                Class<?> clazz = Class.forName(className);
                XmlRootElement annotation = clazz.getAnnotation(XmlRootElement.class);
                if (annotation == null) {
                    LOG.warn("Somehow found class {} but it has no @XmlRootElement annotation! Skipping.", (Object)className);
                    continue;
                }
                if (!elementName.equalsIgnoreCase(annotation.name())) continue;
                LOG.trace("Found class {} for element name {}", (Object)className, (Object)elementName);
                m_elementClasses.put(elementName, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unable to get class object from class name {}. Skipping.", (Object)className, (Object)e);
            }
        }
        return null;
    }

    public static <T> List<String> getNamespacesForClass(Class<T> clazz) {
        ArrayList<String> namespaces = new ArrayList<String>();
        XmlSeeAlso seeAlso = clazz.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null) {
            for (Class c : seeAlso.value()) {
                namespaces.addAll(JaxbUtils.getNamespacesForClass(c));
            }
        }
        return namespaces;
    }

    public static void marshal(Object obj, Writer writer) {
        Marshaller jaxbMarshaller = JaxbUtils.getMarshallerFor(obj, null);
        try {
            jaxbMarshaller.marshal(obj, writer);
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("marshalling " + obj.getClass().getSimpleName(), (Exception)((Object)e));
        }
        catch (FactoryConfigurationError e) {
            throw EXCEPTION_TRANSLATOR.translate("marshalling " + obj.getClass().getSimpleName(), e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, File file) {
        return JaxbUtils.unmarshal(clazz, file, true);
    }

    public static <T> T unmarshal(Class<T> clazz, File file, boolean validate) {
        T t;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            t = JaxbUtils.unmarshal(clazz, new InputSource(reader), null, validate);
        }
        catch (FileNotFoundException e) {
            try {
                throw EXCEPTION_TRANSLATOR.translate("reading " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return t;
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) {
        return JaxbUtils.unmarshal(clazz, reader, true);
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader, boolean validate) {
        return JaxbUtils.unmarshal(clazz, new InputSource(reader), null, validate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(Class<T> clazz, InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            T t = JaxbUtils.unmarshal(clazz, reader, true);
            return t;
        }
        catch (IOException e) {
            throw EXCEPTION_TRANSLATOR.translate("reading stream", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(Class<T> clazz, InputStream stream, boolean validate) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            T t = JaxbUtils.unmarshal(clazz, new InputSource(reader), null, validate);
            return t;
        }
        catch (IOException e) {
            throw EXCEPTION_TRANSLATOR.translate("reading stream", e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, String xml) {
        return JaxbUtils.unmarshal(clazz, xml, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(Class<T> clazz, String xml, boolean validate) {
        StringReader sr = new StringReader(xml);
        InputSource is = new InputSource(sr);
        try {
            T t = JaxbUtils.unmarshal(clazz, is, null, validate);
            return t;
        }
        finally {
            IOUtils.closeQuietly((Reader)sr);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, Resource resource) {
        return JaxbUtils.unmarshal(clazz, resource, true);
    }

    public static <T> T unmarshal(Class<T> clazz, Resource resource, boolean validate) {
        try {
            return JaxbUtils.unmarshal(clazz, new InputSource(resource.getInputStream()), null, validate);
        }
        catch (IOException e) {
            throw EXCEPTION_TRANSLATOR.translate("getting a configuration resource from spring", e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource) {
        return JaxbUtils.unmarshal(clazz, inputSource, true);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, boolean validate) {
        return JaxbUtils.unmarshal(clazz, inputSource, null, validate);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, JAXBContext jaxbContext) {
        return JaxbUtils.unmarshal(clazz, inputSource, jaxbContext, true);
    }

    public static <T> T unmarshal(Class<T> clazz, InputSource inputSource, JAXBContext jaxbContext, boolean validate) {
        Unmarshaller um = JaxbUtils.getUnmarshallerFor(clazz, jaxbContext, validate);
        LOG.trace("unmarshalling class {} from input source {} with unmarshaller {}", clazz.getSimpleName(), inputSource, um);
        try {
            XMLFilter filter = JaxbUtils.getXMLFilterForClass(clazz);
            SAXSource source = new SAXSource(filter, inputSource);
            um.setEventHandler((ValidationEventHandler)new LoggingValidationEventHandler());
            JAXBElement element = um.unmarshal((Source)source, clazz);
            return (T)element.getValue();
        }
        catch (SAXException e) {
            throw EXCEPTION_TRANSLATOR.translate("creating an XML reader object", e);
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("unmarshalling an object (" + clazz.getSimpleName() + ")", (Exception)((Object)e));
        }
    }

    public static <T> String getNamespaceForClass(Class<T> clazz) {
        String namespace;
        XmlSchema schema = clazz.getPackage().getAnnotation(XmlSchema.class);
        if (schema != null && (namespace = schema.namespace()) != null && !"".equals(namespace)) {
            return namespace;
        }
        return null;
    }

    public static <T> XMLFilter getXMLFilterForClass(Class<T> clazz) throws SAXException {
        String namespace = JaxbUtils.getNamespaceForClass(clazz);
        SimpleNamespaceFilter filter = namespace == null ? new SimpleNamespaceFilter("", false) : new SimpleNamespaceFilter(namespace, true);
        LOG.trace("namespace filter for class {}: {}", (Object)clazz, (Object)filter);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        filter.setParent(xmlReader);
        return filter;
    }

    public static Marshaller getMarshallerFor(Object obj, JAXBContext jaxbContext) {
        Class<?> clazz = obj instanceof Class ? obj : obj.getClass();
        Map<Class<?>, Marshaller> marshallers = m_marshallers.get();
        if (jaxbContext == null) {
            if (marshallers == null) {
                marshallers = new WeakHashMap();
                m_marshallers.set(marshallers);
            }
            if (marshallers.containsKey(clazz)) {
                LOG.trace("found unmarshaller for {}", (Object)clazz);
                return marshallers.get(clazz);
            }
        }
        LOG.trace("creating unmarshaller for {}", (Object)clazz);
        try {
            JAXBContext context = jaxbContext == null ? JaxbUtils.getContextFor(clazz) : jaxbContext;
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            if (context.getClass().getName().startsWith("org.eclipse.persistence.jaxb")) {
                marshaller.setProperty("eclipselink.namespace-prefix-mapper", (Object)new EmptyNamespacePrefixMapper());
                marshaller.setProperty("eclipselink.json.marshal-empty-collections", (Object)true);
            }
            Schema schema = JaxbUtils.getValidatorFor(clazz);
            marshaller.setSchema(schema);
            if (jaxbContext == null) {
                marshallers.put(clazz, marshaller);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw EXCEPTION_TRANSLATOR.translate("creating XML marshaller", (Exception)((Object)e));
        }
    }

    public static Unmarshaller getUnmarshallerFor(Object obj, JAXBContext jaxbContext, boolean validate) {
        Class<?> clazz = obj instanceof Class ? obj : obj.getClass();
        Unmarshaller unmarshaller = null;
        Map<Class<?>, Unmarshaller> unmarshallers = m_unMarshallers.get();
        if (jaxbContext == null) {
            if (unmarshallers == null) {
                unmarshallers = new WeakHashMap();
                m_unMarshallers.set(unmarshallers);
            }
            if (unmarshallers.containsKey(clazz)) {
                LOG.trace("found unmarshaller for {}", (Object)clazz);
                unmarshaller = unmarshallers.get(clazz);
            }
        }
        if (unmarshaller == null) {
            try {
                unmarshaller = jaxbContext == null ? JaxbUtils.getContextFor(clazz).createUnmarshaller() : jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw EXCEPTION_TRANSLATOR.translate("creating XML marshaller", (Exception)((Object)e));
            }
        }
        LOG.trace("created unmarshaller for {}", (Object)clazz);
        if (validate) {
            Schema schema = JaxbUtils.getValidatorFor(clazz);
            if (schema == null) {
                LOG.trace("Validation is enabled, but no XSD found for class {}", (Object)clazz.getSimpleName());
            }
            unmarshaller.setSchema(schema);
        }
        if (jaxbContext == null) {
            unmarshallers.put(clazz, unmarshaller);
        }
        return unmarshaller;
    }

    private static Collection<Class<?>> getAllRelatedClasses(Class<?> clazz) {
        HashSet classes = new HashSet();
        classes.add(clazz);
        XmlSeeAlso seeAlso = clazz.getAnnotation(XmlSeeAlso.class);
        if (seeAlso != null && seeAlso.value() != null) {
            for (Class c : seeAlso.value()) {
                classes.addAll(JaxbUtils.getAllRelatedClasses(c));
            }
        }
        LOG.trace("getAllRelatedClasses({}): {}", (Object)clazz, (Object)classes);
        return classes;
    }

    public static JAXBContext getContextFor(Class<?> clazz) throws JAXBException {
        JAXBContext context;
        LOG.trace("Getting context for class {}", (Object)clazz);
        if (m_contexts.containsKey(clazz)) {
            context = m_contexts.get(clazz);
        } else {
            Collection<Class<?>> allRelatedClasses = JaxbUtils.getAllRelatedClasses(clazz);
            LOG.trace("Creating new context for classes: {}", (Object)allRelatedClasses);
            context = JAXBContextFactory.createContext(allRelatedClasses.toArray(EMPTY_CLASS_LIST), null);
            LOG.trace("Context for {}: {}", (Object)allRelatedClasses, (Object)context);
            m_contexts.put(clazz, context);
        }
        return context;
    }

    private static List<String> getSchemaFilesFor(Class<?> clazz) {
        ArrayList<String> schemaFiles = new ArrayList<String>();
        for (Class<?> c : JaxbUtils.getAllRelatedClasses(clazz)) {
            ValidateUsing annotation = c.getAnnotation(ValidateUsing.class);
            if (annotation == null || annotation.value() == null) {
                LOG.debug("@ValidateUsing is missing from class {}", (Object)c);
                continue;
            }
            schemaFiles.add(annotation.value());
        }
        return schemaFiles;
    }

    private static Schema getValidatorFor(Class<?> clazz) {
        LOG.trace("finding XSD for class {}", (Object)clazz);
        if (m_schemas.containsKey(clazz)) {
            return m_schemas.get(clazz);
        }
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        for (String schemaFileName : JaxbUtils.getSchemaFilesFor(clazz)) {
            InputStream schemaInputStream = null;
            try {
                File schemaFile;
                if (schemaInputStream == null && (schemaFile = new File(System.getProperty("opennms.home") + "/share/xsds/" + schemaFileName)).exists()) {
                    LOG.trace("Found schema file {} related to {}", (Object)schemaFile, (Object)clazz);
                    schemaInputStream = new FileInputStream(schemaFile);
                }
                if (schemaInputStream == null && (schemaFile = new File("target/xsds/" + schemaFileName)).exists()) {
                    LOG.trace("Found schema file {} related to {}", (Object)schemaFile, (Object)clazz);
                    schemaInputStream = new FileInputStream(schemaFile);
                }
                if (schemaInputStream == null) {
                    URL schemaResource = Thread.currentThread().getContextClassLoader().getResource("xsds/" + schemaFileName);
                    if (schemaResource == null) {
                        schemaResource = clazz.getClassLoader().getResource("xsds/" + schemaFileName);
                    }
                    if (schemaResource == null) {
                        LOG.debug("Unable to load resource xsds/{} from the classpath.", (Object)schemaFileName);
                    } else {
                        LOG.trace("Found schema resource {} related to {}", (Object)schemaResource, (Object)clazz);
                        schemaInputStream = schemaResource.openStream();
                    }
                }
                if (schemaInputStream == null) {
                    LOG.trace("Did not find a suitable XSD.  Skipping.");
                    continue;
                }
                sources.add(new StreamSource(schemaInputStream));
            }
            catch (Throwable t) {
                LOG.warn("an error occurred while attempting to load {} for validation", (Object)schemaFileName);
            }
        }
        if (sources.size() == 0) {
            LOG.debug("No schema files found for validating {}", (Object)clazz);
            return null;
        }
        LOG.trace("Schema sources: {}", (Object)sources);
        try {
            Schema schema = factory.newSchema(sources.toArray(EMPTY_SOURCE_LIST));
            m_schemas.put(clazz, schema);
            return schema;
        }
        catch (SAXException e) {
            LOG.warn("an error occurred while attempting to load schema validation files for class {}", (Object)clazz, (Object)e);
            return null;
        }
    }

    public static <T> T duplicateObject(T obj, Class<T> clazz) {
        return JaxbUtils.unmarshal(clazz, JaxbUtils.marshal(obj));
    }

    protected static final class LoggingValidationEventHandler
    implements ValidationEventHandler {
        protected LoggingValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            LOG.trace("event = {}", (Object)event, (Object)event.getLinkedException());
            return false;
        }
    }
}

