/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.rt;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ticketer.rt.DefaultRtConfigDao;

public class RtTicketerPlugin
implements Plugin {
    private DefaultRtConfigDao m_configDao = new DefaultRtConfigDao();
    private String m_user = this.m_configDao.getUserName();
    private String m_password = this.m_configDao.getPassword();
    private static final String TAG_REGEX = "<[^>]*>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket get(String ticketId) throws PluginException {
        boolean ticketFound = false;
        Ticket ticket = null;
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        if (ticketId == null) {
            this.log().error("No RT ticketID available in OpenNMS Ticket");
            throw new PluginException("No RT ticketID available in OpenNMS Ticket");
        }
        HttpPost post = new HttpPost(this.m_configDao.getBaseURL() + "/REST/1.0/ticket/" + ticketId);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("user", this.m_user));
        params.add(new BasicNameValuePair("pass", this.m_password));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new PluginException("Received a non 200 response code from the server");
            }
            String in = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log().debug(in);
            Pattern inTokensPattern = Pattern.compile("^(\\w+):\\s(.*)$", 8);
            Matcher matcher = inTokensPattern.matcher(in);
            while (matcher.find()) {
                ticketFound = true;
                ticketAttributes.put(matcher.group(1), matcher.group(2));
            }
        }
        catch (IOException e) {
            this.log().error("HTTP exception attempting to logon to RT: " + e.getMessage(), (Throwable)e);
        }
        if (!ticketFound) {
            throw new PluginException("could not find ticket in RT for Ticket: " + ticketId);
        }
        ticket = new Ticket();
        ticket.setState(this.rtToOpenNMSState((String)ticketAttributes.get("Status")));
        ticket.setId(ticketId);
        ticket.setUser((String)ticketAttributes.get("Requestors"));
        ticket.setSummary((String)ticketAttributes.get("Subject"));
        return ticket;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        Ticket currentTicket = null;
        try {
            if (newTicket.getId() == null) {
                this.log().debug("TicketId is null creating a new ticket");
                String newTicketID = this.newRtTicket(newTicket);
                newTicket.setId(newTicketID);
                this.log().debug("created new ticket: " + newTicket.getId());
            } else {
                currentTicket = this.get(newTicket.getId());
                this.log().debug("updating existing ticket : " + currentTicket.getId());
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateRtStatus(newTicket);
                }
            }
        }
        catch (PluginException e) {
            this.log().error("Failed to create or update RT ticket" + (Object)((Object)e));
            throw new PluginException("Failed to create or update RT ticket");
        }
    }

    private void updateRtStatus(Ticket ticket) throws PluginException {
        HttpPost post = new HttpPost(this.m_configDao.getBaseURL() + "/REST/1.0/ticket/" + ticket.getId() + "/edit");
        String updateString = new String("Status: " + this.openNMSToRTState(ticket.getState()));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("content", updateString));
        params.add(new BasicNameValuePair("user", this.m_user));
        params.add(new BasicNameValuePair("pass", this.m_password));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new PluginException("Received a non 200 response code from the server");
            }
            String in = EntityUtils.toString((HttpEntity)post.getEntity());
            Pattern okPattern = Pattern.compile("(?s) Ticket (\\d+) updated");
            Matcher matcher = okPattern.matcher(in);
            if (!matcher.find()) {
                throw new PluginException("Did not receive confirmation from RT that ticket was updated");
            }
        }
        catch (IOException e) {
            this.log().error("HTTP exception attempting to logon to RT: " + e.getMessage());
            throw new PluginException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newRtTicket(Ticket newTicket) throws PluginException {
        String rtTicketNumber = null;
        Pattern tagPattern = Pattern.compile(TAG_REGEX);
        Matcher tagMatcher = tagPattern.matcher(newTicket.getDetails());
        String rtTicketText = tagMatcher.replaceAll("");
        StringBuilder contentBuilder = new StringBuilder("id: ticket/new\n");
        contentBuilder.append("Queue: " + this.m_configDao.getQueue() + "\n");
        contentBuilder.append("Requestor: " + this.m_configDao.getRequestor() + "\n");
        contentBuilder.append("Subject: " + newTicket.getSummary() + "\n");
        contentBuilder.append("text: " + rtTicketText + "\n");
        HttpPost post = new HttpPost(this.m_configDao.getBaseURL() + "/REST/1.0/edit");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("content", contentBuilder.toString()));
        params.add(new BasicNameValuePair("user", this.m_user));
        params.add(new BasicNameValuePair("pass", this.m_password));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            HttpResponse response = this.getClient().execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new PluginException("Received a non 200 response code from the server");
            }
            String in = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log().debug(in);
            Pattern okPattern = Pattern.compile("(?s) Ticket (\\d+) created");
            Matcher matcher = okPattern.matcher(in);
            if (!matcher.find()) {
                throw new PluginException("Did not receive confirmation that ticket was updated");
            }
            rtTicketNumber = matcher.group(1);
        }
        catch (IOException e) {
            this.log().error("IO exception attempting to logon to RT: " + e.getMessage(), (Throwable)e);
        }
        if (rtTicketNumber == null) {
            throw new PluginException("Received no ticket number from RT");
        }
        return rtTicketNumber;
    }

    private String openNMSToRTState(Ticket.State state) {
        String rtStatus;
        this.log().debug("getting RT status from OpenNMS State " + state.toString());
        switch (state) {
            case OPEN: {
                rtStatus = this.m_configDao.getOpenStatus();
                this.log().debug("OpenNMS Status OPEN matched rt status " + rtStatus);
                break;
            }
            case CANCELLED: {
                rtStatus = this.m_configDao.getCancelledStatus();
                this.log().debug("OpenNMS Status CANCELLED matched rt status " + rtStatus);
                break;
            }
            case CLOSED: {
                rtStatus = this.m_configDao.getClosedStatus();
                this.log().debug("OpenNMS Status CLOSED matched rt status " + rtStatus);
                break;
            }
            default: {
                this.log().debug("No valid OpenNMS state on ticket");
                rtStatus = this.m_configDao.getOpenStatus();
            }
        }
        this.log().debug("OpenNMS state was        " + state.toString());
        this.log().debug("setting RT status to " + rtStatus);
        return rtStatus;
    }

    private Ticket.State rtToOpenNMSState(String rtStatus) {
        Ticket.State openNMSState;
        if (this.m_configDao.getValidOpenStatus().contains(rtStatus)) {
            this.log().debug("RT status " + rtStatus + " matched OpenNMS state Open");
            openNMSState = Ticket.State.OPEN;
        } else if (this.m_configDao.getValidClosedStatus().contains(rtStatus)) {
            this.log().debug("RT status " + rtStatus + " matched OpenNMS state Closed");
            openNMSState = Ticket.State.CLOSED;
        } else if (this.m_configDao.getValidCancelledStatus().contains(rtStatus)) {
            this.log().debug("RT status " + rtStatus + " matched OpenNMS state Cancelled");
            openNMSState = Ticket.State.CANCELLED;
        } else {
            this.log().debug("RT status " + rtStatus + " has no matching OpenNMS state");
            openNMSState = Ticket.State.OPEN;
        }
        return openNMSState;
    }

    ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private HttpClient getClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpParams clientParams = client.getParams();
        clientParams.setIntParameter("http.connection.timeout", this.m_configDao.getTimeout());
        clientParams.setIntParameter("http.socket.timeout", this.m_configDao.getTimeout());
        clientParams.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        client.setParams(clientParams);
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.m_configDao.getRetry(), false));
        return client;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }
}

