/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.rt;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRtConfigDao {
    private Configuration getProperties() {
        String propsFile = new String(System.getProperty("opennms.home") + "/etc/rt.properties");
        this.log().debug("loading properties from: " + propsFile);
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(propsFile);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return config;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getUserName() {
        return this.getProperties().getString("rt.username");
    }

    String getPassword() {
        return this.getProperties().getString("rt.password");
    }

    String getQueue() {
        return this.getProperties().getString("rt.queue", "General");
    }

    List<String> getValidClosedStatus() {
        return this.getProperties().getList("rt.validclosedstatus");
    }

    List<Integer> getValidOpenStatus() {
        return this.getProperties().getList("rt.validopenstatus");
    }

    List<String> getValidCancelledStatus() {
        return this.getProperties().getList("rt.validcancelledstatus");
    }

    String getOpenStatus() {
        return this.getProperties().getString("rt.openstatus", "open");
    }

    String getClosedStatus() {
        return this.getProperties().getString("rt.closedstatus", "closed");
    }

    String getCancelledStatus() {
        return this.getProperties().getString("rt.cancelledstatus", "cancelled");
    }

    String getRequestor() {
        return this.getProperties().getString("rt.requestor");
    }

    String getBaseURL() {
        return this.getProperties().getString("rt.baseURL");
    }

    int getTimeout() {
        return this.getProperties().getInt("rt.timeout", 3000);
    }

    int getRetry() {
        return this.getProperties().getInt("rt.retry", 0);
    }
}

