/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.rt;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Category;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ticketer.rt.DefaultRtConfigDao;

public class RtTicketerPlugin
implements Plugin {
    private DefaultRtConfigDao m_configDao = new DefaultRtConfigDao();
    private String m_user = this.m_configDao.getUserName();
    private String m_password = this.m_configDao.getPassword();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket get(String ticketId) throws PluginException {
        boolean ticketFound = false;
        Ticket ticket = null;
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        if (ticketId == null) {
            this.log().error((Object)"No RT ticketID available in OpenNMS Ticket");
            throw new PluginException("No RT ticketID available in OpenNMS Ticket");
        }
        PostMethod post = new PostMethod(this.m_configDao.getBaseURL() + "/REST/1.0/ticket/" + ticketId);
        NameValuePair[] ticketGetParams = new NameValuePair[]{new NameValuePair("user", this.m_user), new NameValuePair("pass", this.m_password)};
        post.setRequestBody(ticketGetParams);
        try {
            if (this.getClient().executeMethod((HttpMethod)post) != 200) {
                throw new PluginException("Received a non 200 response code from the server");
            }
            String in = post.getResponseBodyAsString();
            this.log().debug((Object)in);
            Pattern inTokensPattern = Pattern.compile("^(\\w+):\\s(.*)$", 8);
            Matcher matcher = inTokensPattern.matcher(in);
            while (matcher.find()) {
                ticketFound = true;
                ticketAttributes.put(matcher.group(1), matcher.group(2));
            }
        }
        catch (HttpException e) {
            this.log().error((Object)("HTTP exception attempting to logon to RT: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            this.log().error((Object)("HTTP exception attempting to logon to RT: " + e.getMessage()));
        }
        finally {
            post.releaseConnection();
        }
        if (!ticketFound) {
            throw new PluginException("could not find ticket in RT for Ticket: " + ticketId);
        }
        ticket = new Ticket();
        ticket.setState(this.rtToOpenNMSState((String)ticketAttributes.get("Status")));
        ticket.setId(ticketId);
        ticket.setUser((String)ticketAttributes.get("Requestors"));
        ticket.setSummary((String)ticketAttributes.get("Subject"));
        return ticket;
    }

    public void saveOrUpdate(Ticket newTicket) throws PluginException {
        Ticket currentTicket = null;
        try {
            if (newTicket.getId() == null) {
                this.log().debug((Object)"TicketId is null creating a new ticket");
                String newTicketID = this.newRtTicket(newTicket);
                newTicket.setId(newTicketID);
                this.log().debug((Object)("created new ticket: " + newTicket.getId()));
            } else {
                currentTicket = this.get(newTicket.getId());
                this.log().debug((Object)("updating existing ticket : " + currentTicket.getId()));
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateRtStatus(newTicket);
                }
            }
        }
        catch (PluginException e) {
            this.log().error((Object)("Failed to create or update RT ticket" + (Object)((Object)e)));
            throw new PluginException("Failed to create or update RT ticket");
        }
    }

    private void updateRtStatus(Ticket ticket) throws PluginException {
        PostMethod post = new PostMethod(this.m_configDao.getBaseURL() + "/REST/1.0/ticket/" + ticket.getId() + "/edit");
        String updateString = new String("Status: " + this.openNMSToRTState(ticket.getState()));
        NameValuePair[] statusUpdateParams = new NameValuePair[]{new NameValuePair("content", updateString), new NameValuePair("user", this.m_user), new NameValuePair("pass", this.m_password)};
        try {
            post.setRequestBody(statusUpdateParams);
            if (this.getClient().executeMethod((HttpMethod)post) != 200) {
                throw new PluginException("Received a non 200 response code from the server");
            }
            String in = post.getResponseBodyAsString();
            Pattern okPattern = Pattern.compile("(?s) Ticket (\\d+) updated");
            Matcher matcher = okPattern.matcher(in);
            if (!matcher.find()) {
                throw new PluginException("Did not receive confirmation from RT that ticket was updated");
            }
        }
        catch (HttpException e) {
            this.log().error((Object)("HTTP exception attempting to logon to RT: " + e.getMessage()));
            throw new PluginException(e.getMessage());
        }
        catch (IOException e) {
            this.log().error((Object)("HTTP exception attempting to logon to RT: " + e.getMessage()));
            throw new PluginException(e.getMessage());
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newRtTicket(Ticket newTicket) throws PluginException {
        String rtTicketNumber;
        block10: {
            rtTicketNumber = null;
            StringBuilder contentBuilder = new StringBuilder("id: ticket/new\n");
            contentBuilder.append("Queue: " + this.m_configDao.getQueue() + "\n");
            contentBuilder.append("Requestor: " + this.m_configDao.getRequestor() + "\n");
            contentBuilder.append("Subject: " + newTicket.getSummary() + "\n");
            contentBuilder.append("text: " + newTicket.getDetails() + "\n");
            PostMethod post = new PostMethod(this.m_configDao.getBaseURL() + "/REST/1.0/edit");
            NameValuePair[] ticketCreateParams = new NameValuePair[]{new NameValuePair("content", contentBuilder.toString()), new NameValuePair("user", this.m_user), new NameValuePair("pass", this.m_password)};
            post.setRequestBody(ticketCreateParams);
            try {
                if (this.getClient().executeMethod((HttpMethod)post) != 200) {
                    throw new PluginException("Received a non 200 response code from the server");
                }
                String in = post.getResponseBodyAsString();
                this.log().debug((Object)in);
                Pattern okPattern = Pattern.compile("(?s) Ticket (\\d+) created");
                Matcher matcher = okPattern.matcher(in);
                if (matcher.find()) {
                    rtTicketNumber = matcher.group(1);
                    break block10;
                }
                throw new PluginException("Did not receive confirmation that ticket was updated");
            }
            catch (HttpException e) {
                this.log().error((Object)("HTTP exception attempting to logon to RT: " + e.getMessage()));
                e.printStackTrace();
            }
            catch (IOException e) {
                this.log().error((Object)("IO exception attempting to logon to RT: " + e.getMessage()));
            }
            finally {
                post.releaseConnection();
            }
        }
        if (rtTicketNumber == null) {
            throw new PluginException("Received no ticket number from RT");
        }
        return rtTicketNumber;
    }

    private String openNMSToRTState(Ticket.State state) {
        String rtStatus;
        this.log().debug((Object)("getting RT status from OpenNMS State " + state.toString()));
        switch (state) {
            case OPEN: {
                rtStatus = this.m_configDao.getOpenStatus();
                this.log().debug((Object)("OpenNMS Status OPEN matched rt status " + rtStatus));
                break;
            }
            case CANCELLED: {
                rtStatus = this.m_configDao.getCancelledStatus();
                this.log().debug((Object)("OpenNMS Status CANCELLED matched rt status " + rtStatus));
                break;
            }
            case CLOSED: {
                rtStatus = this.m_configDao.getClosedStatus();
                this.log().debug((Object)("OpenNMS Status CLOSED matched rt status " + rtStatus));
                break;
            }
            default: {
                this.log().debug((Object)"No valid OpenNMS state on ticket");
                rtStatus = this.m_configDao.getOpenStatus();
            }
        }
        this.log().debug((Object)("OpenNMS state was        " + state.toString()));
        this.log().debug((Object)("setting RT status to " + rtStatus));
        return rtStatus;
    }

    private Ticket.State rtToOpenNMSState(String rtStatus) {
        Ticket.State openNMSState;
        if (this.m_configDao.getValidOpenStatus().contains(rtStatus)) {
            this.log().debug((Object)("RT status " + rtStatus + " matched OpenNMS state Open"));
            openNMSState = Ticket.State.OPEN;
        } else if (this.m_configDao.getValidClosedStatus().contains(rtStatus)) {
            this.log().debug((Object)("RT status " + rtStatus + " matched OpenNMS state Closed"));
            openNMSState = Ticket.State.CLOSED;
        } else if (this.m_configDao.getValidCancelledStatus().contains(rtStatus)) {
            this.log().debug((Object)("RT status " + rtStatus + " matched OpenNMS state Cancelled"));
            openNMSState = Ticket.State.CANCELLED;
        } else {
            this.log().debug((Object)("RT status " + rtStatus + " has no matching OpenNMS state"));
            openNMSState = Ticket.State.OPEN;
        }
        return openNMSState;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private HttpClient getClient() {
        HttpClient client = new HttpClient();
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setConnectionManagerTimeout((long)this.m_configDao.getTimeout());
        clientParams.setSoTimeout(this.m_configDao.getTimeout());
        clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.m_configDao.getRetry(), false));
        clientParams.setCookiePolicy("compatibility");
        client.setParams(clientParams);
        return client;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }
}

