/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.otrs;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOtrsConfigDao {
    private Configuration getProperties() {
        String propsFile = new String(System.getProperty("opennms.home") + "/etc/otrs.properties");
        this.log().debug((Object)("loading properties from: " + propsFile));
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(propsFile);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return config;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getUserName() {
        return this.getProperties().getString("otrs.username");
    }

    String getPassword() {
        return this.getProperties().getString("otrs.password");
    }

    String getEndpoint() {
        return this.getProperties().getString("otrs.endpoint");
    }

    String getState() {
        return this.getProperties().getString("otrs.state");
    }

    Integer getOwnerID() {
        return this.getProperties().getInteger("otrs.ownerid", Integer.valueOf(1));
    }

    String getPriority() {
        return this.getProperties().getString("otrs.priority");
    }

    String getLock() {
        return this.getProperties().getString("otrs.lock");
    }

    String getQueue() {
        return this.getProperties().getString("otrs.queue");
    }

    String getArticleFrom() {
        return this.getProperties().getString("otrs.articlefrom");
    }

    String getArticleType() {
        return this.getProperties().getString("otrs.articletype");
    }

    String getArticleSenderType() {
        return this.getProperties().getString("otrs.articlesendertype");
    }

    String getArticleContentType() {
        return this.getProperties().getString("otrs.articlecontenttype");
    }

    String getArticleHistoryComment() {
        return this.getProperties().getString("otrs.articlehistorycomment");
    }

    String getArticleHistoryType() {
        return this.getProperties().getString("otrs.articlehistorytype");
    }

    List<Integer> getValidClosedStateId() {
        List closedStateId = this.getProperties().getList("otrs.validclosedstateid");
        return this.stringToInt(closedStateId);
    }

    List<Integer> getValidOpenStateId() {
        List openStateId = this.getProperties().getList("otrs.validopenstateid");
        return this.stringToInt(openStateId);
    }

    List<Integer> getValidCancelledStateId() {
        List cancelledStateId = this.getProperties().getList("otrs.validcancelledstateid");
        return this.stringToInt(cancelledStateId);
    }

    Integer getOpenStateId() {
        return this.getProperties().getInteger("otrs.openstateid", Integer.valueOf(1));
    }

    Integer getClosedStateId() {
        this.log().debug((Object)("getting closed state ID: " + this.getProperties().getInteger("otrs.closedstateid", Integer.valueOf(2))));
        return this.getProperties().getInteger("otrs.closedstateid", Integer.valueOf(2));
    }

    Integer getCancelledStateId() {
        return this.getProperties().getInteger("otrs.cancelledstateid", Integer.valueOf(5));
    }

    String getDefaultUser() {
        return this.getProperties().getString("otrs.defaultuser");
    }

    private List<Integer> stringToInt(List<String> strings) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String string : strings) {
            intList.add(Integer.parseInt(string));
        }
        return intList;
    }

    String getTicketOpenedMessage() {
        return this.getProperties().getString("otrs.ticketopenedmessage");
    }

    String getTicketClosedMessage() {
        return this.getProperties().getString("otrs.ticketclosedmessage");
    }

    String getTicketCancelledMessage() {
        return this.getProperties().getString("otrs.ticketcancelledmessage");
    }

    String getTicketUpdatedMessage() {
        return this.getProperties().getString("otrs.ticketupdatedmessage");
    }

    String getArticleUpdateSubject() {
        return this.getProperties().getString("otrs.articleupdatesubject");
    }
}

