/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.otrs;

import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Category;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.integration.otrs.ticketservice.Article;
import org.opennms.integration.otrs.ticketservice.ArticleCore;
import org.opennms.integration.otrs.ticketservice.Credentials;
import org.opennms.integration.otrs.ticketservice.TicketCore;
import org.opennms.integration.otrs.ticketservice.TicketIDAndNumber;
import org.opennms.integration.otrs.ticketservice.TicketServiceLocator;
import org.opennms.integration.otrs.ticketservice.TicketServicePort_PortType;
import org.opennms.integration.otrs.ticketservice.TicketStateUpdate;
import org.opennms.integration.otrs.ticketservice.TicketWithArticles;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.ticketer.otrs.DefaultOtrsConfigDao;
import org.opennms.netmgt.xml.event.Event;

public class OtrsTicketerPlugin
implements Plugin {
    static final String COMMS_ERROR_UEI = "uei.opennms.org/troubleTicket/communicationError";
    EventIpcManager m_eventIpcManager;
    private DefaultOtrsConfigDao m_configDao = new DefaultOtrsConfigDao();

    public OtrsTicketerPlugin() {
        this.m_eventIpcManager = EventIpcManagerFactory.getIpcManager();
    }

    public Ticket get(String ticketId) {
        TicketWithArticles ticketWithArticles = null;
        long otrsTicketNumber = Long.parseLong(ticketId.trim());
        TicketServiceLocator service = new TicketServiceLocator();
        service.setTicketServicePortEndpointAddress(this.m_configDao.getEndpoint());
        TicketServicePort_PortType port = null;
        try {
            port = service.getTicketServicePort();
        }
        catch (ServiceException e) {
            this.log().error((Object)("Failed initialzing OTRS TicketServicePort" + (Object)((Object)e)));
            this.m_eventIpcManager.sendNow(this.createEvent("Failed initialzing OTRS TicketServicePort"));
        }
        Ticket opennmsTicket = new Ticket();
        if (port != null) {
            Credentials creds = new Credentials();
            creds.setUser(this.m_configDao.getUserName());
            creds.setPass(this.m_configDao.getPassword());
            try {
                ticketWithArticles = port.getByNumber(otrsTicketNumber, creds);
            }
            catch (RemoteException e) {
                this.log().error((Object)("Failed to retrieve OTRS ticket" + e));
                this.m_eventIpcManager.sendNow(this.createEvent("Failed to retrieve OTRS ticket"));
            }
        }
        if (ticketWithArticles != null) {
            this.log().debug((Object)("Adding Ticket details from OTRS ticket # " + ticketWithArticles.getTicket().getTicketNumber()));
            opennmsTicket.setId(ticketWithArticles.getTicket().getTicketNumber().toString());
            opennmsTicket.setSummary(ticketWithArticles.getTicket().getTitle());
            opennmsTicket.setUser(ticketWithArticles.getTicket().getOwner());
            opennmsTicket.setState(this.otrsToOpenNMSState(ticketWithArticles.getTicket().getStateID()));
            this.log().debug((Object)("Retrieved ticket state : " + this.otrsToOpenNMSState(ticketWithArticles.getTicket().getStateID())));
            String opennmsTicketDetails = "";
            for (Article article : ticketWithArticles.getArticles()) {
                this.log().debug((Object)("Adding Article details from OTRS article ID " + article.getArticleID()));
                opennmsTicketDetails = opennmsTicketDetails + "\n" + "From:    " + article.getFrom() + "\n" + "Subject: " + article.getSubject() + "\n" + "Body:\n" + article.getBody() + "\n";
            }
            opennmsTicket.setDetails(opennmsTicketDetails);
        }
        return opennmsTicket;
    }

    public void saveOrUpdate(Ticket newTicket) {
        TicketIDAndNumber idAndNumber = null;
        TicketServiceLocator service = new TicketServiceLocator();
        TicketServicePort_PortType port = null;
        Ticket currentTicket = null;
        Credentials creds = new Credentials();
        creds.setUser(this.m_configDao.getUserName());
        creds.setPass(this.m_configDao.getPassword());
        try {
            port = service.getTicketServicePort();
        }
        catch (ServiceException e) {
            this.log().error((Object)("Failed initialzing OTRS TicketServicePort" + (Object)((Object)e)));
            this.m_eventIpcManager.sendNow(this.createEvent("Failed initialzing OTRS TicketServicePort"));
        }
        if (newTicket.getId() != null) {
            currentTicket = this.get(newTicket.getId());
        }
        try {
            if (currentTicket == null) {
                idAndNumber = this.newOTRSTicket(newTicket, port, creds);
                this.log().debug((Object)("creating new ticket : " + idAndNumber.getTicketNumber()));
                newTicket.setId(String.valueOf(idAndNumber.getTicketNumber()));
                this.log().debug((Object)("Ticket ID is " + newTicket.getId()));
                this.newOTRSArticle(idAndNumber.getTicketNumber(), newTicket, port, creds);
            } else {
                this.log().debug((Object)("updating existing ticket : " + currentTicket.getId()));
                if (currentTicket.getState() != newTicket.getState()) {
                    this.updateOTRSState(newTicket, port, creds);
                    this.updateOTRSArticle(Long.parseLong(currentTicket.getId()), newTicket, port, creds);
                }
            }
        }
        catch (RemoteException e) {
            this.log().error((Object)("Failed to create or update OTRS ticket" + e));
            this.createEvent("Failed to create or update OTRS ticket");
        }
    }

    private Event createEvent(String reason) {
        EventBuilder bldr = new EventBuilder(COMMS_ERROR_UEI, "Ticketd");
        bldr.addParam("reason", reason);
        return bldr.getEvent();
    }

    private void updateOTRSState(Ticket ticket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        Integer otrsStateId = this.openNMSToOTRSState(ticket.getState());
        TicketStateUpdate stateUpdate = new TicketStateUpdate();
        stateUpdate.setStateID(otrsStateId);
        stateUpdate.setTicketNumber(Long.parseLong(ticket.getId()));
        if (ticket.getUser() != null) {
            stateUpdate.setUser(ticket.getUser());
        } else {
            stateUpdate.setUser(this.m_configDao.getDefaultUser());
        }
        this.log().debug((Object)"Updating ticket with new state");
        this.log().debug((Object)("Ticket ID:     " + ticket.getId()));
        this.log().debug((Object)("OpenNMS State: " + ticket.getState().toString()));
        this.log().debug((Object)("OTRS state:    " + otrsStateId.toString()));
        port.ticketStateUpdate(stateUpdate, creds);
    }

    private TicketIDAndNumber newOTRSTicket(Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        TicketIDAndNumber idAndNumber = null;
        TicketCore newOtrsTicket = new TicketCore();
        newOtrsTicket.setTitle(newTicket.getSummary());
        if (newTicket.getUser() != null) {
            newOtrsTicket.setUser(newTicket.getUser());
        } else {
            newOtrsTicket.setUser(this.m_configDao.getDefaultUser());
        }
        newOtrsTicket.setStateID(this.openNMSToOTRSState(newTicket.getState()));
        newOtrsTicket.setQueue(this.m_configDao.getQueue());
        newOtrsTicket.setPriority(this.m_configDao.getPriority());
        newOtrsTicket.setLock(this.m_configDao.getLock());
        newOtrsTicket.setOwnerID(this.m_configDao.getOwnerID());
        idAndNumber = port.ticketCreate(newOtrsTicket, creds);
        return idAndNumber;
    }

    private void newOTRSArticle(Long otrsTicketNumber, Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        ArticleCore newOtrsArticle = new ArticleCore();
        this.log().debug((Object)("Adding a new article to ticket: " + otrsTicketNumber));
        newOtrsArticle.setBody(newTicket.getDetails());
        newOtrsArticle.setTicketNumber(otrsTicketNumber);
        newOtrsArticle.setFrom(this.m_configDao.getArticleFrom());
        if (newTicket.getUser() != null) {
            newOtrsArticle.setUser(newTicket.getUser());
        } else {
            newOtrsArticle.setUser(this.m_configDao.getDefaultUser());
        }
        newOtrsArticle.setSubject(newTicket.getSummary());
        newOtrsArticle.setArticleType(this.m_configDao.getArticleType());
        newOtrsArticle.setSenderType(this.m_configDao.getArticleSenderType());
        newOtrsArticle.setContentType(this.m_configDao.getArticleContentType());
        newOtrsArticle.setHistoryType(this.m_configDao.getArticleHistoryType());
        newOtrsArticle.setHistoryComment(this.m_configDao.getArticleHistoryComment());
        port.articleCreate(newOtrsArticle, creds);
    }

    private void updateOTRSArticle(Long otrsTicketNumber, Ticket newTicket, TicketServicePort_PortType port, Credentials creds) throws RemoteException {
        ArticleCore newOtrsArticle = new ArticleCore();
        this.log().debug((Object)("Adding a new article to ticket: " + otrsTicketNumber));
        switch (newTicket.getState()) {
            case OPEN: {
                newOtrsArticle.setBody(this.m_configDao.getTicketOpenedMessage());
                break;
            }
            case CANCELLED: {
                newOtrsArticle.setBody(this.m_configDao.getTicketCancelledMessage());
                break;
            }
            case CLOSED: {
                newOtrsArticle.setBody(this.m_configDao.getTicketClosedMessage());
                break;
            }
            default: {
                this.log().debug((Object)"No valid OpenNMS state on ticket");
                newOtrsArticle.setBody(this.m_configDao.getTicketUpdatedMessage());
            }
        }
        newOtrsArticle.setTicketNumber(otrsTicketNumber);
        newOtrsArticle.setFrom(this.m_configDao.getArticleFrom());
        if (newTicket.getUser() != null) {
            newOtrsArticle.setUser(newTicket.getUser());
        } else {
            newOtrsArticle.setUser(this.m_configDao.getDefaultUser());
        }
        newOtrsArticle.setSubject(this.m_configDao.getArticleUpdateSubject());
        newOtrsArticle.setArticleType(this.m_configDao.getArticleType());
        newOtrsArticle.setSenderType(this.m_configDao.getArticleSenderType());
        newOtrsArticle.setContentType(this.m_configDao.getArticleContentType());
        newOtrsArticle.setHistoryType(this.m_configDao.getArticleHistoryType());
        newOtrsArticle.setHistoryComment(this.m_configDao.getArticleHistoryComment());
        port.articleCreate(newOtrsArticle, creds);
    }

    private Integer openNMSToOTRSState(Ticket.State state) {
        Integer otrsStateId;
        this.log().debug((Object)("getting otrs state from OpenNMS State " + state.toString()));
        switch (state) {
            case OPEN: {
                otrsStateId = this.m_configDao.getOpenStateId();
                break;
            }
            case CANCELLED: {
                otrsStateId = this.m_configDao.getCancelledStateId();
                break;
            }
            case CLOSED: {
                otrsStateId = this.m_configDao.getClosedStateId();
                break;
            }
            default: {
                this.log().debug((Object)"No valid OpenNMS state on ticket");
                otrsStateId = this.m_configDao.getOpenStateId();
            }
        }
        this.log().debug((Object)("OpenNMS state was        " + state.toString()));
        this.log().debug((Object)("setting OTRS state ID to " + otrsStateId.toString()));
        return otrsStateId;
    }

    private Ticket.State otrsToOpenNMSState(Integer otrsStateId) {
        Ticket.State openNMSState;
        if (this.m_configDao.getValidOpenStateId().contains(otrsStateId)) {
            this.log().debug((Object)("OTRS state ID " + otrsStateId.toString() + " matched OpenNMS state Open"));
            openNMSState = Ticket.State.OPEN;
        } else if (this.m_configDao.getValidClosedStateId().contains(otrsStateId)) {
            this.log().debug((Object)("OTRS state ID " + otrsStateId.toString() + " matched OpenNMS state Closed"));
            openNMSState = Ticket.State.CLOSED;
        } else if (this.m_configDao.getValidCancelledStateId().contains(otrsStateId)) {
            this.log().debug((Object)("OTRS state ID " + otrsStateId.toString() + " matched OpenNMS state Cancelled"));
            openNMSState = Ticket.State.CANCELLED;
        } else {
            this.log().debug((Object)("OTRS state ID " + otrsStateId.toString() + " has no matching OpenNMS state"));
            openNMSState = Ticket.State.OPEN;
        }
        return openNMSState;
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager ipcManager) {
        this.m_eventIpcManager = ipcManager;
    }
}

