/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ProcessExec;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.C3P0ConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.dao.db.InstallerDb;
import org.opennms.netmgt.dao.db.SimpleDataSource;
import org.opennms.netmgt.ping.Ping;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.springframework.util.StringUtils;

public class Installer {
    static final String s_version = "$Id: Installer.java 11800 2009-01-11 23:04:48Z dhustace $";
    static final String LIBRARY_PROPERTY_FILE = "libraries.properties";
    String m_opennms_home = null;
    boolean m_update_database = false;
    boolean m_do_inserts = false;
    boolean m_skip_constraints = false;
    boolean m_update_iplike = false;
    boolean m_update_unicode = false;
    boolean m_do_full_vacuum = false;
    boolean m_do_vacuum = false;
    boolean m_install_webapp = false;
    boolean m_fix_constraint = false;
    boolean m_force = false;
    boolean m_ignore_not_null = false;
    boolean m_ignore_database_version = false;
    boolean m_do_not_revert = false;
    boolean m_remove_database = false;
    String m_etc_dir = "";
    String m_tomcat_conf = null;
    String m_webappdir = null;
    String m_install_servletdir = null;
    String m_library_search_path = null;
    String m_fix_constraint_name = null;
    boolean m_fix_constraint_remove_rows = false;
    protected Options options = new Options();
    protected CommandLine m_commandLine;
    private PrintStream m_out;
    Properties m_properties = null;
    String m_required_options = "At least one of -d, -i, -s, -y, -C, or -T is required.";
    private InstallerDb m_installerDb = new InstallerDb();
    private static final String OPENNMS_DATA_SOURCE_NAME = "opennms";
    private static final String ADMIN_DATA_SOURCE_NAME = "opennms-admin";

    public Installer() {
        this.setOutputStream(System.out);
    }

    public void install(String[] argv) throws Exception {
        boolean doDatabase;
        this.printHeader();
        this.loadProperties();
        this.parseArguments(argv);
        boolean bl = doDatabase = this.m_update_database || this.m_do_inserts || this.m_update_iplike || this.m_update_unicode || this.m_fix_constraint;
        if (!doDatabase && this.m_tomcat_conf == null && !this.m_install_webapp && this.m_library_search_path == null) {
            this.usage(this.options, this.m_commandLine, "Nothing to do.  Use -h for help.", null);
            System.exit(1);
        }
        if (doDatabase) {
            this.m_installerDb.setForce(this.m_force);
            this.m_installerDb.setIgnoreNotNull(this.m_ignore_not_null);
            this.m_installerDb.setNoRevert(this.m_do_not_revert);
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
            FileReader fr = new FileReader(cfgFile);
            JdbcDataSource adminDs = C3P0ConnectionFactory.marshalDataSourceFromConfig((Reader)fr, (String)ADMIN_DATA_SOURCE_NAME);
            ((Reader)fr).close();
            this.m_installerDb.setAdminDataSource((DataSource)new SimpleDataSource(adminDs));
            fr = new FileReader(cfgFile);
            JdbcDataSource ds = C3P0ConnectionFactory.marshalDataSourceFromConfig((Reader)fr, (String)OPENNMS_DATA_SOURCE_NAME);
            this.m_installerDb.setDataSource((DataSource)new SimpleDataSource(ds));
            ((Reader)fr).close();
            this.m_installerDb.setPostgresOpennmsUser(ds.getUserName());
            this.m_installerDb.setPostgresOpennmsPassword(ds.getPassword());
            this.m_installerDb.setDatabaseName(ds.getDatabaseName());
        }
        if (!Boolean.getBoolean("skip-native")) {
            String icmp_path = this.findLibrary("jicmp", this.m_library_search_path, true);
            String jrrd_path = this.findLibrary("jrrd", this.m_library_search_path, false);
            this.writeLibraryConfig(icmp_path, jrrd_path);
        }
        if (doDatabase) {
            if (!this.m_ignore_database_version) {
                this.m_installerDb.databaseCheckVersion();
            }
            this.m_installerDb.databaseCheckLanguage();
            this.m_out.println("* using '" + this.m_installerDb.getPostgresOpennmsUser() + "' as the PostgreSQL user for OpenNMS");
            this.m_out.println("* using '" + this.m_installerDb.getPostgresOpennmsPassword() + "' as the PostgreSQL password for OpenNMS");
            this.m_out.println("* using '" + this.m_installerDb.getDatabaseName() + "' as the PostgreSQL database name for OpenNMS");
        }
        this.verifyFilesAndDirectories();
        if (this.m_install_webapp) {
            this.checkWebappOldOpennmsDir();
            this.checkServerXmlOldOpennmsContext();
        }
        if (this.m_update_database || this.m_fix_constraint) {
            this.m_installerDb.readTables();
        }
        if (this.m_update_database) {
            if (!this.m_installerDb.databaseUserExists()) {
                this.m_installerDb.databaseAddUser();
            }
            if (!this.m_installerDb.databaseDBExists()) {
                this.m_installerDb.databaseAddDB();
            }
        }
        if (doDatabase) {
            this.m_installerDb.checkUnicode();
        }
        if (this.m_fix_constraint) {
            this.m_installerDb.fixConstraint(this.m_fix_constraint_name, this.m_fix_constraint_remove_rows);
        }
        if (this.m_update_database) {
            this.m_installerDb.checkOldTables();
            if (!this.m_skip_constraints) {
                this.m_installerDb.checkConstraints();
                this.m_installerDb.checkIndexUniqueness();
            }
            this.m_installerDb.createSequences();
            this.m_installerDb.updatePlPgsql();
            this.m_installerDb.addStoredProcedures();
            this.m_installerDb.addColumnReplacements();
            this.m_installerDb.createTables();
            this.m_installerDb.closeColumnReplacements();
            this.m_installerDb.fixData();
        }
        if (this.m_do_inserts) {
            this.m_installerDb.insertData();
        }
        if (this.m_update_unicode) {
            this.m_out.println("WARNING: the -U option is deprecated, it does nothing now");
        }
        if (this.m_do_vacuum) {
            this.m_installerDb.vacuumDatabase(this.m_do_full_vacuum);
        }
        if (this.m_install_webapp) {
            this.installWebApp();
        }
        if (this.m_tomcat_conf != null) {
            this.updateTomcatConf();
        }
        if (this.m_update_iplike) {
            this.m_installerDb.updateIplike();
        }
        if (this.m_update_database && this.m_remove_database) {
            this.m_installerDb.disconnect();
            this.m_installerDb.databaseRemoveDB();
        }
        if (doDatabase) {
            this.m_installerDb.disconnect();
        }
        if (this.m_update_database) {
            this.createConfiguredFile();
        }
        this.m_out.println();
        this.m_out.println("Installer completed successfully!");
    }

    public void createConfiguredFile() throws IOException {
        File f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + "configured");
        f.createNewFile();
    }

    public void printHeader() {
        this.m_out.println("==============================================================================");
        this.m_out.println("OpenNMS Installer Version $Id: Installer.java 11800 2009-01-11 23:04:48Z dhustace $");
        this.m_out.println("==============================================================================");
        this.m_out.println("");
        this.m_out.println("Configures PostgreSQL tables, users, and other miscellaneous settings.");
        this.m_out.println("");
    }

    public void loadProperties() throws Exception {
        this.m_properties = new Properties();
        this.m_properties.load(Installer.class.getResourceAsStream("installer.properties"));
        Properties sys = System.getProperties();
        this.m_properties.putAll((Map<?, ?>)sys);
        this.m_opennms_home = this.fetchProperty("install.dir");
        this.m_etc_dir = this.fetchProperty("install.etc.dir");
        this.m_install_servletdir = this.fetchProperty("install.servlet.dir");
        String soext = this.fetchProperty("build.soext");
        String pg_iplike_dir = this.m_properties.getProperty("install.postgresql.dir");
        if (pg_iplike_dir != null) {
            this.m_installerDb.setPostgresIpLikeLocation(pg_iplike_dir + File.separator + "iplike." + soext);
        }
        this.m_installerDb.setStoredProcedureDirectory(this.m_etc_dir);
        this.m_installerDb.setCreateSqlLocation(this.m_etc_dir + File.separator + "create.sql");
    }

    public String fetchProperty(String property) throws Exception {
        String value = this.m_properties.getProperty(property);
        if (value == null) {
            throw new Exception("property \"" + property + "\" not set " + "from bundled installer.properties file");
        }
        return value;
    }

    public void parseArguments(String[] argv) throws Exception {
        this.options.addOption("h", "help", false, "this help");
        this.options.addOption("d", "do-database", false, "perform database actions");
        this.options.addOption("Z", "remove-database", false, "remove the OpenNMS database");
        this.options.addOption("u", "username", true, "username of the database account (default: 'opennms')");
        this.options.addOption("p", "password", true, "password of the database account (default: 'opennms')");
        this.options.addOption("a", "admin-username", true, "username of the database administrator (default: 'postgres')");
        this.options.addOption("A", "admin-password", true, "password of the database administrator (default: '')");
        this.options.addOption("D", "database-url", true, "JDBC database URL (default: jdbc:postgresql://localhost:5432/");
        this.options.addOption("P", "database-name", true, "name of the PostgreSQL database (default: opennms)");
        this.options.addOption("c", "clean-database", false, "clean existing database before creating");
        this.options.addOption("i", "insert-data", false, "insert default data into the database");
        this.options.addOption("s", "stored-procedure", false, "add the IPLIKE stored procedure if it's missing");
        this.options.addOption("U", "unicode", false, "upgrade the database to Unicode (deprecated, does nothing)");
        this.options.addOption("v", "vacuum", false, "vacuum (optimize) the database");
        this.options.addOption("f", "vacuum-full", false, "vacuum full the database (recovers unused disk space)");
        this.options.addOption("N", "ignore-not-null", false, "ignore NOT NULL constraint when transforming data");
        this.options.addOption("Q", "ignore-database-version", false, "disable the database version check");
        this.options.addOption("x", "database-debug", false, "turn on debugging for the database data transformation");
        this.options.addOption("R", "do-not-revert", false, "do not revert a table to the original if an error occurs");
        this.options.addOption("n", "skip-constraint", false, "");
        this.options.addOption("C", "repair-constraint", true, "fix rows that violate the specified constraint (sets key column to NULL)");
        this.options.addOption("X", "drop-constraint", false, "drop rows that match the constraint specified in -C, instead of fixing them");
        this.options.addOption("y", "do-webapp", false, "install web application (see '-w')");
        this.options.addOption("T", "tomcat-conf", true, "location of tomcat.conf");
        this.options.addOption("w", "tomcat-context", true, "location of the tomcat context (eg, conf/Catalina/localhost)");
        this.options.addOption("l", "library-path", true, "library search path (directories separated by '" + File.pathSeparator + "')");
        this.options.addOption("r", "rpm-install", false, "RPM install (deprecated)");
        PosixParser parser = new PosixParser();
        this.m_commandLine = parser.parse(this.options, argv);
        if (this.m_commandLine.hasOption("h")) {
            this.usage(this.options, this.m_commandLine);
            System.exit(0);
        }
        this.options.addOption("u", "username", true, "replaced by opennms-datasources.xml");
        this.options.addOption("p", "password", true, "replaced by opennms-datasources.xml");
        this.options.addOption("a", "admin-username", true, "replaced by opennms-datasources.xml");
        this.options.addOption("A", "admin-password", true, "replaced by opennms-datasources.xml");
        this.options.addOption("D", "database-url", true, "replaced by opennms-datasources.xml");
        this.options.addOption("P", "database-name", true, "replaced by opennms-datasources.xml");
        if (this.m_commandLine.hasOption("u") || this.m_commandLine.hasOption("p") || this.m_commandLine.hasOption("a") || this.m_commandLine.hasOption("A") || this.m_commandLine.hasOption("D") || this.m_commandLine.hasOption("P")) {
            this.usage(this.options, this.m_commandLine, "The 'u', 'p', 'a', 'A', 'D', and 'P' options have all been superceded.\nPlease edit $OPENNMS_HOME/etc/opennms-datasources.xml instead.", null);
            System.exit(1);
        }
        this.m_force = this.m_commandLine.hasOption("c");
        this.m_fix_constraint = this.m_commandLine.hasOption("C");
        this.m_fix_constraint_name = this.m_commandLine.getOptionValue("C");
        this.m_update_database = this.m_commandLine.hasOption("d");
        this.m_remove_database = this.m_commandLine.hasOption("Z");
        this.m_do_full_vacuum = this.m_commandLine.hasOption("f");
        this.m_do_inserts = this.m_commandLine.hasOption("i");
        this.m_library_search_path = this.m_commandLine.getOptionValue("l", this.m_library_search_path);
        this.m_skip_constraints = this.m_commandLine.hasOption("n");
        this.m_ignore_not_null = this.m_commandLine.hasOption("N");
        this.m_ignore_database_version = this.m_commandLine.hasOption("Q");
        this.m_do_not_revert = this.m_commandLine.hasOption("R");
        this.m_update_iplike = this.m_commandLine.hasOption("s");
        this.m_tomcat_conf = this.m_commandLine.getOptionValue("T", this.m_tomcat_conf);
        this.m_update_unicode = this.m_commandLine.hasOption("U");
        this.m_do_vacuum = this.m_commandLine.hasOption("v");
        this.m_webappdir = this.m_commandLine.getOptionValue("w", this.m_webappdir);
        this.m_installerDb.setDebug(this.m_commandLine.hasOption("x"));
        this.m_fix_constraint_remove_rows = this.m_commandLine.hasOption("X");
        this.m_install_webapp = this.m_commandLine.hasOption("y");
        if (this.m_commandLine.getArgList().size() > 0) {
            this.usage(this.options, this.m_commandLine, "Unknown command-line arguments: " + Arrays.toString(this.m_commandLine.getArgs()), null);
            System.exit(1);
        }
    }

    public void verifyFilesAndDirectories() throws FileNotFoundException {
        if (this.m_update_database) {
            this.verifyFileExists(true, this.m_installerDb.getStoredProcedureDirectory(), "SQL directory", "install.etc.dir property");
            this.verifyFileExists(false, this.m_installerDb.getCreateSqlLocation(), "create.sql", "install.etc.dir property");
        }
        if (this.m_tomcat_conf != null) {
            this.verifyFileExists(false, this.m_tomcat_conf, "Tomcat startup configuration file tomcat4.conf", "-T option");
        }
        if (this.m_install_webapp) {
            this.verifyFileExists(true, this.m_webappdir, "Tomcat context directory", "-w option");
            this.verifyFileExists(true, this.m_install_servletdir, "OpenNMS servlet directory", "install.servlet.dir property");
        }
    }

    public void verifyFileExists(boolean isDir, String file, String description, String option) throws FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("The user most provide the location of " + description + ", but this is not specified.  Use the " + option + " to specify this file.");
        }
        this.m_out.print("- using " + description + "... ");
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException(description + " does not exist at \"" + file + "\".  Use the " + option + " to specify another location.");
        }
        if (!isDir) {
            if (!f.isFile()) {
                throw new FileNotFoundException(description + " not a file at \"" + file + "\".  Use the " + option + " to specify another file.");
            }
        } else if (!f.isDirectory()) {
            throw new FileNotFoundException(description + " not a directory at \"" + file + "\".  Use the " + option + " to specify " + "another directory.");
        }
        this.m_out.println(f.getAbsolutePath());
    }

    public void checkWebappOldOpennmsDir() throws Exception {
        File f = new File(this.m_webappdir + File.separator + OPENNMS_DATA_SOURCE_NAME);
        this.m_out.print("- Checking for old opennms webapp directory in " + f.getAbsolutePath() + "... ");
        if (f.exists()) {
            throw new Exception("Old OpenNMS web application exists: " + f.getAbsolutePath() + ".  You need to remove this " + "before continuing.");
        }
        this.m_out.println("OK");
    }

    public void checkServerXmlOldOpennmsContext() throws Exception {
        String line;
        String search_regexp = "(?ms).*<Context\\s+path=\"/opennms\".*";
        StringBuffer b = new StringBuffer();
        File f = new File(this.m_webappdir + File.separator + ".." + File.separator + "conf" + File.separator + "server.xml");
        this.m_out.print("- Checking for old opennms context in " + f.getAbsolutePath() + "... ");
        if (!f.exists()) {
            this.m_out.println("DID NOT CHECK (file does not exist)");
            return;
        }
        FileReader fr = new FileReader(f);
        BufferedReader r = new BufferedReader(fr);
        while ((line = r.readLine()) != null) {
            b.append(line);
            b.append("\n");
        }
        r.close();
        fr.close();
        if (b.toString().matches(search_regexp)) {
            throw new Exception("Old OpenNMS context found in " + f.getAbsolutePath() + ".  You must remove this context from server.xml and re-run the installer.");
        }
        this.m_out.println("OK");
    }

    public void installWebApp() throws Exception {
        this.m_out.println("- Install OpenNMS webapp... ");
        this.copyFile(this.m_install_servletdir + File.separator + "META-INF" + File.separator + "context.xml", this.m_webappdir + File.separator + "opennms.xml", "web application context", false);
        this.m_out.println("- Installing OpenNMS webapp... DONE");
    }

    public void copyFile(String source, String destination, String description, boolean recursive) throws Exception {
        File sourceFile = new File(source);
        File destinationFile = new File(destination);
        if (!sourceFile.exists()) {
            throw new Exception("source file (" + source + ") does not exist!");
        }
        if (!sourceFile.isFile()) {
            throw new Exception("source file (" + source + ") is not a file!");
        }
        if (!sourceFile.canRead()) {
            throw new Exception("source file (" + source + ") is not readable!");
        }
        if (destinationFile.exists()) {
            this.m_out.print("  - " + destination + " exists, removing... ");
            if (destinationFile.delete()) {
                this.m_out.println("REMOVED");
            } else {
                this.m_out.println("FAILED");
                throw new Exception("unable to delete existing file: " + sourceFile);
            }
        }
        this.m_out.print("  - copying " + source + " to " + destination + "... ");
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            throw new Exception("unable to create directory: " + destinationFile.getParent());
        }
        if (!destinationFile.createNewFile()) {
            throw new Exception("unable to create file: " + destinationFile);
        }
        FileChannel from = null;
        AbstractInterruptibleChannel to = null;
        try {
            from = new FileInputStream(sourceFile).getChannel();
            to = new FileOutputStream(destinationFile).getChannel();
            ((FileChannel)to).transferFrom(from, 0L, from.size());
        }
        catch (FileNotFoundException e) {
            throw new Exception("unable to copy " + sourceFile + " to " + destinationFile, e);
        }
        finally {
            if (from != null) {
                from.close();
            }
            if (to != null) {
                to.close();
            }
        }
        this.m_out.println("DONE");
    }

    public void installLink(String source, String destination, String description, boolean recursive) throws Exception {
        ProcessExec e = new ProcessExec(this.m_out, this.m_out);
        if (new File(destination).exists()) {
            this.m_out.print("  - " + destination + " exists, removing... ");
            this.removeFile(destination, description, recursive);
            this.m_out.println("REMOVED");
        }
        this.m_out.print("  - creating link to " + destination + "... ");
        String[] cmd = new String[]{"ln", "-sf", source, destination};
        if (e.exec(cmd) != 0) {
            throw new Exception("Non-zero exit value returned while linking " + description + ", " + source + " into " + destination);
        }
        this.m_out.println("DONE");
    }

    public void updateTomcatConf() throws Exception {
        String line;
        File f = new File(this.m_tomcat_conf);
        this.m_out.print("- setting tomcat4 user to 'root'... ");
        BufferedReader r = new BufferedReader(new FileReader(f));
        StringBuffer b = new StringBuffer();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("TOMCAT_USER=")) {
                b.append("TOMCAT_USER=\"root\"\n");
                continue;
            }
            b.append(line);
            b.append("\n");
        }
        r.close();
        f.renameTo(new File(this.m_tomcat_conf + ".before-opennms-" + System.currentTimeMillis()));
        f = new File(this.m_tomcat_conf);
        PrintWriter w = new PrintWriter(new FileOutputStream(f));
        w.print(b.toString());
        w.close();
        this.m_out.println("done");
    }

    public void removeFile(String destination, String description, boolean recursive) throws IOException, InterruptedException, Exception {
        ProcessExec e = new ProcessExec(this.m_out, this.m_out);
        Object[] cmd = recursive ? new String[]{"rm", "-r", destination} : new String[]{"rm", destination};
        if (e.exec((String[])cmd) != 0) {
            throw new Exception("Non-zero exit value returned while removing " + description + ", " + destination + ", using \"" + StringUtils.arrayToDelimitedString((Object[])cmd, (String)" ") + "\"");
        }
        if (new File(destination).exists()) {
            this.usage(this.options, this.m_commandLine, "Could not delete existing " + description + ": " + destination, null);
            System.exit(1);
        }
    }

    private void usage(Options options, CommandLine cmd) {
        this.usage(options, cmd, null, null);
    }

    private void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(this.m_out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("usage: install [options]", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    public static void main(String[] argv) throws Exception {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        new Installer().install(argv);
    }

    public String checkServerVersion() throws IOException {
        File catalinaHome = new File(this.m_webappdir).getParentFile();
        String readmeVersion = this.getTomcatVersion(new File(catalinaHome, "README.txt"));
        String runningVersion = this.getTomcatVersion(new File(catalinaHome, "RUNNING.txt"));
        if (readmeVersion == null && runningVersion == null) {
            return null;
        }
        if (readmeVersion != null && runningVersion != null) {
            return readmeVersion;
        }
        if (readmeVersion != null && runningVersion == null) {
            return readmeVersion;
        }
        return runningVersion;
    }

    public String getTomcatVersion(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        Pattern p = Pattern.compile("The Tomcat (\\S+) Servlet/JSP Container");
        BufferedReader in = new BufferedReader(new FileReader(file));
        for (int i = 0; i < 5; ++i) {
            String line = in.readLine();
            if (line == null) {
                in.close();
                return null;
            }
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            in.close();
            return m.group(1);
        }
        in.close();
        return null;
    }

    public String findLibrary(String libname, String path, boolean isRequired) throws Exception {
        String fullname = System.mapLibraryName(libname);
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (path != null) {
            for (String entry : path.split(File.pathSeparator)) {
                searchPaths.add(entry);
            }
        }
        try {
            File confFile = new File(this.m_opennms_home + File.separator + "etc" + File.separator + LIBRARY_PROPERTY_FILE);
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(confFile);
            p.load(is);
            ((InputStream)is).close();
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("opennms.library")) continue;
                String value = p.getProperty(key);
                value.replaceAll(File.separator + "[^" + File.separator + "]*$", "");
                searchPaths.add(value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (System.getProperty("java.library.path") != null) {
            for (String entry : System.getProperty("java.library.path").split(File.pathSeparator)) {
                searchPaths.add(entry);
            }
        }
        if (!System.getProperty("os.name").contains("Windows")) {
            String[] defaults;
            for (String entry : defaults = new String[]{"/usr/lib/jni", "/usr/lib", "/usr/local/lib", "/opt/NMSjicmp/lib/32", "/opt/NMSjicmp/lib/64"}) {
                searchPaths.add(entry);
            }
        }
        this.m_out.println("- searching for " + libname + ":");
        for (String dirname : searchPaths) {
            String fullpath;
            File entry = new File(dirname);
            if (entry.isFile()) {
                dirname = entry.getParent();
            }
            if (!this.loadLibrary(fullpath = dirname + File.separator + fullname)) continue;
            return fullpath;
        }
        if (isRequired) {
            StringBuffer buf = new StringBuffer();
            for (String pathEntry : System.getProperty("java.library.path").split(File.pathSeparator)) {
                buf.append(" ");
                buf.append(pathEntry);
            }
            throw new Exception("Failed to load the required " + libname + " library that is required at runtime.  By default, we search the Java library path:" + buf.toString() + ".  For more information, see http://www.opennms.org/index.php/" + libname);
        }
        this.m_out.println("- Failed to load the optional " + libname + " library.");
        this.m_out.println("  - This error is not fatal, since " + libname + " is only required for optional features.");
        this.m_out.println("  - For more information, see http://www.opennms.org/index.php/" + libname);
        return null;
    }

    public boolean loadLibrary(String path) {
        try {
            this.m_out.print("  - trying to load " + path + ": ");
            System.load(path);
            this.m_out.println("OK");
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            this.m_out.println("NO");
            return false;
        }
    }

    public void writeLibraryConfig(String jicmp_path, String jrrd_path) throws IOException {
        Properties libraryProps = new Properties();
        if (jicmp_path != null && jicmp_path.length() != 0) {
            libraryProps.put("opennms.library.jicmp", jicmp_path);
        }
        if (jrrd_path != null && jrrd_path.length() != 0) {
            libraryProps.put("opennms.library.jrrd", jrrd_path);
        }
        File f = null;
        try {
            f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + LIBRARY_PROPERTY_FILE);
            f.createNewFile();
            FileOutputStream os = new FileOutputStream(f);
            libraryProps.store(os, null);
        }
        catch (IOException e) {
            this.m_out.println("unable to write to " + f.getPath());
            throw e;
        }
    }

    public void pingLocalhost() throws IOException {
        String host = "127.0.0.1";
        IcmpSocket m_socket = null;
        try {
            m_socket = new IcmpSocket();
        }
        catch (UnsatisfiedLinkError e) {
            this.m_out.println("UnsatisfiedLinkError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.  Try setting the property 'opennms.library.jicmp' to point at the full path name of the libjicmp.so shared library (e.g. 'java -Dopennms.library.jicmp=/some/path/libjicmp.so ...')");
            throw e;
        }
        catch (NoClassDefFoundError e) {
            this.m_out.println("NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.");
            throw e;
        }
        catch (IOException e) {
            this.m_out.println("IOException while creating an IcmpSocket.");
            throw e;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            this.m_out.println("UnknownHostException when looking up " + host + ".");
            throw e;
        }
        this.m_out.println("PING " + host + " (" + addr.getHostAddress() + "): 56 data bytes");
        short m_icmpId = 2;
        Ping.Stuff s = new Ping.Stuff(m_socket, m_icmpId);
        Thread t = new Thread((Runnable)s);
        t.start();
        int count = 3;
        for (long attempt = 0L; attempt < (long)count; ++attempt) {
            ICMPEchoPacket pingPkt = new ICMPEchoPacket(attempt);
            pingPkt.setIdentity(m_icmpId);
            pingPkt.computeChecksum();
            byte[] buf = pingPkt.toBytes();
            DatagramPacket sendPkt = new DatagramPacket(buf, buf.length, addr, 0);
            buf = null;
            pingPkt = null;
            try {
                m_socket.send(sendPkt);
            }
            catch (IOException e) {
                this.m_out.println("IOException received when sending packet.");
                throw e;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public InstallerDb getInstallerDb() {
        return this.m_installerDb;
    }

    public void setOutputStream(PrintStream out) {
        this.m_out = out;
        this.m_installerDb.setOutputStream(this.m_out);
    }
}

