/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.opennms.core.utils.ProcessExec;
import org.opennms.netmgt.dao.db.InstallerDb;
import org.opennms.netmgt.dao.db.SimpleDataSource;
import org.opennms.netmgt.ping.Ping;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;
import org.springframework.util.StringUtils;

public class Installer {
    static final String s_version = "$Id: Installer.java 7383 2007-09-07 22:14:34Z rangerrick $";
    String m_opennms_home = null;
    boolean m_update_database = false;
    boolean m_do_inserts = false;
    boolean m_skip_constraints = false;
    boolean m_update_iplike = false;
    boolean m_update_unicode = false;
    boolean m_do_full_vacuum = false;
    boolean m_do_vacuum = false;
    boolean m_install_webapp = false;
    boolean m_fix_constraint = false;
    boolean m_force = false;
    String m_pg_driver = null;
    String m_pg_url = null;
    String m_pg_user = "postgres";
    String m_pg_pass = "";
    String m_tomcat_conf = null;
    String m_webappdir = null;
    String m_install_servletdir = null;
    String m_library_search_path = null;
    String m_fix_constraint_name = null;
    boolean m_fix_constraint_remove_rows = false;
    private PrintStream m_out;
    Properties m_properties = null;
    String m_required_options = "At least one of -d, -i, -s, -U, -y, -C, or -T is required.";
    private InstallerDb m_installerDb = new InstallerDb();

    public Installer() {
        this.setOutputStream(System.out);
    }

    public void install(String[] argv) throws Exception {
        this.printHeader();
        this.loadProperties();
        this.parseArguments(argv);
        if (!(this.m_update_database || this.m_do_inserts || this.m_update_iplike || this.m_update_unicode || this.m_tomcat_conf != null || this.m_install_webapp || this.m_fix_constraint)) {
            throw new Exception("Nothing to do.\n" + this.m_required_options + "\nUse '-h' for help.");
        }
        SimpleDataSource adminDataSource = new SimpleDataSource(this.m_pg_driver, this.m_pg_url + "template1", this.m_pg_user, this.m_pg_pass);
        this.m_installerDb.setAdminDataSource((DataSource)adminDataSource);
        SimpleDataSource opennmsDataSource = new SimpleDataSource(this.m_pg_driver, this.m_pg_url + this.m_installerDb.getDatabaseName(), this.m_pg_user, this.m_pg_pass);
        this.m_installerDb.setDataSource((DataSource)opennmsDataSource);
        String icmp_path = this.findLibrary("jicmp", this.m_library_search_path, true);
        String jrrd_path = this.findLibrary("jrrd", this.m_library_search_path, false);
        this.writeLibraryConfig(icmp_path, jrrd_path);
        if (this.m_update_database || this.m_update_iplike || this.m_update_unicode || this.m_do_inserts || this.m_fix_constraint) {
            this.m_installerDb.databaseCheckVersion();
            this.m_installerDb.databaseCheckLanguage();
        }
        this.printDiagnostics();
        this.verifyFilesAndDirectories();
        if (this.m_install_webapp) {
            this.checkWebappOldOpennmsDir();
            this.checkServerXmlOldOpennmsContext();
        }
        if (this.m_update_database || this.m_fix_constraint) {
            this.m_installerDb.readTables();
        }
        if (this.m_update_database) {
            if (!this.m_installerDb.databaseUserExists()) {
                this.m_installerDb.databaseAddUser();
            }
            if (!this.m_installerDb.databaseDBExists()) {
                this.m_installerDb.databaseAddDB();
            }
        }
        if (this.m_fix_constraint) {
            this.m_installerDb.fixConstraint(this.m_fix_constraint_name, this.m_fix_constraint_remove_rows);
        }
        if (this.m_update_database) {
            this.m_installerDb.checkOldTables();
            if (!this.m_skip_constraints) {
                this.m_installerDb.checkConstraints();
                this.m_installerDb.checkIndexUniqueness();
            }
            this.m_installerDb.createSequences();
            this.m_installerDb.updatePlPgsql();
            this.m_installerDb.addStoredProcedures();
            this.m_installerDb.addColumnReplacements();
            this.m_installerDb.createTables();
            this.m_installerDb.closeColumnReplacements();
            this.m_installerDb.fixData();
        }
        if (this.m_do_inserts) {
            this.m_installerDb.insertData();
        }
        if (this.m_update_unicode) {
            this.m_installerDb.checkUnicode();
        }
        if (this.m_do_vacuum) {
            this.m_installerDb.vacuumDatabase(this.m_do_full_vacuum);
        }
        if (this.m_install_webapp) {
            this.installWebApp();
        }
        if (this.m_tomcat_conf != null) {
            this.updateTomcatConf();
        }
        if (this.m_update_iplike) {
            this.m_installerDb.updateIplike();
        }
        this.m_installerDb.closeConnection();
        this.m_installerDb.closeAdminConnection();
        if (this.m_update_database) {
            this.createConfiguredFile();
        }
        this.m_out.println();
        this.m_out.println("Installer completed successfully!");
    }

    public void createConfiguredFile() throws IOException {
        File f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + "configured");
        f.createNewFile();
    }

    public void printHeader() {
        this.m_out.println("==============================================================================");
        this.m_out.println("OpenNMS Installer Version $Id: Installer.java 7383 2007-09-07 22:14:34Z rangerrick $");
        this.m_out.println("==============================================================================");
        this.m_out.println("");
        this.m_out.println("Configures PostgreSQL tables, users, and other miscellaneous settings.");
        this.m_out.println("");
    }

    public void loadProperties() throws Exception {
        this.m_properties = new Properties();
        this.m_properties.load(Installer.class.getResourceAsStream("installer.properties"));
        Properties sys = System.getProperties();
        this.m_properties.putAll((Map<?, ?>)sys);
        this.m_opennms_home = this.fetchProperty("install.dir");
        this.m_installerDb.setDatabaseName(this.fetchProperty("install.database.name"));
        this.m_installerDb.setPostgresOpennmsUser(this.fetchProperty("install.database.user"));
        this.m_installerDb.setPassword(this.fetchProperty("install.database.password"));
        this.m_pg_driver = this.fetchProperty("install.database.driver");
        this.m_pg_url = this.fetchProperty("install.database.url");
        this.m_installerDb.setProgresBinaryDirectory(this.fetchProperty("install.database.bindir"));
        String etcDirectory = this.fetchProperty("install.etc.dir");
        this.m_install_servletdir = this.fetchProperty("install.servlet.dir");
        String soext = this.fetchProperty("build.soext");
        String pg_iplike_dir = this.m_properties.getProperty("install.postgresql.dir");
        if (pg_iplike_dir != null) {
            this.m_installerDb.setPgIpLikeLocation(pg_iplike_dir + File.separator + "iplike." + soext);
        }
        this.m_installerDb.setStoredProcedureDirectory(etcDirectory);
        this.m_installerDb.setCreateSqlLocation(etcDirectory + File.separator + "create.sql");
    }

    public String fetchProperty(String property) throws Exception {
        String value = this.m_properties.getProperty(property);
        if (value == null) {
            throw new Exception("property \"" + property + "\" not set " + "from bundled installer.properties file");
        }
        return value;
    }

    public void parseArguments(String[] argv) throws Exception {
        LinkedList<String> args = new LinkedList<String>();
        for (int i = 0; i < argv.length; ++i) {
            StringBuffer b = new StringBuffer(argv[i]);
            boolean is_arg = false;
            while (b.length() > 0 && b.charAt(0) == '-') {
                is_arg = true;
                b.deleteCharAt(0);
            }
            if (is_arg) {
                block24: while (b.length() > 0) {
                    char c = b.charAt(0);
                    b.deleteCharAt(0);
                    switch (c) {
                        case 'h': {
                            this.printHelp();
                            continue block24;
                        }
                        case 'c': {
                            this.m_installerDb.setForce(true);
                            continue block24;
                        }
                        case 'C': {
                            this.m_fix_constraint = true;
                            this.m_fix_constraint_name = this.getNextArg(argv, ++i, 'C');
                            continue block24;
                        }
                        case 'd': {
                            this.m_update_database = true;
                            continue block24;
                        }
                        case 'D': {
                            this.m_pg_url = this.getNextArg(argv, ++i, 'D');
                            continue block24;
                        }
                        case 'i': {
                            this.m_do_inserts = true;
                            continue block24;
                        }
                        case 'l': {
                            this.m_library_search_path = this.getNextArg(argv, ++i, 'l');
                            continue block24;
                        }
                        case 'n': {
                            this.m_skip_constraints = true;
                        }
                        case 'N': {
                            this.m_installerDb.setIgnoreNotNull(true);
                            continue block24;
                        }
                        case 'p': {
                            this.m_pg_pass = this.getNextArg(argv, ++i, 'p');
                            continue block24;
                        }
                        case 'R': {
                            this.m_installerDb.setNoRevert(true);
                            continue block24;
                        }
                        case 's': {
                            this.m_update_iplike = true;
                            continue block24;
                        }
                        case 'T': {
                            this.m_tomcat_conf = this.getNextArg(argv, ++i, 'T');
                            continue block24;
                        }
                        case 'u': {
                            this.m_pg_user = this.getNextArg(argv, ++i, 'u');
                            this.m_installerDb.setPostgresAdminUser(this.m_pg_user);
                            continue block24;
                        }
                        case 'U': {
                            this.m_update_unicode = true;
                            continue block24;
                        }
                        case 'v': {
                            if (argv.length > i + 1 && argv[i + 1].equalsIgnoreCase("full")) {
                                ++i;
                                this.m_do_full_vacuum = true;
                            }
                            this.m_do_vacuum = true;
                            continue block24;
                        }
                        case 'w': {
                            this.m_webappdir = this.getNextArg(argv, ++i, 'w');
                            continue block24;
                        }
                        case 'x': {
                            this.m_installerDb.setDebug(true);
                            continue block24;
                        }
                        case 'X': {
                            this.m_fix_constraint_remove_rows = true;
                            continue block24;
                        }
                        case 'y': {
                            this.m_install_webapp = true;
                            continue block24;
                        }
                    }
                    throw new Exception("unknown option '" + c + "'" + ", use '-h' option for usage");
                }
                continue;
            }
            args.add(argv[i]);
        }
        if (args.size() != 0) {
            throw new Exception("too many command-line arguments specified");
        }
    }

    public String getNextArg(String[] argv, int i, char letter) throws Exception {
        if (i >= argv.length) {
            throw new Exception("no argument provided for '" + letter + "' option");
        }
        if (argv[i].charAt(0) == '-') {
            throw new Exception("argument to '" + letter + "' option looks " + "like another option (begins with a dash): \"" + argv[i] + "\"");
        }
        return argv[i];
    }

    public void printDiagnostics() {
        this.m_out.println("* using '" + this.m_installerDb.getPostgresOpennmsUser() + "' as the PostgreSQL " + "user for OpenNMS");
        this.m_out.println("* using '" + this.m_installerDb.getPassword() + "' as the PostgreSQL " + "password for OpenNMS");
        this.m_out.println("* using '" + this.m_installerDb.getDatabaseName() + "' as the PostgreSQL database name for OpenNMS");
    }

    public void verifyFilesAndDirectories() throws FileNotFoundException {
        if (this.m_update_database) {
            this.verifyFileExists(true, this.m_installerDb.getStoredProcedureDirectory(), "SQL directory", "install.etc.dir property");
            this.verifyFileExists(false, this.m_installerDb.getCreateSqlLocation(), "create.sql", "install.etc.dir property");
        }
        if (this.m_tomcat_conf != null) {
            this.verifyFileExists(false, this.m_tomcat_conf, "Tomcat startup configuration file tomcat4.conf", "-T option");
        }
        if (this.m_install_webapp) {
            this.verifyFileExists(true, this.m_webappdir, "Tomcat context directory", "-w option");
            this.verifyFileExists(true, this.m_install_servletdir, "OpenNMS servlet directory", "install.servlet.dir property");
        }
    }

    public void verifyFileExists(boolean isDir, String file, String description, String option) throws FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("The user most provide the location of " + description + ", but this is not specified.  " + "Use the " + option + " to specify this file.");
        }
        this.m_out.print("- using " + description + "... ");
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException(description + " does not exist at \"" + file + "\".  Use the " + option + " to specify another location.");
        }
        if (!isDir) {
            if (!f.isFile()) {
                throw new FileNotFoundException(description + " not a file at \"" + file + "\".  Use the " + option + " to specify another file.");
            }
        } else if (!f.isDirectory()) {
            throw new FileNotFoundException(description + " not a directory at \"" + file + "\".  Use the " + option + " to specify " + "another directory.");
        }
        this.m_out.println(f.getAbsolutePath());
    }

    public void checkWebappOldOpennmsDir() throws Exception {
        File f = new File(this.m_webappdir + File.separator + "opennms");
        this.m_out.print("- Checking for old opennms webapp directory in " + f.getAbsolutePath() + "... ");
        if (f.exists()) {
            throw new Exception("Old OpenNMS web application exists: " + f.getAbsolutePath() + ".  You need to remove this " + "before continuing.");
        }
        this.m_out.println("OK");
    }

    public void checkServerXmlOldOpennmsContext() throws Exception {
        String line;
        String search_regexp = "(?ms).*<Context\\s+path=\"/opennms\".*";
        StringBuffer b = new StringBuffer();
        File f = new File(this.m_webappdir + File.separator + ".." + File.separator + "conf" + File.separator + "server.xml");
        this.m_out.print("- Checking for old opennms context in " + f.getAbsolutePath() + "... ");
        if (!f.exists()) {
            this.m_out.println("DID NOT CHECK (file does not exist)");
            return;
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        while ((line = r.readLine()) != null) {
            b.append(line);
            b.append("\n");
        }
        r.close();
        if (b.toString().matches(search_regexp)) {
            throw new Exception("Old OpenNMS context found in " + f.getAbsolutePath() + ".  " + "You must remove this context from server.xml and re-run the " + "installer.");
        }
        this.m_out.println("OK");
    }

    public void installWebApp() throws Exception {
        this.m_out.println("- Install OpenNMS webapp... ");
        this.installLink(this.m_install_servletdir + File.separator + "META-INF" + File.separator + "context.xml", this.m_webappdir + File.separator + "opennms.xml", "web application context", false);
        this.m_out.println("- Installing OpenNMS webapp... DONE");
    }

    public void installLink(String source, String destination, String description, boolean recursive) throws Exception {
        ProcessExec e = new ProcessExec(this.m_out, this.m_out);
        if (new File(destination).exists()) {
            this.m_out.print("  - " + destination + " exists, removing... ");
            this.removeFile(destination, description, recursive);
            this.m_out.println("REMOVED");
        }
        this.m_out.print("  - creating link to " + destination + "... ");
        String[] cmd = new String[]{"ln", "-sf", source, destination};
        if (e.exec(cmd) != 0) {
            throw new Exception("Non-zero exit value returned while linking " + description + ", " + source + " into " + destination);
        }
        this.m_out.println("DONE");
    }

    public void updateTomcatConf() throws Exception {
        String line;
        File f = new File(this.m_tomcat_conf);
        this.m_out.print("- setting tomcat4 user to 'root'... ");
        BufferedReader r = new BufferedReader(new FileReader(f));
        StringBuffer b = new StringBuffer();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("TOMCAT_USER=")) {
                b.append("TOMCAT_USER=\"root\"\n");
                continue;
            }
            b.append(line);
            b.append("\n");
        }
        r.close();
        f.renameTo(new File(this.m_tomcat_conf + ".before-opennms-" + System.currentTimeMillis()));
        f = new File(this.m_tomcat_conf);
        PrintWriter w = new PrintWriter(new FileOutputStream(f));
        w.print(b.toString());
        w.close();
        this.m_out.println("done");
    }

    public void removeFile(String destination, String description, boolean recursive) throws IOException, InterruptedException, Exception {
        ProcessExec e = new ProcessExec(this.m_out, this.m_out);
        Object[] cmd = recursive ? new String[]{"rm", "-r", destination} : new String[]{"rm", destination};
        if (e.exec((String[])cmd) != 0) {
            throw new Exception("Non-zero exit value returned while removing " + description + ", " + destination + ", using \"" + StringUtils.arrayToDelimitedString((Object[])cmd, (String)" ") + "\"");
        }
        if (new File(destination).exists()) {
            throw new Exception("Could not delete existing " + description + ": " + destination);
        }
    }

    public void printHelp() {
        this.m_out.println("usage:");
        this.m_out.println("      $OPENNMS_HOME/bin/install -h");
        this.m_out.println("      $OPENNMS_HOME/bin/install [-r] [-x] [-N] [-R] [-c] [-d] [-i] [-s] [-U]");
        this.m_out.println("                                [-y] [-X]");
        this.m_out.println("                                [-u <PostgreSQL admin user>]");
        this.m_out.println("                                [-p <PostgreSQL admin password>]");
        this.m_out.println("                                [-D <PostgreSQL database URL>]");
        this.m_out.println("                                [-T <tomcat4.conf>]");
        this.m_out.println("                                [-w <tomcat context directory>");
        this.m_out.println("                                [-C <constraint>]");
        this.m_out.println("");
        this.m_out.println(this.m_required_options);
        this.m_out.println("");
        this.m_out.println("   -h    this help");
        this.m_out.println("");
        this.m_out.println("   -d    perform database actions");
        this.m_out.println("   -i    insert data into the database");
        this.m_out.println("   -s    update iplike postgres function");
        this.m_out.println("   -U    upgrade database to unicode, if needed");
        this.m_out.println("   -v    vacuum the database");
        this.m_out.println("   -y    install web application (see -w)");
        this.m_out.println("");
        this.m_out.println("   -u    username of the PostgreSQL administrator (default: \"" + this.m_pg_user + "\")");
        this.m_out.println("   -p    password of the PostgreSQL administrator (default: \"" + this.m_pg_pass + "\")");
        this.m_out.println("   -D    JDBC URL of the PostgreSQL database (default: \"" + this.m_pg_url + "\")");
        this.m_out.println("   -c    drop and recreate tables that already exist");
        this.m_out.println("");
        this.m_out.println("   -T    location of tomcat.conf");
        this.m_out.println("   -w    location of tomcat's context directory");
        this.m_out.println("         (usually under conf/Catalina/localhost)");
        this.m_out.println("");
        this.m_out.println("   -l    library search path");
        this.m_out.println("");
        this.m_out.println("   -r    run as an RPM install (does nothing)");
        this.m_out.println("   -x    turn on debugging for database data transformation");
        this.m_out.println("   -N    ignore NOT NULL constraint checks when transforming data");
        this.m_out.println("         useful after a table is reverted by a previous run of the installer");
        this.m_out.println("   -R    do not revert a table to the original if an error occurs when");
        this.m_out.println("         transforming data -- only used for debugging");
        this.m_out.println("   -C    fix rows that violate the specified constraint -- sets key column in");
        this.m_out.println("         affected rows to NULL by default");
        this.m_out.println("   -X    drop rows that violate constraint instead of marking key column in");
        this.m_out.println("         affected rows to NULL (used with \"-C\")");
        System.exit(0);
    }

    public static void main(String[] argv) throws Exception {
        new Installer().install(argv);
    }

    public String checkServerVersion() throws IOException {
        File catalinaHome = new File(this.m_webappdir).getParentFile();
        String readmeVersion = this.getTomcatVersion(new File(catalinaHome, "README.txt"));
        String runningVersion = this.getTomcatVersion(new File(catalinaHome, "RUNNING.txt"));
        if (readmeVersion == null && runningVersion == null) {
            return null;
        }
        if (readmeVersion != null && runningVersion != null) {
            return readmeVersion;
        }
        if (readmeVersion != null && runningVersion == null) {
            return readmeVersion;
        }
        return runningVersion;
    }

    public String getTomcatVersion(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        Pattern p = Pattern.compile("The Tomcat (\\S+) Servlet/JSP Container");
        BufferedReader in = new BufferedReader(new FileReader(file));
        for (int i = 0; i < 5; ++i) {
            String line = in.readLine();
            if (line == null) {
                in.close();
                return null;
            }
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            in.close();
            return m.group(1);
        }
        in.close();
        return null;
    }

    public String findLibrary(String libname, String path, boolean isRequired) throws Exception {
        String fullname = System.mapLibraryName(libname);
        String defaultPath = System.getProperty("java.library.path");
        if (defaultPath != null) {
            path = path != null ? path + File.pathSeparator + defaultPath : defaultPath;
        }
        if (path != null) {
            String[] paths = path.split(File.pathSeparator);
            this.m_out.println("- searching for " + libname + ":");
            for (int i = 0; i < paths.length; ++i) {
                String fullpath;
                File entry = new File(paths[i]);
                if (entry.isFile()) {
                    paths[i] = entry.getParent();
                }
                if (!this.loadLibrary(fullpath = paths[i] + File.separator + fullname)) continue;
                return fullpath;
            }
        }
        this.m_out.println("Failed to load the " + libname + " library.");
        if (isRequired) {
            this.m_out.println("It is required at runtime.  By default, we search the java library path:");
            for (String pathEntry : System.getProperty("java.library.path").split(File.pathSeparator)) {
                this.m_out.println("  " + pathEntry);
            }
            this.m_out.println("\nFor more information, see http://www.opennms.org/index.php/" + libname + "\n");
            throw new Exception("A fatal error occurred, exiting installer.");
        }
        this.m_out.println("This error is not fatal, since " + libname + " is only required for optional features.");
        this.m_out.println("For more information, see http://www.opennms.org/index.php/" + libname + "\n");
        return null;
    }

    public boolean loadLibrary(String path) {
        try {
            this.m_out.print("  - trying to load " + path + ": ");
            System.load(path);
            this.m_out.println("OK");
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            this.m_out.println("NO");
            return false;
        }
    }

    public void writeLibraryConfig(String jicmp_path, String jrrd_path) throws IOException {
        Properties libraryProps = new Properties();
        if (jicmp_path != null && jicmp_path.length() != 0) {
            libraryProps.put("opennms.library.jicmp", jicmp_path);
        }
        if (jrrd_path != null && jrrd_path.length() != 0) {
            libraryProps.put("opennms.library.jrrd", jrrd_path);
        }
        File f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + "libraries.properties");
        f.createNewFile();
        FileOutputStream os = new FileOutputStream(f);
        libraryProps.store(os, null);
    }

    public void pingLocalhost() throws IOException {
        String host = "127.0.0.1";
        IcmpSocket m_socket = null;
        try {
            m_socket = new IcmpSocket();
        }
        catch (UnsatisfiedLinkError e) {
            this.m_out.println("UnsatisfiedLinkError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.  Try setting the property 'opennms.library.jicmp' to point at the full path name of the libjicmp.so shared library (e.g. 'java -Dopennms.library.jicmp=/some/path/libjicmp.so ...')");
            throw e;
        }
        catch (NoClassDefFoundError e) {
            this.m_out.println("NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.so.");
            throw e;
        }
        catch (IOException e) {
            this.m_out.println("IOException while creating an IcmpSocket.");
            throw e;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            this.m_out.println("UnknownHostException when looking up " + host + ".");
            throw e;
        }
        this.m_out.println("PING " + host + " (" + addr.getHostAddress() + "): 56 data bytes");
        short m_icmpId = 2;
        Ping.Stuff s = new Ping.Stuff(m_socket, m_icmpId);
        Thread t = new Thread((Runnable)s);
        t.start();
        int count = 3;
        for (long attempt = 0L; attempt < (long)count; ++attempt) {
            ICMPEchoPacket pingPkt = new ICMPEchoPacket(attempt);
            pingPkt.setIdentity(m_icmpId);
            pingPkt.computeChecksum();
            byte[] buf = pingPkt.toBytes();
            DatagramPacket sendPkt = new DatagramPacket(buf, buf.length, addr, 0);
            buf = null;
            pingPkt = null;
            try {
                m_socket.send(sendPkt);
            }
            catch (IOException e) {
                this.m_out.println("IOException received when sending packet.");
                throw e;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public InstallerDb getInstallerDb() {
        return this.m_installerDb;
    }

    public void setOutputStream(PrintStream out) {
        this.m_out = out;
        this.m_installerDb.setOutputStream(this.m_out);
    }
}

