/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import org.opennms.netmgt.icmp.LogPrefixPreservingPingResponseCallback;
import org.opennms.netmgt.icmp.ParallelPingResponseCallback;
import org.opennms.netmgt.icmp.PingResponseCallback;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.SinglePingResponseCallback;
import org.opennms.netmgt.icmp.jni.JniPinger;
import org.opennms.netmgt.icmp.jni6.Jni6IcmpMessenger;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequest;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.opennms.protocols.rt.IDBasedRequestLocator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.Request;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.RequestTracker;

public class Jni6Pinger
implements Pinger {
    private final int m_pingerId = (int)(Math.random() * 32767.0);
    private JniPinger m_jniPinger;
    private RequestTracker<Jni6PingRequest, Jni6PingResponse> s_pingTracker;

    private synchronized void initialize4() throws IOException {
        if (this.m_jniPinger != null) {
            return;
        }
        this.m_jniPinger = new JniPinger();
    }

    private synchronized void initialize6() throws IOException {
        if (this.s_pingTracker != null) {
            return;
        }
        this.s_pingTracker = new RequestTracker("JNI-ICMPv6-" + this.m_pingerId, (Messenger)new Jni6IcmpMessenger(this.m_pingerId), (RequestLocator)new IDBasedRequestLocator());
        this.s_pingTracker.start();
    }

    public boolean isV4Available() {
        try {
            this.initialize4();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.m_jniPinger != null;
    }

    public boolean isV6Available() {
        try {
            this.initialize6();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.s_pingTracker != null;
    }

    public void ping(InetAddress host, long timeout, int retries, int sequenceId, PingResponseCallback cb) throws Exception {
        if (host instanceof Inet4Address) {
            this.initialize4();
            this.m_jniPinger.ping(host, timeout, retries, sequenceId, cb);
        } else {
            this.initialize6();
            this.s_pingTracker.sendRequest((Request)new Jni6PingRequest((Inet6Address)host, this.m_pingerId, sequenceId, timeout, retries, (PingResponseCallback)new LogPrefixPreservingPingResponseCallback(cb)));
        }
    }

    public Number ping(InetAddress host, long timeout, int retries) throws Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        this.ping(host, timeout, retries, 1, (PingResponseCallback)cb);
        cb.waitFor();
        cb.rethrowError();
        return cb.getResponseTime();
    }

    public Number ping(InetAddress host) throws Exception {
        return this.ping(host, 800L, 2);
    }

    public List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws Exception {
        if (host instanceof Inet4Address) {
            this.initialize4();
            return this.m_jniPinger.parallelPing(host, count, timeout, pingInterval);
        }
        this.initialize6();
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        long threadId = Jni6PingRequest.getNextTID();
        for (int seqNum = 0; seqNum < count; ++seqNum) {
            Jni6PingRequest request = new Jni6PingRequest((Inet6Address)host, this.m_pingerId, seqNum, threadId, timeout == 0L ? 800L : timeout, 0, (PingResponseCallback)cb);
            this.s_pingTracker.sendRequest((Request)request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }
}

