/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.opennms.jicmp.ip.ICMPEchoPacket;
import org.opennms.jicmp.ip.ICMPPacket;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;

class V4PingRequest
extends ICMPEchoPacket {
    public static final int PACKET_LENGTH = 64;
    public static final long COOKIE = 5724186650822398753L;
    public static final int OFFSET_COOKIE = 0;
    public static final int OFFSET_TIMESTAMP = 8;
    public static final int OFFSET_THREAD_ID = 16;
    public static final int DATA_LENGTH = 24;

    public V4PingRequest() {
        super(64);
        this.setType(ICMPPacket.Type.EchoRequest);
        this.setCode(0);
    }

    public V4PingRequest(int id, int seqNum, long threadId, int packetSize) {
        super(packetSize);
        this.setType(ICMPPacket.Type.EchoRequest);
        this.setCode(0);
        this.setIdentifier(id);
        this.setSequenceNumber(seqNum);
        this.setThreadId(threadId);
        this.setCookie();
        ByteBuffer buf = this.getContentBuffer();
        for (int b = 24; b < buf.limit(); ++b) {
            buf.put(b, (byte)b);
        }
    }

    public V4PingRequest(int id, int seqNum, long threadId) {
        super(64);
        this.setType(ICMPPacket.Type.EchoRequest);
        this.setCode(0);
        this.setIdentifier(id);
        this.setSequenceNumber(seqNum);
        this.setThreadId(threadId);
        this.setCookie();
        ByteBuffer buf = this.getContentBuffer();
        for (int b = 24; b < buf.limit(); ++b) {
            buf.put(b, (byte)b);
        }
    }

    public long getThreadId() {
        return this.getContentBuffer().getLong(16);
    }

    public void setThreadId(long threadId) {
        this.getContentBuffer().putLong(16, threadId);
    }

    public void setCookie() {
        this.getContentBuffer().putLong(0, 5724186650822398753L);
    }

    public NativeDatagramPacket toDatagramPacket(InetAddress destinationAddress) {
        this.getContentBuffer().putLong(8, System.nanoTime());
        return super.toDatagramPacket(destinationAddress);
    }

    public void send(NativeDatagramSocket socket, InetAddress addr) {
        socket.send(this.toDatagramPacket(addr));
    }
}

