/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jna;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.netmgt.icmp.EchoPacket;
import org.opennms.netmgt.icmp.jna.PingReplyListener;

public abstract class AbstractPinger<T extends InetAddress>
implements Runnable {
    public static final double NANOS_PER_MILLI = 1000000.0;
    private int m_pingerId;
    private NativeDatagramSocket m_pingSocket;
    private Thread m_thread;
    private final AtomicReference<Throwable> m_throwable = new AtomicReference<Object>(null);
    private volatile boolean m_stopped = false;
    private final List<PingReplyListener> m_listeners = new ArrayList<PingReplyListener>();

    protected AbstractPinger(int pingerId, NativeDatagramSocket pingSocket) {
        this.m_pingerId = pingerId;
        this.m_pingSocket = pingSocket;
    }

    protected NativeDatagramSocket getPingSocket() {
        return this.m_pingSocket;
    }

    protected int getPingerId() {
        return this.m_pingerId;
    }

    public boolean isFinished() {
        return this.m_stopped;
    }

    public void start() {
        this.m_thread = new Thread((Runnable)this, "JNA-ICMP-" + this.getClass().getSimpleName() + "-" + this.m_pingerId + "-Socket-Reader");
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public void stop() throws InterruptedException {
        this.m_stopped = true;
        if (this.m_thread != null) {
            this.m_thread.interrupt();
        }
        this.m_thread = null;
    }

    public void closeSocket() {
        if (this.getPingSocket() != null) {
            this.getPingSocket().close();
        }
    }

    public abstract void ping(T var1, int var2, int var3, long var4, long var6, long var8) throws InterruptedException;

    public void addPingReplyListener(PingReplyListener listener) {
        this.m_listeners.add(listener);
    }

    protected void notifyPingListeners(InetAddress address, EchoPacket echoReply) {
        for (PingReplyListener listener : this.m_listeners) {
            listener.onPingReply(address, echoReply);
        }
    }

    protected void setThrowable(Throwable e) {
        this.m_throwable.set(e);
    }
}

