/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import org.opennms.netmgt.icmp.Pinger;

public abstract class PingerFactory {
    private static Pinger m_pinger;

    public static Pinger getInstance() {
        if (m_pinger == null) {
            String pingerClassName = System.getProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jni6.Jni6Pinger");
            Class<Pinger> clazz = null;
            try {
                clazz = Class.forName(pingerClassName).asSubclass(Pinger.class);
                m_pinger = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to find class named " + pingerClassName, e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Error trying to create pinger of type " + clazz, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to create pinger of type " + clazz + ".  It does not appear to have a public constructor", e);
            }
        }
        return m_pinger;
    }

    public static void setInstance(Pinger pinger) {
        m_pinger = pinger;
    }

    protected static void reset() {
        m_pinger = null;
    }
}

