/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.opennms.netmgt.ping.PingReply;
import org.opennms.netmgt.ping.PingRequest;
import org.opennms.protocols.icmp.IcmpSocket;
import org.opennms.protocols.rt.Messenger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcmpMessenger
implements Messenger<PingRequest, PingReply> {
    IcmpSocket m_socket = new IcmpSocket();

    public IcmpSocket getIcmpSocket() {
        return this.m_socket;
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    void debugf(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)String.format(format, args));
        }
    }

    private void errorf(String format, Object ... args) {
        this.log().error((Object)String.format(format, args));
    }

    void errorf(Throwable t, String format, Object ... args) {
        this.log().error((Object)String.format(format, args), t);
    }

    void processPackets(Queue<PingReply> pendingReplies) {
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    PingReply reply;
                    if (!(reply = PingReply.create(packet = this.getIcmpSocket().receive())).isEchoReply() || reply.getIdentity() != PingRequest.FILTER_ID) {
                        continue;
                    }
                    this.debugf("Found an echo packet addr = %s, port = %d, length = %d, created reply %s", packet.getAddress(), packet.getPort(), packet.getLength(), reply);
                    pendingReplies.offer(reply);
                }
            }
            catch (IOException e) {
                this.errorf(e, "I/O Error occurred reading from ICMP Socket", new Object[0]);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable t) {
                this.errorf(t, "Unexpect Exception processing reply packet!", new Object[0]);
                continue;
            }
            break;
        }
    }

    public void sendRequest(PingRequest request) {
        request.sendRequest(this.getIcmpSocket());
    }

    public void start(final Queue<PingReply> replyQueue) {
        Thread socketReader = new Thread("ICMP-Socket-Reader"){

            public void run() {
                try {
                    IcmpMessenger.this.processPackets(replyQueue);
                }
                catch (Throwable t) {
                    IcmpMessenger.this.errorf(t, "Unexpected exception on Thread %s!", this);
                }
            }
        };
        socketReader.start();
    }
}

