/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.netmgt.ping.ParallelPingResponseCallback;
import org.opennms.netmgt.ping.PingRequest;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.ping.Reply;
import org.opennms.netmgt.ping.SinglePingResponseCallback;
import org.opennms.protocols.icmp.IcmpSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pinger {
    public static final int DEFAULT_TIMEOUT = 800;
    public static final int DEFAULT_RETRIES = 2;
    private static boolean s_initialized = false;
    private static IcmpSocket s_icmpSocket = null;
    private static Map<PingRequest.RequestId, PingRequest> s_pendingRequests;
    private static LinkedBlockingQueue<Reply> s_pendingReplyQueue;
    private static DelayQueue<PingRequest> s_timeoutQueue;
    private static Thread s_socketReader;
    private static Thread s_replyProcessor;
    private static Thread s_timeoutProcessor;

    public Pinger() throws IOException {
        Pinger.initialize();
    }

    public static synchronized void initialize() throws IOException {
        if (s_initialized) {
            return;
        }
        s_icmpSocket = new IcmpSocket();
        s_pendingRequests = Collections.synchronizedMap(new HashMap());
        s_pendingReplyQueue = new LinkedBlockingQueue();
        s_timeoutQueue = new DelayQueue();
        s_socketReader = new Thread("ICMP-Socket-Reader"){

            public void run() {
                try {
                    Pinger.processPackets();
                }
                catch (InterruptedException e) {
                    Pinger.errorf("Thread %s interrupted!", new Object[]{this});
                }
                catch (Throwable t) {
                    Pinger.errorf(t, "Unexpected exception on Thread %s!", new Object[]{this});
                }
            }
        };
        s_replyProcessor = new Thread("ICMP-Reply-Processor"){

            public void run() {
                try {
                    Pinger.processReplies();
                }
                catch (InterruptedException e) {
                    Pinger.errorf("Thread %s interrupted!", new Object[]{this});
                }
                catch (Throwable t) {
                    Pinger.errorf(t, "Unexpected exception on Thread %s!", new Object[]{this});
                }
            }
        };
        s_timeoutProcessor = new Thread("ICMP-Timeout-Processor"){

            public void run() {
                try {
                    Pinger.processTimeouts();
                }
                catch (InterruptedException e) {
                    Pinger.errorf("Thread %s interrupted!", new Object[]{this});
                }
                catch (Throwable t) {
                    Pinger.errorf(t, "Unexpected exception on Thread %s!", new Object[]{this});
                }
            }
        };
        s_timeoutProcessor.start();
        s_replyProcessor.start();
        s_socketReader.start();
        s_initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ping(PingRequest request) throws IOException {
        Pinger.initialize();
        Map<PingRequest.RequestId, PingRequest> map = s_pendingRequests;
        synchronized (map) {
            PingRequest oldRequest = s_pendingRequests.get(request.getId());
            if (oldRequest != null) {
                request.processError(new IllegalStateException("Duplicate ping request; keeping old request: " + oldRequest + "; removing new request: " + request));
                return;
            }
            s_pendingRequests.put(request.getId(), request);
            request.sendRequest(s_icmpSocket);
        }
        Pinger.debugf("Scheding timeout for request to %s in %d ms", request, request.getDelay(TimeUnit.MILLISECONDS));
        s_timeoutQueue.offer(request);
    }

    private static void processReplies() throws InterruptedException {
        while (true) {
            Reply reply = s_pendingReplyQueue.take();
            Pinger.debugf("Found a reply to process: %s", reply);
            PingRequest.RequestId id = new PingRequest.RequestId(reply);
            Pinger.debugf("Looking for request with Id: %s in map %s", id, s_pendingRequests);
            PingRequest request = s_pendingRequests.remove(id);
            if (request != null) {
                Pinger.processReply(reply, request);
                continue;
            }
            Pinger.debugf("No request found for reply %s", reply);
        }
    }

    private static void processReply(Reply reply, PingRequest request) {
        try {
            Pinger.debugf("Processing reply %s for request %s", reply, request);
            request.processResponse(reply.getPacket());
        }
        catch (Throwable t) {
            Pinger.errorf(t, "Unexpected error processingResponse to request: %s, reply is %s", request, reply);
        }
    }

    private static void processPackets() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    Reply reply;
                    if (!(reply = Reply.create(packet = s_icmpSocket.receive())).isEchoReply() || reply.getIdentity() != PingRequest.FILTER_ID) {
                        continue;
                    }
                    Pinger.debugf("Found an echo packet addr = %s, port = %d, length = %d, created reply %s", packet.getAddress(), packet.getPort(), packet.getLength(), reply);
                    s_pendingReplyQueue.offer(reply);
                }
            }
            catch (IOException e) {
                Pinger.errorf(e, "I/O Error occurred reading from ICMP Socket", new Object[0]);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable t) {
                Pinger.errorf(t, "Unexpect Exception processing reply packet!", new Object[0]);
                continue;
            }
            break;
        }
    }

    private static void processTimeouts() throws InterruptedException {
        while (true) {
            PingRequest timedOutRequest = (PingRequest)s_timeoutQueue.take();
            Pinger.debugf("Found a possibly timedout request: %s", timedOutRequest);
            PingRequest pendingRequest = s_pendingRequests.remove(timedOutRequest.getId());
            if (pendingRequest == timedOutRequest) {
                PingRequest retry = Pinger.processTimeout(timedOutRequest);
                if (retry == null) continue;
                try {
                    Pinger.ping(retry);
                }
                catch (Exception e) {
                    retry.processError(e);
                }
                continue;
            }
            if (pendingRequest == null) continue;
            Pinger.errorf("Uh oh! A pending request %s with the same id exists but is not the timout request %s from the queue!", pendingRequest, timedOutRequest);
        }
    }

    private static PingRequest processTimeout(PingRequest request) {
        try {
            Pinger.debugf("Processing timeout for: %s", request);
            return request.processTimeout();
        }
        catch (Throwable t) {
            Pinger.errorf(t, "Unexpected error processingTimout to request: %s", request);
            return null;
        }
    }

    public static void ping(InetAddress host, long timeout, int retries, short sequenceId, PingResponseCallback cb) throws IOException {
        Pinger.ping(new PingRequest(host, sequenceId, timeout, retries, cb));
    }

    public static Long ping(InetAddress host, long timeout, int retries) throws InterruptedException, IOException {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        Pinger.ping(host, timeout, retries, (short)1, cb);
        cb.waitFor();
        return cb.getResponseTime();
    }

    public static Long ping(InetAddress host) throws IOException, InterruptedException {
        return Pinger.ping(host, 800L, 2);
    }

    public static List<Number> parallelPing(InetAddress host, int count, long timeout, long pingInterval) throws IOException, InterruptedException {
        ParallelPingResponseCallback cb = new ParallelPingResponseCallback(count);
        if (timeout == 0L) {
            timeout = 800L;
        }
        for (int i = 0; i < count; ++i) {
            PingRequest request = new PingRequest(host, (short)i, timeout, 0, cb);
            Pinger.ping(request);
            Thread.sleep(pingInterval);
        }
        cb.waitFor();
        return cb.getResponseTimes();
    }

    private static Category log() {
        return Logger.getLogger((String)"Pinger");
    }

    private static void debugf(String format, Object ... args) {
        if (Pinger.log().isDebugEnabled()) {
            Pinger.log().debug((Object)String.format(format, args));
        }
    }

    private static void errorf(String format, Object ... args) {
        Pinger.log().error((Object)String.format(format, args));
    }

    private static void errorf(Throwable t, String format, Object ... args) {
        Pinger.log().error((Object)String.format(format, args), t);
    }
}

