/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Random;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.ping.Reply;
import org.opennms.protocols.icmp.ICMPEchoPacket;
import org.opennms.protocols.icmp.IcmpSocket;

public final class PingRequest
implements Delayed {
    public static final short FILTER_ID = (short)new Random(System.currentTimeMillis()).nextInt();
    private static final short DEFAULT_SEQUENCE_ID = 1;
    private static long s_nextTid = 1L;
    private RequestId m_id;
    private ICMPEchoPacket m_request = null;
    private ICMPEchoPacket m_response = null;
    private PingResponseCallback m_callback = null;
    private int m_retries;
    private long m_timeout;
    private long m_expiration = -1L;
    private Category m_log = ThreadCategory.getInstance(this.getClass());

    PingRequest(InetAddress addr, long tid, short sequenceId, long timeout, int retries, Category logger, PingResponseCallback cb) {
        this.m_id = new RequestId(addr, tid, sequenceId);
        this.m_retries = retries;
        this.m_timeout = timeout;
        this.m_log = logger;
        this.m_callback = new LogPrefixPreservingCallbackAdapter(cb);
    }

    PingRequest(InetAddress addr, long tid, short sequenceId, long timeout, int retries, PingResponseCallback cb) {
        this(addr, tid, sequenceId, timeout, retries, ThreadCategory.getInstance(PingRequest.class), cb);
    }

    PingRequest(InetAddress addr, short sequenceId, long timeout, int retries, PingResponseCallback cb) {
        this(addr, s_nextTid++, sequenceId, timeout, retries, cb);
    }

    PingRequest(InetAddress addr, long timeout, int retries, PingResponseCallback cb) {
        this(addr, 1, timeout, retries, cb);
    }

    public InetAddress getAddress() {
        return this.m_id.getAddress();
    }

    public long getTid() {
        return this.m_id.getTid();
    }

    public short getSequenceId() {
        return this.m_id.getSequenceId();
    }

    public int getRetries() {
        return this.m_retries;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public ICMPEchoPacket getRequest() {
        return this.m_request;
    }

    public ICMPEchoPacket getResponse() {
        return this.m_response;
    }

    public long getExpiration() {
        return this.m_expiration;
    }

    boolean isTarget(InetAddress addr, short sequenceId) {
        return this.getAddress().equals(addr) && this.getSequenceId() == sequenceId;
    }

    public void sendRequest(IcmpSocket icmpSocket) {
        try {
            this.createRequestPacket();
            this.log().debug((Object)(System.currentTimeMillis() + ": Sending Ping Request: " + this));
            icmpSocket.send(this.createDatagram());
        }
        catch (Throwable t) {
            this.m_callback.handleError(this.getAddress(), this.getRequest(), t);
        }
    }

    private Category log() {
        return this.m_log;
    }

    private DatagramPacket createDatagram() {
        byte[] data = this.m_request.toBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.getAddress(), 0);
        return packet;
    }

    public void createRequestPacket() {
        this.m_expiration = System.currentTimeMillis() + this.m_timeout;
        ICMPEchoPacket iPkt = new ICMPEchoPacket(this.getTid());
        iPkt.setIdentity(FILTER_ID);
        iPkt.setSequenceId(this.getSequenceId());
        iPkt.computeChecksum();
        this.m_request = iPkt;
    }

    public void processResponse(ICMPEchoPacket packet) {
        this.m_response = packet;
        this.log().debug((Object)(System.currentTimeMillis() + ": Ping Response Received " + this));
        this.m_callback.handleResponse(this.getAddress(), packet);
    }

    public PingRequest processTimeout() {
        PingRequest returnval = null;
        if (this.isExpired()) {
            if (this.getRetries() > 0) {
                returnval = new PingRequest(this.getAddress(), this.getTid(), this.getSequenceId(), this.getTimeout(), this.getRetries() - 1, this.log(), this.m_callback);
                this.log().debug((Object)(System.currentTimeMillis() + ": Retrying Ping Request " + returnval));
            } else {
                this.log().debug((Object)(System.currentTimeMillis() + ": Ping Request Timed out " + this));
                this.m_callback.handleTimeout(this.getAddress(), this.getRequest());
            }
        }
        return returnval;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.getExpiration();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("ID=").append(this.getId()).append(',');
        sb.append("Retries=").append(this.getRetries()).append(",");
        sb.append("Timeout=").append(this.getTimeout()).append(",");
        sb.append("Expiration=").append(this.getExpiration()).append(',');
        sb.append("Callback=").append(this.m_callback);
        sb.append("]");
        return sb.toString();
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getExpiration() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed request) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = request.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay == otherDelay) {
            return 0;
        }
        return 1;
    }

    public RequestId getId() {
        return this.m_id;
    }

    public void processError(Throwable t) {
        this.m_callback.handleError(this.getAddress(), this.getRequest(), t);
    }

    static class LogPrefixPreservingCallbackAdapter
    implements PingResponseCallback {
        private PingResponseCallback m_cb;
        private String m_prefix = ThreadCategory.getPrefix();

        public LogPrefixPreservingCallbackAdapter(PingResponseCallback cb) {
            this.m_cb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleError(InetAddress address, ICMPEchoPacket packet, Throwable t) {
            String oldPrefix = ThreadCategory.getPrefix();
            try {
                ThreadCategory.setPrefix((String)this.m_prefix);
                this.m_cb.handleError(address, packet, t);
            }
            finally {
                ThreadCategory.setPrefix((String)oldPrefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
            String oldPrefix = ThreadCategory.getPrefix();
            try {
                ThreadCategory.setPrefix((String)this.m_prefix);
                this.m_cb.handleResponse(address, packet);
            }
            finally {
                ThreadCategory.setPrefix((String)oldPrefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
            String oldPrefix = ThreadCategory.getPrefix();
            try {
                ThreadCategory.setPrefix((String)this.m_prefix);
                this.m_cb.handleTimeout(address, packet);
            }
            finally {
                ThreadCategory.setPrefix((String)oldPrefix);
            }
        }
    }

    public static class RequestId {
        InetAddress m_addr;
        long m_tid;
        short m_seqId;

        public RequestId(InetAddress addr, long tid, short seqId) {
            this.m_addr = addr;
            this.m_tid = tid;
            this.m_seqId = seqId;
        }

        public RequestId(Reply reply) {
            this(reply.getAddress(), reply.getPacket().getTID(), reply.getPacket().getSequenceId());
        }

        public InetAddress getAddress() {
            return this.m_addr;
        }

        public long getTid() {
            return this.m_tid;
        }

        public short getSequenceId() {
            return this.m_seqId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RequestId) {
                RequestId id = (RequestId)obj;
                return this.getAddress().equals(id.getAddress()) && this.getTid() == id.getTid() && this.getSequenceId() == id.getSequenceId();
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.m_addr.hashCode();
            hash = hash * 31 + (int)(this.m_tid >>> 32);
            hash = hash * 31 + (int)this.m_tid;
            hash = hash * 31 + this.m_seqId;
            return hash;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append('[');
            buf.append("addr = ").append(this.m_addr);
            buf.append(", ");
            buf.append("tid = ").append(this.m_tid);
            buf.append(", ");
            buf.append("seqId = ").append(this.m_seqId);
            buf.append(']');
            return buf.toString();
        }
    }
}

