/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public class SinglePingResponseCallback
implements PingResponseCallback {
    BarrierSignaler bs = new BarrierSignaler(1);
    Throwable error = null;
    Long responseTime = null;

    public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
        this.info("got response for " + packet.getTID() + "/" + packet.getSequenceId() + " with a responseTime " + packet.getPingRTT());
        this.responseTime = packet.getPingRTT();
        this.bs.signalAll();
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
        this.info("timed out pinging " + packet.getTID() + "/" + packet.getSequenceId());
        this.bs.signalAll();
    }

    public void handleError(InetAddress address, ICMPEchoPacket pr, Throwable t) {
        this.info("an error occurred pinging " + address, t);
        this.error = t;
        this.bs.signalAll();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.bs.waitFor(timeout);
    }

    public void waitFor() throws InterruptedException {
        this.info("waiting to finish");
        this.bs.waitFor();
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public void info(String msg) {
        this.log().info((Object)msg);
    }

    public void info(String msg, Throwable t) {
        this.log().info((Object)msg, t);
    }
}

