/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.protocols.icmp.ICMPEchoPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelPingResponseCallback
implements PingResponseCallback {
    BarrierSignaler bs;
    Number[] m_responseTimes;

    public ParallelPingResponseCallback(int count) {
        this.bs = new BarrierSignaler(count);
        this.m_responseTimes = new Number[count];
    }

    @Override
    public void handleError(InetAddress address, ICMPEchoPacket packet, Throwable t) {
        this.m_responseTimes[packet.getSequenceId()] = null;
        this.bs.signalAll();
    }

    @Override
    public void handleResponse(InetAddress address, ICMPEchoPacket packet) {
        this.m_responseTimes[packet.getSequenceId()] = packet.getPingRTT();
        this.bs.signalAll();
    }

    @Override
    public void handleTimeout(InetAddress address, ICMPEchoPacket packet) {
        this.m_responseTimes[packet.getSequenceId()] = null;
        this.bs.signalAll();
    }

    public void waitFor() throws InterruptedException {
        this.bs.waitFor();
    }

    public List<Number> getResponseTimes() {
        return Arrays.asList(this.m_responseTimes);
    }
}

