/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.provision.DnsRecord;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimpleQueuedProvisioningAdapter;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Update;

public class DnsProvisioningAdapter
extends SimpleQueuedProvisioningAdapter
implements InitializingBean {
    private NodeDao m_nodeDao;
    private EventForwarder m_eventForwarder;
    private Resolver m_resolver = null;
    private String m_signature;
    private TransactionTemplate m_template;
    private static final String MESSAGE_PREFIX = "Dynamic DNS provisioning failed: ";
    private static final String ADAPTER_NAME = "DNS Provisioning Adapter";
    private static volatile ConcurrentMap<Integer, DnsRecord> m_nodeDnsRecordMap;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_nodeDao, (String)"DnsProvisioner requires a NodeDao which is not null.");
        this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg0) {
                DnsProvisioningAdapter.this.createDnsRecordMap();
                return null;
            }
        });
        String dnsServer = System.getProperty("importer.adapter.dns.server");
        if (!StringUtils.isBlank((String)dnsServer)) {
            DnsProvisioningAdapter.log().info("DNS property found: " + dnsServer);
            if (dnsServer.contains(":")) {
                String[] serverAddress = dnsServer.split(":");
                this.m_resolver = new SimpleResolver(serverAddress[0]);
                this.m_resolver.setPort(Integer.valueOf(serverAddress[1]).intValue());
            } else {
                this.m_resolver = new SimpleResolver(dnsServer);
            }
            String key = System.getProperty("importer.adapter.dns.privatekey");
            if (key != null && key.length() > 0) {
                this.m_signature = key;
                this.m_resolver.setTSIGKey(TSIG.fromString((String)this.m_signature));
            }
        } else {
            DnsProvisioningAdapter.log().warn("no DNS server configured, DnsProvisioningAdapter will not do anything!");
        }
    }

    private void createDnsRecordMap() {
        List nodes = this.m_nodeDao.findAllProvisionedNodes();
        m_nodeDnsRecordMap = new ConcurrentHashMap<Integer, DnsRecord>(nodes.size());
        for (OnmsNode onmsNode : nodes) {
            m_nodeDnsRecordMap.putIfAbsent(onmsNode.getId(), new DnsRecord(onmsNode));
        }
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    @Override
    public String getName() {
        return ADAPTER_NAME;
    }

    @Override
    public boolean isNodeReady(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        return true;
    }

    @Override
    public void processPendingOperationForNode(final SimpleQueuedProvisioningAdapter.AdapterOperation op) throws ProvisioningAdapterException {
        if (this.m_resolver == null) {
            return;
        }
        DnsProvisioningAdapter.log().info("processPendingOperationForNode: Handling Operation: " + op);
        if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.ADD || op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.UPDATE) {
            this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus arg0) {
                    DnsProvisioningAdapter.this.doUpdate(op);
                    return null;
                }
            });
        } else if (op.getType() == SimpleQueuedProvisioningAdapter.AdapterOperationType.DELETE) {
            this.m_template.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus arg0) {
                    DnsProvisioningAdapter.this.doDelete(op);
                    return null;
                }
            });
        } else if (op.getType() != SimpleQueuedProvisioningAdapter.AdapterOperationType.CONFIG_CHANGE) {
            DnsProvisioningAdapter.log().warn("unknown operation: " + (Object)((Object)op.getType()));
        }
    }

    private void doUpdate(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        OnmsNode node = null;
        DnsProvisioningAdapter.log().debug("doUpdate: operation: " + op.getType().name());
        try {
            node = (OnmsNode)this.m_nodeDao.get((Serializable)op.getNodeId());
            DnsRecord record = new DnsRecord(node);
            DnsProvisioningAdapter.log().debug("doUpdate: DnsRecord: hostname: " + record.getHostname() + " zone: " + record.getZone() + " ip address " + record.getIp().getHostAddress());
            DnsRecord oldRecord = (DnsRecord)m_nodeDnsRecordMap.get((int)node.getId());
            Update update = new Update(Name.fromString((String)record.getZone()));
            if (oldRecord != null && oldRecord.getHostname() != record.getHostname()) {
                update.delete(Name.fromString((String)oldRecord.getHostname()), 1);
            }
            update.replace(Name.fromString((String)record.getHostname()), 1, 3600L, record.getIp().getHostAddress());
            this.m_resolver.send((Message)update);
            m_nodeDnsRecordMap.put((int)op.getNodeId(), record);
        }
        catch (Throwable e) {
            DnsProvisioningAdapter.log().error("addNode: Error handling node added event.", e);
            this.sendAndThrow(op.getNodeId(), e);
        }
    }

    private void doDelete(SimpleQueuedProvisioningAdapter.AdapterOperation op) {
        try {
            DnsRecord record = (DnsRecord)m_nodeDnsRecordMap.get((int)op.getNodeId());
            if (record != null) {
                Update update = new Update(Name.fromString((String)record.getZone()));
                update.delete(Name.fromString((String)record.getHostname()), 1);
                this.m_resolver.send((Message)update);
                m_nodeDnsRecordMap.remove((int)op.getNodeId());
            }
        }
        catch (Throwable e) {
            DnsProvisioningAdapter.log().error("deleteNode: Error handling node deleted event.", e);
            this.sendAndThrow(op.getNodeId(), e);
        }
    }

    private void sendAndThrow(int nodeId, Throwable e) {
        String message = e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage();
        Event event = this.buildEvent("uei.opennms.org/provisioner/provisioningAdapterFailed", nodeId).addParam("reason", MESSAGE_PREFIX + e.getClass().getName() + message).getEvent();
        this.m_eventForwarder.sendNow(event);
        throw new ProvisioningAdapterException(MESSAGE_PREFIX, e);
    }

    private EventBuilder buildEvent(String uei, int nodeId) {
        EventBuilder builder = new EventBuilder(uei, "Provisioner", new Date());
        builder.setNodeid((long)nodeId);
        return builder;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(DnsProvisioningAdapter.class);
    }

    public void setTemplate(TransactionTemplate template) {
        this.m_template = template;
    }

    public TransactionTemplate getTemplate() {
        return this.m_template;
    }
}

